/*
 * Decompiled with CFR 0.152.
 */
package io.github.stainlessstasis.util;

import com.cobblemon.mod.common.api.abilities.Abilities;
import com.cobblemon.mod.common.api.abilities.AbilityTemplate;
import com.cobblemon.mod.common.api.abilities.PotentialAbility;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.pokemon.abilities.HiddenAbilityType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class HiddenAbilityUtil {
    public static boolean hasHiddenAbility(Species species, String abilityID) {
        int[] numAbilities = new int[]{0};
        HashSet abilities = new HashSet();
        species.getAbilities().iterator().forEachRemaining(potentialAbility -> {
            String abilityName = potentialAbility.getTemplate().getName();
            if (abilities.contains(abilityName)) {
                return;
            }
            abilities.add(abilityName);
            numAbilities[0] = numAbilities[0] + 1;
        });
        if (numAbilities[0] < 2) {
            return false;
        }
        Set hiddenAbilityNames = species.getAbilities().getMapping().values().stream().flatMap(Collection::stream).filter(ability -> ability.getType() == HiddenAbilityType.INSTANCE).map(PotentialAbility::getTemplate).map(AbilityTemplate::getName).collect(Collectors.toSet());
        AbilityTemplate ability2 = Abilities.get((String)abilityID);
        if (ability2 == null) {
            return false;
        }
        String abilityName = ability2.getName();
        return hiddenAbilityNames.contains(abilityName);
    }

    public static boolean hasHiddenAbility(int dexID, String abilityID) {
        Species species = PokemonSpecies.getByPokedexNumber((int)dexID, (String)"cobblemon");
        if (species == null) {
            return false;
        }
        return HiddenAbilityUtil.hasHiddenAbility(species, abilityID);
    }
}

