/*
 * Decompiled with CFR 0.152.
 */
package io.github.stainlessstasis;

import com.cobblemon.mod.common.api.scheduling.ScheduledTask;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import io.github.stainlessstasis.CSAFabricClient;
import io.github.stainlessstasis.alert.DespawnReason;
import io.github.stainlessstasis.core.CobblemonSpawnAlerts;
import io.github.stainlessstasis.platform.IPlatformHelper;
import io.github.stainlessstasis.platform.Platform;
import io.github.stainlessstasis.util.AlertUtil;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.UUID;
import kotlin.Unit;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class FabricPlatformHelper
implements IPlatformHelper {
    @Override
    public Platform getPlatform() {
        return Platform.FABRIC;
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public Path getConfigDir() {
        return FabricLoader.getInstance().getConfigDir();
    }

    @Override
    public void onPokemonSpawned(PokemonEntity pokemonEntity) {
        ScheduledTask _task = new ScheduledTask.Builder().delay(0.05f).execute(task -> {
            HashSet<UUID> alreadyAlerted = new HashSet<UUID>();
            for (class_3222 player : PlayerLookup.tracking((class_1297)pokemonEntity)) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)CobblemonSpawnAlerts.createPokemonData(pokemonEntity));
                alreadyAlerted.add(player.method_5667());
            }
            if (!AlertUtil.shouldGlobalAlert(pokemonEntity)) {
                return Unit.INSTANCE;
            }
            CobblemonSpawnAlerts.globallyAlerted.add(pokemonEntity.getPokemon().getUuid());
            class_1937 patt0$temp = pokemonEntity.method_37908();
            if (patt0$temp instanceof class_3218) {
                class_3218 level = (class_3218)patt0$temp;
                for (class_3222 player : level.method_18456()) {
                    if (alreadyAlerted.contains(player.method_5667())) continue;
                    ServerPlayNetworking.send((class_3222)player, (class_8710)CobblemonSpawnAlerts.createAlertData(pokemonEntity));
                }
            }
            return Unit.INSTANCE;
        }).build();
    }

    @Override
    public void onPokemonDespawned(class_1937 _level, Pokemon pokemon, String playerName, DespawnReason despawnReason) {
        IPlatformHelper.super.onPokemonDespawned(_level, pokemon, playerName, despawnReason);
        if (_level instanceof class_3218) {
            class_3218 level = (class_3218)_level;
            for (class_3222 player : level.method_18456()) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)CobblemonSpawnAlerts.createDespawnData(pokemon, playerName, despawnReason));
            }
        }
    }

    @Override
    public boolean doesServerHaveMod() {
        return CSAFabricClient.doesServerHaveMod;
    }
}

