/*
 * Decompiled with CFR 0.152.
 */
package io.github.stainlessstasis.util;

import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.pokemon.EVs;
import com.cobblemon.mod.common.pokemon.stat.CobblemonStatProvider;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.stainlessstasis.core.CobblemonSpawnAlerts;
import io.github.stainlessstasis.platform.Services;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class EvsUtil {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<Integer, EVs> cache = new HashMap<Integer, EVs>();

    public static EVs getEVsFromYield(Map<Stat, Integer> evYield) {
        EVs finalEvYield = CobblemonStatProvider.INSTANCE.createEmptyEVs();
        for (Stat stat : evYield.keySet()) {
            finalEvYield.add(stat, evYield.get(stat).intValue());
        }
        return finalEvYield;
    }

    public static EVs getYield(int dexNumber) {
        if (cache.containsKey(dexNumber)) {
            return cache.get(dexNumber);
        }
        Optional resource = class_310.method_1551().method_1478().method_14486(class_2960.method_60655((String)"cobblemon_spawn_alerts", (String)"evyields.json"));
        if (resource.isEmpty()) {
            return EVs.createEmpty();
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(((class_3298)resource.get()).method_14482(), StandardCharsets.UTF_8));
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            JsonObject rootObject = jsonElement.getAsJsonObject();
            if (rootObject.has(String.valueOf(dexNumber))) {
                JsonObject evYieldObject = rootObject.getAsJsonObject(String.valueOf(dexNumber));
                EVYield evYield = (EVYield)GSON.fromJson((JsonElement)evYieldObject, EVYield.class);
                EVs evs = EVs.createEmpty();
                evs.set((Stat)Stats.HP, evYield.hp);
                evs.set((Stat)Stats.ATTACK, evYield.attack);
                evs.set((Stat)Stats.DEFENCE, evYield.defence);
                evs.set((Stat)Stats.SPECIAL_ATTACK, evYield.special_attack);
                evs.set((Stat)Stats.SPECIAL_DEFENCE, evYield.special_defence);
                evs.set((Stat)Stats.SPEED, evYield.speed);
                cache.put(dexNumber, evs);
                return evs;
            }
        }
        catch (IOException e) {
            CobblemonSpawnAlerts.LOGGER.error("Could not create reader for file `evyields.json`: " + String.valueOf(e));
        }
        return EVs.createEmpty();
    }

    public static void clearCache() {
        cache.clear();
    }

    public static void loadEVYieldsToFile() throws IOException {
        if (!Services.PLATFORM.isDevelopmentEnvironment()) {
            return;
        }
        System.out.println("LOADING ALL EV YIELDS");
        class_3300 resourceManager = class_310.method_1551().method_1576().method_34864();
        System.out.println("RESOURCE MANAGER: " + String.valueOf(resourceManager));
        HashMap<Integer, EVYield> loadedEVYields = new HashMap<Integer, EVYield>();
        Map speciesJsonLocations = resourceManager.method_14488("species", location -> location.method_12836().equals("cobblemon") && location.method_12832().endsWith(".json"));
        System.out.println("JSON FILES: " + String.valueOf(speciesJsonLocations));
        for (class_2960 location2 : speciesJsonLocations.keySet()) {
            System.out.println("RESOURCE LOCATION: " + String.valueOf(location2));
            class_3298 resource = (class_3298)resourceManager.method_14486(location2).get();
            BufferedReader reader = new BufferedReader(new InputStreamReader(resource.method_14482(), StandardCharsets.UTF_8));
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            JsonObject rootObject = jsonElement.getAsJsonObject();
            if (rootObject.has("evYield")) {
                JsonObject evYieldObject = rootObject.getAsJsonObject("evYield");
                int dexNumber = rootObject.get("nationalPokedexNumber").getAsInt();
                EVYield evYield = (EVYield)GSON.fromJson((JsonElement)evYieldObject, EVYield.class);
                loadedEVYields.put(dexNumber, evYield);
                System.out.println("Successfully parsed EVs for " + location2.method_12832() + ": " + String.valueOf(evYield));
            }
            reader.close();
        }
        System.out.println(loadedEVYields);
        String output = GSON.toJson(loadedEVYields);
        Path outputFile = Paths.get("evyields.json", new String[0]);
        FileWriter writer = new FileWriter(outputFile.toFile());
        writer.write(output);
        writer.close();
    }

    public static void print(EVs evs) {
        evs.iterator().forEachRemaining(ev -> CobblemonSpawnAlerts.LOGGER.info(String.valueOf(((Stat)ev.getKey()).getDisplayName()) + " | " + String.valueOf(ev.getValue())));
    }

    private record EVYield(int hp, int attack, int defence, int special_attack, int special_defence, int speed) {
    }
}

