/*
 * Decompiled with CFR 0.152.
 */
package io.github.stainlessstasis;

import com.cobblemon.mod.common.api.scheduling.ScheduledTask;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import io.github.stainlessstasis.CSANeoClient;
import io.github.stainlessstasis.alert.DespawnReason;
import io.github.stainlessstasis.core.CobblemonSpawnAlerts;
import io.github.stainlessstasis.platform.IPlatformHelper;
import io.github.stainlessstasis.platform.Platform;
import io.github.stainlessstasis.util.AlertUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import kotlin.Unit;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkSource;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.network.PacketDistributor;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    @Override
    public Platform getPlatform() {
        return Platform.NEOFORGE;
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public void onPokemonSpawned(PokemonEntity pokemonEntity) {
        ScheduledTask _task = new ScheduledTask.Builder().delay(0.5f).execute(task -> {
            HashSet<UUID> alreadyAlerted = new HashSet<UUID>();
            List players = new ArrayList();
            ChunkSource patt0$temp = pokemonEntity.level().getChunkSource();
            if (patt0$temp instanceof ServerChunkCache) {
                ServerChunkCache chunkCache = (ServerChunkCache)patt0$temp;
                players = chunkCache.chunkMap.getPlayersCloseForSpawning(pokemonEntity.chunkPosition());
            }
            for (ServerPlayer player : players) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)CobblemonSpawnAlerts.createPokemonData(pokemonEntity), (CustomPacketPayload[])new CustomPacketPayload[0]);
                alreadyAlerted.add(player.getUUID());
            }
            if (!AlertUtil.shouldGlobalAlert(pokemonEntity)) {
                return Unit.INSTANCE;
            }
            CobblemonSpawnAlerts.globallyAlerted.add(pokemonEntity.getPokemon().getUuid());
            Level patt1$temp = pokemonEntity.level();
            if (patt1$temp instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)patt1$temp;
                for (ServerPlayer player : level.players()) {
                    if (alreadyAlerted.contains(player.getUUID())) continue;
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)CobblemonSpawnAlerts.createAlertData(pokemonEntity), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            return Unit.INSTANCE;
        }).build();
    }

    @Override
    public void onPokemonDespawned(Level _level, Pokemon pokemon, String playerName, DespawnReason despawnReason) {
        IPlatformHelper.super.onPokemonDespawned(_level, pokemon, playerName, despawnReason);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)CobblemonSpawnAlerts.createDespawnData(pokemon, playerName, despawnReason), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public boolean doesServerHaveMod() {
        return CSANeoClient.doesServerHaveMod;
    }
}

