/*
 * Decompiled with CFR 0.152.
 */
package io.github.stainlessstasis.mixin;

import com.cobblemon.mod.common.PlayerSpawnerAccessor;
import com.cobblemon.mod.common.api.events.Cancelable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.entity.SpawnEvent;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.position.BasicSpawnablePosition;
import com.cobblemon.mod.common.api.spawning.position.SpawnablePosition;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.cobblemon.mod.common.command.SpawnPokemon;
import com.cobblemon.mod.common.command.argument.PokemonPropertiesArgumentType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.github.stainlessstasis.core.CobblemonSpawnAlerts;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Unit;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpawnPokemon.class})
public abstract class PokemonSpawnCommandMixin {
    @Unique
    private SimpleCommandExceptionType NO_SPECIES_EXCEPTION = new SimpleCommandExceptionType((Message)LocalizationUtilsKt.commandLang((String)"${NAME}.nospecies", (Object[])new Object[0]).withStyle(ChatFormatting.RED));
    @Unique
    private SimpleCommandExceptionType INVALID_POS_EXCEPTION = new SimpleCommandExceptionType((Message)Component.literal((String)"Invalid position").withStyle(ChatFormatting.RED));
    @Unique
    private SimpleCommandExceptionType FAILED_SPAWN_EXCEPTION = new SimpleCommandExceptionType((Message)Component.literal((String)"Unable to spawn at the given position").withStyle(ChatFormatting.RED));

    @Inject(method={"execute(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/world/phys/Vec3;)I"}, at={@At(value="HEAD")}, cancellable=true)
    private void execute(CommandContext<CommandSourceStack> context, Vec3 pos, CallbackInfoReturnable<Integer> cir) throws CommandSyntaxException {
        ServerLevel world = ((CommandSourceStack)context.getSource()).getLevel();
        BlockPos blockPos = BlockPos.containing((Position)pos);
        if (!Level.isInSpawnableBounds((BlockPos)blockPos)) {
            throw this.INVALID_POS_EXCEPTION.create();
        }
        PokemonProperties properties = PokemonPropertiesArgumentType.Companion.getPokemonProperties(context, "properties");
        if (properties.getSpecies() == null) {
            throw this.NO_SPECIES_EXCEPTION.create();
        }
        PokemonEntity pokemonEntity = properties.createEntity((Level)world);
        pokemonEntity.moveTo(pos.x, pos.y, pos.z, pokemonEntity.getYRot(), pokemonEntity.getXRot());
        pokemonEntity.getEntityData().set(PokemonEntity.getSPAWN_DIRECTION(), (Object)Float.valueOf(pokemonEntity.getRandom().nextFloat() * 360.0f));
        pokemonEntity.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(blockPos), MobSpawnType.COMMAND, null);
        PlayerSpawnerAccessor spawnerAccessor = (PlayerSpawnerAccessor)((CommandSourceStack)context.getSource()).getPlayer();
        if (spawnerAccessor == null) {
            CobblemonSpawnAlerts.LOGGER.error("Could not obtain PlayerSpawnerAccessor for player " + ((CommandSourceStack)context.getSource()).getPlayer().getName().getString() + ". No alert will be sent.");
            cir.cancel();
            return;
        }
        PlayerSpawner spawner = spawnerAccessor.getPlayerSpawner();
        SpawnCause spawnCause = new SpawnCause((Spawner)spawner, (Entity)pokemonEntity);
        BasicSpawnablePosition spawnablePosition = new BasicSpawnablePosition(spawnCause, ((CommandSourceStack)context.getSource()).getLevel(), blockPos, 15, 15, true, new ArrayList());
        AtomicBoolean idkWhatToCallThisButTheCommandDidntError = new AtomicBoolean(false);
        CobblemonEvents.ENTITY_SPAWN.postThen((Cancelable)new SpawnEvent((Entity)pokemonEntity, (SpawnablePosition)spawnablePosition), cancelled -> {
            idkWhatToCallThisButTheCommandDidntError.set(true);
            return Unit.INSTANCE;
        }, succeeded -> {
            idkWhatToCallThisButTheCommandDidntError.set(true);
            spawnablePosition.getWorld().addFreshEntity((Entity)pokemonEntity);
            return Unit.INSTANCE;
        });
        if (idkWhatToCallThisButTheCommandDidntError.get()) {
            cir.setReturnValue((Object)1);
            cir.cancel();
            return;
        }
        cir.cancel();
        throw this.FAILED_SPAWN_EXCEPTION.create();
    }
}

