/*
 * Decompiled with CFR 0.152.
 */
package io.github.stainlessstasis.util;

import com.cobblemon.mod.common.api.abilities.Abilities;
import com.cobblemon.mod.common.api.abilities.AbilityTemplate;
import com.cobblemon.mod.common.api.abilities.PotentialAbility;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.pokemon.abilities.HiddenAbilityType;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public class HiddenAbilityUtil {
    public static boolean hasHiddenAbility(Species species, String abilityID) {
        Set hiddenAbilityNames = species.getAbilities().getMapping().values().stream().flatMap(Collection::stream).filter(ability -> ability.getType() == HiddenAbilityType.INSTANCE).map(PotentialAbility::getTemplate).map(AbilityTemplate::getName).collect(Collectors.toSet());
        AbilityTemplate ability2 = Abilities.INSTANCE.get(abilityID);
        if (ability2 == null) {
            return false;
        }
        String abilityName = ability2.getName();
        return hiddenAbilityNames.contains(abilityName);
    }

    public static boolean hasHiddenAbility(int dexID, String abilityID) {
        Species species = PokemonSpecies.INSTANCE.getByPokedexNumber(dexID, "cobblemon");
        if (species == null) {
            return false;
        }
        return HiddenAbilityUtil.hasHiddenAbility(species, abilityID);
    }
}

