/*
 * Decompiled with CFR 0.152.
 */
package io.github.stainlessstasis;

import com.cobblemon.mod.common.api.scheduling.ScheduledTask;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.mojang.brigadier.CommandDispatcher;
import io.github.stainlessstasis.CSANeoClient;
import io.github.stainlessstasis.alert.DespawnReason;
import io.github.stainlessstasis.core.CobblemonSpawnAlerts;
import io.github.stainlessstasis.core.CommandRegistry;
import io.github.stainlessstasis.network.AlertDataPacket;
import io.github.stainlessstasis.network.DespawnDataPacket;
import io.github.stainlessstasis.network.ModLoadedPacket;
import io.github.stainlessstasis.network.PacketHandlers;
import io.github.stainlessstasis.network.PokemonDataPacket;
import io.github.stainlessstasis.platform.Services;
import kotlin.Unit;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@Mod(value="cobblemon_spawn_alerts")
public class CSANeo {

    public static class ModLoadedPacketHandler {
        public static void handleClient(ModLoadedPacket data, IPayloadContext context) {
            CSANeoClient.doesServerHaveMod = true;
        }

        public static void handleServer(ModLoadedPacket data, IPayloadContext context) {
        }
    }

    public static class DespawnDataPacketHandler {
        public static void handleClient(DespawnDataPacket data, IPayloadContext context) {
            PacketHandlers.handleDespawnDataPacket(data);
        }

        public static void handleServer(DespawnDataPacket data, IPayloadContext context) {
        }
    }

    public static class AlertDataPacketHandler {
        public static void handleClient(AlertDataPacket data, IPayloadContext context) {
            PacketHandlers.handleAlertDataPacket(data);
        }

        public static void handleServer(AlertDataPacket data, IPayloadContext context) {
        }
    }

    public static class PokemonDataPacketHandler {
        public static void handleClient(PokemonDataPacket data, IPayloadContext context) {
            PacketHandlers.handlePokemonDataPacket(data.pokemonNetworkID(), data.ivs(), data.evYield(), data.nature(), data.ability());
        }

        public static void handleServer(PokemonDataPacket data, IPayloadContext context) {
        }
    }

    @EventBusSubscriber
    public static class GameBusEvents {
        @SubscribeEvent
        public static void onCommandRegistration(RegisterCommandsEvent event) {
            CommandRegistry.registerServerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
        }

        @SubscribeEvent
        public static void onPlayerConnect(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new ModLoadedPacket(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        @SubscribeEvent
        public static void onEntityDespawned(EntityLeaveLevelEvent event) {
            PokemonEntity pokemonEntity;
            Level level = event.getLevel();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel level2 = (ServerLevel)level;
            Entity entity = event.getEntity();
            if (entity instanceof PokemonEntity && (pokemonEntity = (PokemonEntity)entity).getOwnerUUID() == null && CobblemonSpawnAlerts.globallyAlerted.contains(pokemonEntity.getPokemon().getUuid())) {
                new ScheduledTask.Builder().delay(5.0f).execute(task -> {
                    if (CobblemonSpawnAlerts.despawned.contains(pokemonEntity.getPokemon().getUuid())) {
                        CobblemonSpawnAlerts.despawned.remove(pokemonEntity.getPokemon().getUuid());
                        return Unit.INSTANCE;
                    }
                    Services.PLATFORM.onPokemonDespawned((Level)level2, pokemonEntity.getPokemon(), "N/A", DespawnReason.DESPAWNED);
                    return Unit.INSTANCE;
                }).build();
            }
        }
    }

    @EventBusSubscriber
    public static class ModBusEvents {
        @SubscribeEvent
        public static void onInit(FMLCommonSetupEvent event) {
            CobblemonSpawnAlerts.initServer();
        }

        @SubscribeEvent
        public static void onPacketRegistration(RegisterPayloadHandlersEvent event) {
            PayloadRegistrar registrar = event.registrar("1").optional();
            registrar.playToClient(PokemonDataPacket.ID, PokemonDataPacket.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(PokemonDataPacketHandler::handleClient, PokemonDataPacketHandler::handleServer));
            registrar.playToClient(AlertDataPacket.ID, AlertDataPacket.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(AlertDataPacketHandler::handleClient, AlertDataPacketHandler::handleServer));
            registrar.playToClient(DespawnDataPacket.ID, DespawnDataPacket.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(DespawnDataPacketHandler::handleClient, DespawnDataPacketHandler::handleServer));
            registrar.playToClient(ModLoadedPacket.ID, ModLoadedPacket.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(ModLoadedPacketHandler::handleClient, ModLoadedPacketHandler::handleServer));
        }
    }
}

