/*
 * Decompiled with CFR 0.152.
 */
package io.github.stainlessstasis.alert;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.abilities.Abilities;
import com.cobblemon.mod.common.api.abilities.AbilityTemplate;
import com.cobblemon.mod.common.api.pokedex.PokedexEntryProgress;
import com.cobblemon.mod.common.api.pokedex.SpeciesDexRecord;
import com.cobblemon.mod.common.api.pokemon.Natures;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.api.storage.player.client.ClientPokedexManager;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.EVs;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.IVs;
import com.cobblemon.mod.common.pokemon.Nature;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.mojang.datafixers.util.Pair;
import io.github.stainlessstasis.alert.DebugAlertCondition;
import io.github.stainlessstasis.alert.DespawnReason;
import io.github.stainlessstasis.alert.StatDisplayMode;
import io.github.stainlessstasis.compat.JourneymapCompat;
import io.github.stainlessstasis.config.MainConfig;
import io.github.stainlessstasis.config.MessageTemplates;
import io.github.stainlessstasis.config.PokemonConfig;
import io.github.stainlessstasis.core.CobblemonSpawnAlerts;
import io.github.stainlessstasis.core.CobblemonSpawnAlertsClient;
import io.github.stainlessstasis.network.AlertDataPacket;
import io.github.stainlessstasis.network.DespawnDataPacket;
import io.github.stainlessstasis.network.PokemonRarity;
import io.github.stainlessstasis.network.PokemonSpawnData;
import io.github.stainlessstasis.network.PokemonStats;
import io.github.stainlessstasis.network.PokemonTraits;
import io.github.stainlessstasis.platform.Platform;
import io.github.stainlessstasis.platform.Services;
import io.github.stainlessstasis.util.BiomeUtil;
import io.github.stainlessstasis.util.ComponentUtil;
import io.github.stainlessstasis.util.DimensionUtil;
import io.github.stainlessstasis.util.EvsUtil;
import io.github.stainlessstasis.util.HiddenAbilityUtil;
import io.github.stainlessstasis.util.MessageUtils;
import io.github.stainlessstasis.util.PokemonNameUtil;
import io.github.stainlessstasis.util.RarityUtil;
import io.github.stainlessstasis.util.StringUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.joml.Vector3f;

public class AlertHandler {
    private static final HashSet<UUID> alreadyAlerted = new HashSet();

    public static void clearCache() {
        alreadyAlerted.clear();
    }

    public static void alertClientside(PokemonEntity pokemonEntity) {
        EVs defaultEVYield = EvsUtil.getYield(pokemonEntity.getPokemon().getSpecies().getNationalPokedexNumber());
        AlertHandler.alertClientside(pokemonEntity, defaultEVYield);
    }

    public static void alertClientside(PokemonEntity pokemonEntity, EVs evYield) {
        if (pokemonEntity.getOwnerUUID() != null) {
            return;
        }
        String nearestPlayerName = "N/A";
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (localPlayer instanceof Player) {
            LocalPlayer player = localPlayer;
            nearestPlayerName = player.getName().getString();
        }
        Pokemon pokemon = pokemonEntity.getPokemon();
        String pokemonName = PokemonNameUtil.getTranslatedName(pokemon);
        int dexId = pokemon.getSpecies().getNationalPokedexNumber();
        AlertHandler.alert(new AlertDataPacket(new PokemonSpawnData(pokemonName, pokemon.getUuid(), pokemonEntity.position().toVector3f(), pokemon.getSpecies().getNationalPokedexNumber(), nearestPlayerName, BiomeUtil.getBiomeKey(pokemonEntity.level(), pokemonEntity.position()), DimensionUtil.getDimensionKey((Entity)pokemonEntity)), new PokemonStats(pokemon.getLevel(), pokemon.getIvs(), evYield), new PokemonRarity(pokemon.getShiny(), RarityUtil.isLegendary(dexId), RarityUtil.isMythical(dexId), RarityUtil.isUltraBeast(dexId), RarityUtil.isParadox(dexId), RarityUtil.isStarter(dexId)), new PokemonTraits(pokemon.getNature().getName().getPath(), pokemon.getAbility().getName(), pokemon.getGender().name(), pokemon.getForm().getName())));
    }

    public static void alert(AlertDataPacket alertData) {
        boolean shouldAlertNotInConfig;
        int level;
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (!(localPlayer instanceof Player)) {
            return;
        }
        LocalPlayer player = localPlayer;
        if (CobblemonSpawnAlertsClient.CLIENT_CONFIG_MANAGER.isReloading()) {
            return;
        }
        if (alreadyAlerted.contains(alertData.spawnData().pokemonUUID())) {
            return;
        }
        MainConfig mainConfig = CobblemonSpawnAlertsClient.CLIENT_CONFIG_MANAGER.getMainConfig();
        ClientPokedexManager dex = CobblemonClient.INSTANCE.getClientPokedexData();
        String pokemonName = PokemonNameUtil.getTranslatedName(alertData.spawnData().translatedPokemonName());
        Pair<Boolean, PokemonConfig.PokemonSpecificConfig> result = AlertHandler.getConfigForPokemon(pokemonName, alertData.spawnData().dexId());
        boolean isInConfig = (Boolean)result.getFirst();
        PokemonConfig.PokemonSpecificConfig pokemonConfig = (PokemonConfig.PokemonSpecificConfig)result.getSecond();
        if (!pokemonConfig.enabled()) {
            return;
        }
        boolean isShiny = alertData.rarity().isShiny();
        boolean isLegend = alertData.rarity().isLegendary();
        boolean isMythical = alertData.rarity().isMythical();
        boolean isUltra = alertData.rarity().isUltraBeast();
        boolean isParadox = alertData.rarity().isParadox();
        boolean isStarter = alertData.rarity().isStarter();
        boolean isInDex = false;
        boolean isCaught = false;
        boolean shouldAlertShiny = isInConfig ? isShiny && (pokemonConfig.alertShiny() || mainConfig.alertAllShinies()) : isShiny && mainConfig.alertAllShinies();
        boolean shouldAlertLegend = isLegend && mainConfig.alertAllLegendaries();
        boolean shouldAlertMythical = isMythical && mainConfig.alertAllMythicals();
        boolean shouldAlertUltra = isUltra && mainConfig.alertAllUltraBeasts();
        boolean shouldAlertParadox = isParadox && mainConfig.alertAllParadox();
        boolean shouldAlertStarter = isStarter && mainConfig.alertAllStarter();
        boolean shouldAlertNotInDex = mainConfig.alertAllNotInDex();
        boolean shouldAlertUncaught = mainConfig.alertAllUncaught();
        Species species = PokemonSpecies.getByPokedexNumber((int)alertData.spawnData().dexId(), (String)"cobblemon");
        SpeciesDexRecord record = dex.getSpeciesRecord(species.resourceIdentifier);
        if (record != null) {
            shouldAlertNotInDex = false;
            isInDex = true;
            if (record.hasAtLeast(PokedexEntryProgress.CAUGHT)) {
                shouldAlertUncaught = false;
                isCaught = true;
            }
        }
        boolean shouldAlertHA = HiddenAbilityUtil.hasHiddenAbility(alertData.spawnData().dexId(), alertData.traits().formID(), alertData.traits().abilityID()) && (pokemonConfig.alertHiddenAbility() || mainConfig.alertAllHA());
        MainConfig.IVHunting ivHunting = mainConfig.ivHunting();
        MainConfig.EVHunting evHunting = mainConfig.evHunting();
        boolean shouldAlertIVs = false;
        if (ivHunting.enabled()) {
            IVs ivs = alertData.stats().ivs();
            boolean meetsMinReqs = false;
            if (ivHunting.requireAllMinimumsMet()) {
                if (!(ivHunting.minHp() > 0 && ivs.get((Stat)Stats.HP) < ivHunting.minHp() || ivHunting.minAtk() > 0 && ivs.get((Stat)Stats.ATTACK) < ivHunting.minAtk() || ivHunting.minDef() > 0 && ivs.get((Stat)Stats.DEFENCE) < ivHunting.minDef() || ivHunting.minSpAtk() > 0 && ivs.get((Stat)Stats.SPECIAL_ATTACK) < ivHunting.minSpAtk() || ivHunting.minSpDef() > 0 && ivs.get((Stat)Stats.SPECIAL_DEFENCE) < ivHunting.minSpDef() || ivHunting.minSpeed() > 0 && ivs.get((Stat)Stats.SPEED) < ivHunting.minSpeed())) {
                    meetsMinReqs = true;
                }
            } else if (ivHunting.minHp() > 0 && ivs.get((Stat)Stats.HP) >= ivHunting.minHp() || ivHunting.minAtk() > 0 && ivs.get((Stat)Stats.ATTACK) >= ivHunting.minAtk() || ivHunting.minDef() > 0 && ivs.get((Stat)Stats.DEFENCE) >= ivHunting.minDef() || ivHunting.minSpAtk() > 0 && ivs.get((Stat)Stats.SPECIAL_ATTACK) >= ivHunting.minSpAtk() || ivHunting.minSpDef() > 0 && ivs.get((Stat)Stats.SPECIAL_DEFENCE) >= ivHunting.minSpDef() || ivHunting.minSpeed() > 0 && ivs.get((Stat)Stats.SPEED) >= ivHunting.minSpeed()) {
                meetsMinReqs = true;
            }
            AtomicInteger numPerfect = new AtomicInteger();
            ivs.forEach(iv -> {
                if ((Integer)iv.getValue() >= 31) {
                    numPerfect.getAndIncrement();
                }
            });
            shouldAlertIVs = numPerfect.get() >= ivHunting.minPerfectIVs() && meetsMinReqs;
        }
        boolean shouldAlertEVs = false;
        if (evHunting.enabled()) {
            EVs evs = alertData.stats().evYield();
            shouldAlertEVs = evHunting.minHp() > 0 && evs.get((Stat)Stats.HP) >= evHunting.minHp() || evHunting.minAtk() > 0 && evs.get((Stat)Stats.ATTACK) >= evHunting.minAtk() || evHunting.minDef() > 0 && evs.get((Stat)Stats.DEFENCE) >= evHunting.minDef() || evHunting.minSpAtk() > 0 && evs.get((Stat)Stats.SPECIAL_ATTACK) >= evHunting.minSpAtk() || evHunting.minSpDef() > 0 && evs.get((Stat)Stats.SPECIAL_DEFENCE) >= evHunting.minSpDef() || evHunting.minSpeed() > 0 && evs.get((Stat)Stats.SPEED) >= evHunting.minSpeed();
        }
        MainConfig.LevelFilter levelFilter = mainConfig.levelFilter();
        boolean passesLevelFilter = true;
        if (levelFilter.enabled() && ((level = alertData.stats().level()) < levelFilter.minLevel() || level > levelFilter.maxLevel())) {
            passesLevelFilter = false;
        }
        boolean shouldAlertInConfig = pokemonConfig.alwaysAlert() || shouldAlertShiny || shouldAlertHA;
        boolean bl = shouldAlertNotInConfig = passesLevelFilter && (shouldAlertShiny || shouldAlertLegend || shouldAlertMythical || shouldAlertUltra || shouldAlertParadox || shouldAlertStarter || shouldAlertNotInDex || shouldAlertUncaught || mainConfig.alertEverything() || shouldAlertIVs || shouldAlertEVs || shouldAlertHA);
        if (mainConfig.debug()) {
            DebugAlertCondition alertCondition = DebugAlertCondition.NONE;
            if (mainConfig.alertEverything()) {
                alertCondition = DebugAlertCondition.ALERT_EVERYTHING;
            }
            if (pokemonConfig.alwaysAlert()) {
                alertCondition = DebugAlertCondition.ALWAYS_ALERT;
            }
            if (shouldAlertShiny) {
                alertCondition = mainConfig.alertAllShinies() ? DebugAlertCondition.ALERT_ALL_SHINY : DebugAlertCondition.ALERT_SHINY;
            }
            if (shouldAlertHA) {
                alertCondition = mainConfig.alertAllHA() ? DebugAlertCondition.ALERT_ALL_HIDDEN_ABILITY : DebugAlertCondition.ALERT_HIDDEN_ABILITY;
            }
            if (shouldAlertLegend) {
                alertCondition = DebugAlertCondition.ALERT_ALL_LEGENDARY;
            }
            if (shouldAlertMythical) {
                alertCondition = DebugAlertCondition.ALERT_ALL_MYTHICAL;
            }
            if (shouldAlertUltra) {
                alertCondition = DebugAlertCondition.ALERT_ALL_ULTRA_BEAST;
            }
            if (shouldAlertParadox) {
                alertCondition = DebugAlertCondition.ALERT_ALL_PARADOX;
            }
            if (shouldAlertStarter) {
                alertCondition = DebugAlertCondition.ALERT_ALL_STARTER;
            }
            if (shouldAlertIVs) {
                alertCondition = DebugAlertCondition.IV_HUNTING;
            }
            if (shouldAlertEVs) {
                alertCondition = DebugAlertCondition.EV_HUNTING;
            }
            if (shouldAlertUncaught) {
                alertCondition = DebugAlertCondition.ALERT_ALL_UNCAUGHT;
            }
            if (shouldAlertNotInDex) {
                alertCondition = DebugAlertCondition.ALERT_ALL_NOT_IN_DEX;
            }
            String message = MessageUtils.getTranslated("cobblemon-spawn-alerts.debug_alert_condition", alertCondition.name());
            message = AlertHandler.applyDynamicReplacements(message, pokemonConfig, alertData);
            Component component = ComponentUtil.convertFromAdventure(message);
            player.sendSystemMessage(component);
        }
        if (isInConfig ? !shouldAlertInConfig : !shouldAlertNotInConfig) {
            return;
        }
        alreadyAlerted.add(alertData.spawnData().pokemonUUID());
        if (!Objects.equals(pokemonConfig.customAlertSound(), "")) {
            String[] split = StringUtil.splitIdentifier(pokemonConfig.customAlertSound());
            if (!split[0].equals("NO NAMESPACE")) {
                ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)split[0], (String)split[1]);
                SoundEvent sound = SoundEvent.createFixedRangeEvent((ResourceLocation)resourceLocation, (float)-1.0f);
                player.playNotifySound(sound, SoundSource.MASTER, 1.0f, 1.0f);
            } else {
                player.sendSystemMessage(ComponentUtil.convertFromAdventure(MessageUtils.getTranslated("cobblemon-spawn-alerts.outdated_sound", new Object[0])));
            }
        } else {
            HashMap<String, Boolean> traits = new HashMap<String, Boolean>();
            traits.put("shiny", isShiny);
            traits.put("legendary", isLegend);
            traits.put("mythical", isMythical);
            traits.put("ultrabeast", isUltra);
            traits.put("paradox", isParadox);
            traits.put("starter", isStarter);
            traits.put("unregistered", !isInDex);
            traits.put("uncaught", !isCaught);
            traits.put("ivs", shouldAlertIVs);
            traits.put("evs", shouldAlertEVs);
            for (String soundTrait : pokemonConfig.sounds().keySet()) {
                String soundID = pokemonConfig.sounds().get(soundTrait);
                if (!((Boolean)traits.get(soundTrait)).booleanValue() || soundID.isEmpty()) continue;
                String[] split = StringUtil.splitIdentifier(soundID);
                if (!split[0].equals("NO NAMESPACE")) {
                    ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)split[0], (String)split[1]);
                    SoundEvent sound = SoundEvent.createFixedRangeEvent((ResourceLocation)resourceLocation, (float)-1.0f);
                    player.playNotifySound(sound, SoundSource.MASTER, 1.0f, 1.0f);
                    continue;
                }
                player.sendSystemMessage(ComponentUtil.convertFromAdventure(MessageUtils.getTranslated("cobblemon-spawn-alerts.outdated_sound", new Object[0])));
            }
        }
        if (pokemonConfig.autoGlow()) {
            CobblemonSpawnAlertsClient.glowing.add(alertData.spawnData().pokemonUUID());
        }
        if (!Objects.equals(pokemonConfig.customAlertMessage(), "")) {
            message = AlertHandler.applyDynamicReplacements(pokemonConfig.customAlertMessage(), pokemonConfig, alertData);
            MessageUtils.sendTranslated(message, new Object[0]);
        } else {
            message = MessageUtils.getTranslated(CobblemonSpawnAlertsClient.CLIENT_CONFIG_MANAGER.getMessageTemplates().fullSpawnMessage(), new Object[0]);
            message = AlertHandler.applyDynamicReplacements(message, pokemonConfig, alertData);
            Component component = ComponentUtil.convertFromAdventure(message);
            player.sendSystemMessage(component);
        }
        PokemonConfig.JourneymapConfig jmConfig = pokemonConfig.journeyMap();
        if (Services.PLATFORM.isModLoaded("journeymap") && jmConfig.enableWaypoint()) {
            Vector3f pos = alertData.spawnData().position();
            BlockPos blockPos = new BlockPos((int)pos.x, (int)pos.y, (int)pos.z);
            JourneymapCompat.createWaypoint(blockPos, alertData, jmConfig);
        }
    }

    public static void alertDespawned(DespawnDataPacket despawnData) {
        PokemonConfig.PokemonSpecificConfig pokemonConfig;
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (!(localPlayer instanceof Player)) {
            return;
        }
        LocalPlayer player = localPlayer;
        if (CobblemonSpawnAlertsClient.CLIENT_CONFIG_MANAGER.isReloading()) {
            return;
        }
        CobblemonSpawnAlertsClient.glowing.remove(despawnData.spawnData().pokemonUUID());
        if (Services.PLATFORM.isModLoaded("journeymap")) {
            JourneymapCompat.removeWaypoint(despawnData.spawnData().pokemonUUID());
        }
        if (!(pokemonConfig = (PokemonConfig.PokemonSpecificConfig)AlertHandler.getConfigForPokemon(despawnData.spawnData().translatedPokemonName(), despawnData.spawnData().dexId()).getSecond()).alertDespawned()) {
            return;
        }
        MessageTemplates messageTemplates = CobblemonSpawnAlertsClient.CLIENT_CONFIG_MANAGER.getMessageTemplates();
        String message = MessageUtils.getTranslated(CobblemonSpawnAlertsClient.CLIENT_CONFIG_MANAGER.getMessageTemplates().despawnMessage(), new Object[0]);
        message = switch (DespawnReason.valueOf(despawnData.despawnReason())) {
            default -> throw new MatchException(null, null);
            case DespawnReason.CAPTURED -> message.replace("{despawned}", Component.translatable((String)messageTemplates.despawnReason_Captured(), (Object[])new Object[]{despawnData.playerName()}).getString());
            case DespawnReason.DESPAWNED -> message.replace("{despawned}", Component.translatable((String)messageTemplates.despawnReason_Despawned()).getString());
            case DespawnReason.FAINTED -> message.replace("{despawned}", Component.translatable((String)messageTemplates.despawnReason_Fainted(), (Object[])new Object[]{despawnData.playerName()}).getString());
        };
        message = AlertHandler.applyDynamicReplacements(message, pokemonConfig, new AlertDataPacket(despawnData.spawnData(), new PokemonStats(-1, IVs.createRandomIVs((int)0), EVs.createEmpty()), despawnData.rarity(), new PokemonTraits(Natures.NAUGHTY.getName().getPath(), Abilities.get((String)"levitate").create(false, Priority.LOWEST).getName(), Gender.GENDERLESS.name(), "Normal")));
        Component component = ComponentUtil.convertFromAdventure(message);
        player.sendSystemMessage(component);
    }

    public static Pair<Boolean, PokemonConfig.PokemonSpecificConfig> getConfigForPokemon(String pokemonName, int dexID) {
        Set<String> pokemonNames = CobblemonSpawnAlertsClient.CLIENT_CONFIG_MANAGER.getPokemonConfig().pokemonConfigs().keySet();
        String fixedPokemonName = PokemonNameUtil.fixName(pokemonName);
        for (String name : pokemonNames) {
            PokemonConfig.PokemonSpecificConfig pokemonSpecificConfig;
            String fixedName;
            if (name.startsWith("default") || !(fixedName = name.toLowerCase().replaceAll("[ _-]", "")).contains(fixedPokemonName) && !fixedName.contains(String.valueOf(dexID)) || !((pokemonSpecificConfig = CobblemonSpawnAlertsClient.CLIENT_CONFIG_MANAGER.getPokemonConfig().pokemonConfigs().get(name)) instanceof PokemonConfig.PokemonSpecificConfig)) continue;
            PokemonConfig.PokemonSpecificConfig _config = pokemonSpecificConfig;
            return Pair.of((Object)true, (Object)_config);
        }
        PokemonConfig.PokemonSpecificConfig pokemonSpecificConfig = CobblemonSpawnAlertsClient.CLIENT_CONFIG_MANAGER.getPokemonConfig().pokemonConfigs().get("default (You can modify anything BELOW this, but dont delete it!)");
        if (pokemonSpecificConfig instanceof PokemonConfig.PokemonSpecificConfig) {
            PokemonConfig.PokemonSpecificConfig _config = pokemonSpecificConfig;
            return Pair.of((Object)false, (Object)_config);
        }
        CobblemonSpawnAlerts.LOGGER.warn("No default config found in `pokemon.json`, creating a new one.");
        return Pair.of((Object)false, (Object)PokemonConfig.PokemonSpecificConfig.createDefault());
    }

    public static String applyDynamicReplacements(String message, PokemonConfig.PokemonSpecificConfig config, AlertDataPacket alertData) {
        String configMessage;
        boolean shouldAlertHA;
        String configMessage2;
        boolean isHoverEnabled;
        boolean shouldAlertShiny;
        MessageTemplates messageTemplates = CobblemonSpawnAlertsClient.CLIENT_CONFIG_MANAGER.getMessageTemplates();
        int level = alertData.stats().level();
        IVs ivs = alertData.stats().ivs();
        EVs evYield = alertData.stats().evYield();
        Nature nature = Natures.getNature((String)alertData.traits().natureID());
        AbilityTemplate ability = Abilities.get((String)alertData.traits().abilityID());
        Gender gender = Gender.valueOf((String)alertData.traits().genderID());
        String nearestPlayer = alertData.spawnData().nearestPlayerName();
        String pokemonName = PokemonNameUtil.getTranslatedName(alertData.spawnData().translatedPokemonName());
        message = ((String)message).replace("{name}", pokemonName);
        message = ((String)message).replace("{name_lower}", pokemonName.toLowerCase());
        message = ((String)message).replace("{name_upper}", pokemonName.toUpperCase());
        Object hoverText = "";
        Map<String, StatDisplayMode> displayModes = config.statDisplayModes();
        StatDisplayMode levelDisplayMode = displayModes.get("level");
        StatDisplayMode ivsDisplayMode = displayModes.get("ivs");
        StatDisplayMode evsDisplayMode = displayModes.get("evs");
        StatDisplayMode natureDisplayMode = displayModes.get("nature");
        StatDisplayMode abilityDisplayMode = displayModes.get("ability");
        StatDisplayMode genderDisplayMode = displayModes.get("gender");
        StatDisplayMode coordinatesDisplayMode = displayModes.get("coordinates");
        StatDisplayMode biomeDisplayMode = displayModes.get("biome");
        StatDisplayMode nearestPlayerDisplayMode = displayModes.get("nearestPlayer");
        boolean bl = shouldAlertShiny = config.alertShiny() && alertData.rarity().isShiny();
        if (shouldAlertShiny) {
            message = ((String)message).replace("{shiny}", Component.translatable((String)messageTemplates.shiny()).getString());
            message = ((String)message).replace("{shiny_unformatted}", Component.translatable((String)messageTemplates.shiny_unformatted()).getString());
        }
        message = ((String)message).replace("{shiny}", "");
        message = ((String)message).replace("{shiny_unformatted}", "");
        if (config.showLegendary()) {
            int dexId = alertData.spawnData().dexId();
            if (RarityUtil.isLegendary(dexId)) {
                message = ((String)message).replace("{legendary}", Component.translatable((String)messageTemplates.legendary()).getString());
                message = ((String)message).replace("{legendary_unformatted}", Component.translatable((String)messageTemplates.legendary_unformatted()).getString());
            } else if (RarityUtil.isMythical(dexId)) {
                message = ((String)message).replace("{legendary}", Component.translatable((String)messageTemplates.mythical()).getString());
                message = ((String)message).replace("{legendary_unformatted}", Component.translatable((String)messageTemplates.mythical_unformatted()).getString());
            } else if (RarityUtil.isUltraBeast(dexId)) {
                message = ((String)message).replace("{legendary}", Component.translatable((String)messageTemplates.ultrabeast()).getString());
                message = ((String)message).replace("{legendary_unformatted}", Component.translatable((String)messageTemplates.ultrabeast_unformatted()).getString());
            } else if (RarityUtil.isParadox(dexId)) {
                message = ((String)message).replace("{legendary}", Component.translatable((String)messageTemplates.paradox()).getString());
                message = ((String)message).replace("{legendary_unformatted}", Component.translatable((String)messageTemplates.paradox_unformatted()).getString());
            }
        }
        message = ((String)message).replace("{legendary}", "");
        message = ((String)message).replace("{legendary_unformatted}", "");
        if (levelDisplayMode != StatDisplayMode.DISABLED) {
            isHoverEnabled = levelDisplayMode == StatDisplayMode.HOVER;
            configMessage2 = isHoverEnabled ? messageTemplates.level_hover() : messageTemplates.level();
            String levelMessage = Component.translatable((String)configMessage2, (Object[])new Object[]{level}).getString();
            if (isHoverEnabled) {
                hoverText = (String)hoverText + levelMessage + "\n";
            } else {
                message = ((String)message).replace("{level}", levelMessage);
            }
            message = ((String)message).replace("{level_unformatted}", Component.translatable((String)messageTemplates.level_unformatted(), (Object[])new Object[]{level}).getString());
        }
        message = ((String)message).replace("{level}", "");
        message = ((String)message).replace("{level_unformatted}", "");
        if (ivsDisplayMode != StatDisplayMode.DISABLED) {
            String ivsMessage;
            isHoverEnabled = ivsDisplayMode == StatDisplayMode.HOVER;
            configMessage2 = isHoverEnabled ? messageTemplates.ivs_hover() : messageTemplates.ivs();
            String string = ivsMessage = Services.PLATFORM.doesServerHaveMod() ? Component.translatable((String)configMessage2, (Object[])new Object[]{ivs.get((Stat)Stats.HP), ivs.get((Stat)Stats.ATTACK), ivs.get((Stat)Stats.DEFENCE), ivs.get((Stat)Stats.SPECIAL_ATTACK), ivs.get((Stat)Stats.SPECIAL_DEFENCE), ivs.get((Stat)Stats.SPEED)}).getString() : Component.translatable((String)configMessage2, (Object[])new Object[]{"-", "-", "-", "-", "-", "-"}).getString();
            if (isHoverEnabled) {
                hoverText = (String)hoverText + ivsMessage + "\n";
            } else {
                message = ((String)message).replace("{ivs}", ivsMessage);
            }
            String ivsUnformatted = Services.PLATFORM.doesServerHaveMod() ? Component.translatable((String)messageTemplates.ivs_unformatted(), (Object[])new Object[]{ivs.get((Stat)Stats.HP), ivs.get((Stat)Stats.ATTACK), ivs.get((Stat)Stats.DEFENCE), ivs.get((Stat)Stats.SPECIAL_ATTACK), ivs.get((Stat)Stats.SPECIAL_DEFENCE), ivs.get((Stat)Stats.SPEED)}).getString() : Component.translatable((String)messageTemplates.evs_unformatted(), (Object[])new Object[]{"-", "-", "-", "-", "-", "-"}).getString();
            message = ((String)message).replace("{ivs_unformatted}", ivsUnformatted);
        }
        message = ((String)message).replace("{ivs}", "");
        message = ((String)message).replace("{ivs_unformatted}", "");
        if (evsDisplayMode != StatDisplayMode.DISABLED) {
            isHoverEnabled = evsDisplayMode == StatDisplayMode.HOVER;
            configMessage2 = isHoverEnabled ? messageTemplates.evs_hover() : messageTemplates.evs();
            String evsMessage = Component.translatable((String)configMessage2, (Object[])new Object[]{evYield.get((Stat)Stats.HP), evYield.get((Stat)Stats.ATTACK), evYield.get((Stat)Stats.DEFENCE), evYield.get((Stat)Stats.SPECIAL_ATTACK), evYield.get((Stat)Stats.SPECIAL_DEFENCE), evYield.get((Stat)Stats.SPEED)}).getString();
            if (isHoverEnabled) {
                hoverText = (String)hoverText + evsMessage + "\n";
            } else {
                message = ((String)message).replace("{evs}", evsMessage);
            }
            String evsUnformatted = Component.translatable((String)messageTemplates.evs_unformatted(), (Object[])new Object[]{evYield.get((Stat)Stats.HP), evYield.get((Stat)Stats.ATTACK), evYield.get((Stat)Stats.DEFENCE), evYield.get((Stat)Stats.SPECIAL_ATTACK), evYield.get((Stat)Stats.SPECIAL_DEFENCE), evYield.get((Stat)Stats.SPEED)}).getString();
            message = ((String)message).replace("{evs_unformatted}", evsUnformatted);
        }
        message = ((String)message).replace("{evs}", "");
        message = ((String)message).replace("{evs_unformatted}", "");
        if (natureDisplayMode != StatDisplayMode.DISABLED) {
            isHoverEnabled = natureDisplayMode == StatDisplayMode.HOVER;
            configMessage2 = isHoverEnabled ? messageTemplates.nature_hover() : messageTemplates.nature();
            String natureString = nature != null ? MiscUtilsKt.asTranslated((String)nature.getDisplayName()).getString() : "N/A";
            natureString = StringUtil.capitalize(natureString);
            natureString = AlertHandler.replaceIfNotAvailable(natureString);
            String natureMessage = Component.translatable((String)configMessage2, (Object[])new Object[]{natureString}).getString();
            if (isHoverEnabled) {
                hoverText = (String)hoverText + natureMessage + "\n";
            } else {
                message = ((String)message).replace("{nature}", natureMessage);
            }
            String natureUnformatted = AlertHandler.replaceIfNotAvailable(Component.translatable((String)messageTemplates.nature_unformatted(), (Object[])new Object[]{natureString}).getString());
            message = ((String)message).replace("{nature_unformatted}", natureUnformatted);
        }
        message = ((String)message).replace("{nature}", "");
        message = ((String)message).replace("{nature_unformatted}", "");
        if (abilityDisplayMode != StatDisplayMode.DISABLED) {
            isHoverEnabled = abilityDisplayMode == StatDisplayMode.HOVER;
            configMessage2 = isHoverEnabled ? messageTemplates.ability_hover() : messageTemplates.ability();
            String abilityString = ability != null ? StringUtil.capitalize(MiscUtilsKt.asTranslated((String)ability.getDisplayName()).getString()) : "N/A";
            abilityString = AlertHandler.replaceIfNotAvailable(abilityString);
            String abilityMessage = Component.translatable((String)configMessage2, (Object[])new Object[]{abilityString}).getString();
            if (isHoverEnabled) {
                hoverText = (String)hoverText + abilityMessage + "\n";
            } else {
                message = ((String)message).replace("{ability}", abilityMessage);
            }
            String abilityUnformatted = AlertHandler.replaceIfNotAvailable(Component.translatable((String)messageTemplates.ability_unformatted(), (Object[])new Object[]{abilityString}).getString());
            message = ((String)message).replace("{ability_unformatted}", abilityUnformatted);
        }
        message = ((String)message).replace("{ability}", "");
        message = ((String)message).replace("{ability_unformatted}", "");
        boolean bl2 = shouldAlertHA = config.alertHiddenAbility() && HiddenAbilityUtil.hasHiddenAbility(alertData.spawnData().dexId(), alertData.traits().formID(), alertData.traits().abilityID());
        if (shouldAlertHA) {
            message = ((String)message).replace("{HA}", Component.translatable((String)messageTemplates.hidden_ability()).getString());
            message = ((String)message).replace("{HA_unformatted}", Component.translatable((String)messageTemplates.hidden_ability_unformatted()).getString());
        }
        message = ((String)message).replace("{HA}", "");
        message = ((String)message).replace("{HA_unformatted}", "");
        if (genderDisplayMode != StatDisplayMode.DISABLED) {
            boolean isHoverEnabled2 = genderDisplayMode == StatDisplayMode.HOVER;
            String genderSymbol = switch (gender) {
                default -> throw new MatchException(null, null);
                case Gender.MALE -> messageTemplates.male();
                case Gender.FEMALE -> messageTemplates.female();
                case Gender.GENDERLESS -> messageTemplates.genderless();
            };
            String genderName = StringUtil.capitalize(gender.toString().toLowerCase());
            String genderString = Component.translatable((String)genderSymbol, (Object[])new Object[]{genderName}).getString();
            String configMessage3 = isHoverEnabled2 ? messageTemplates.gender_hover() : messageTemplates.gender();
            String genderMessage = Component.translatable((String)configMessage3, (Object[])new Object[]{genderString}).getString();
            if (isHoverEnabled2) {
                hoverText = (String)hoverText + genderMessage + "\n";
            } else {
                message = ((String)message).replace("{gender}", genderMessage);
            }
            message = ((String)message).replace("{gender_unformatted}", Component.translatable((String)messageTemplates.gender_unformatted(), (Object[])new Object[]{genderName}).getString());
        }
        message = ((String)message).replace("{gender}", "");
        message = ((String)message).replace("{gender_unformatted}", "");
        Vector3f coords = alertData.spawnData().position();
        if (coordinatesDisplayMode != StatDisplayMode.DISABLED) {
            boolean isHoverEnabled3 = coordinatesDisplayMode == StatDisplayMode.HOVER;
            configMessage = isHoverEnabled3 ? messageTemplates.coords_hover() : messageTemplates.coords();
            String coordsMessage = Component.translatable((String)configMessage, (Object[])new Object[]{(int)coords.x, (int)coords.y, (int)coords.z}).getString();
            if (isHoverEnabled3) {
                hoverText = (String)hoverText + coordsMessage + "\n";
            } else {
                message = ((String)message).replace("{coords}", coordsMessage);
            }
            message = ((String)message).replace("{coords_unformatted}", Component.translatable((String)messageTemplates.coords_unformatted(), (Object[])new Object[]{(int)coords.x, (int)coords.y, (int)coords.z}).getString());
        }
        message = ((String)message).replace("{coords}", "");
        message = ((String)message).replace("{coords_unformatted}", "");
        if (biomeDisplayMode != StatDisplayMode.DISABLED && Minecraft.getInstance().level != null) {
            boolean isHoverEnabled4 = biomeDisplayMode == StatDisplayMode.HOVER;
            String biomeName = Component.translatable((String)alertData.spawnData().biomeKey()).getString();
            biomeName = StringUtil.makeBeautiful(biomeName);
            String configMessage4 = isHoverEnabled4 ? messageTemplates.biome_hover() : messageTemplates.biome();
            String biomeMessage = Component.translatable((String)configMessage4, (Object[])new Object[]{biomeName}).getString();
            if (isHoverEnabled4) {
                hoverText = (String)hoverText + biomeMessage + "\n";
            } else {
                message = ((String)message).replace("{biome}", biomeMessage);
            }
            message = ((String)message).replace("{biome_unformatted}", Component.translatable((String)messageTemplates.biome_unformatted(), (Object[])new Object[]{biomeName}).getString());
        }
        message = ((String)message).replace("{biome}", "");
        message = ((String)message).replace("{biome_unformatted}", "");
        if (nearestPlayerDisplayMode != StatDisplayMode.DISABLED) {
            boolean isHoverEnabled5 = nearestPlayerDisplayMode == StatDisplayMode.HOVER;
            configMessage = isHoverEnabled5 ? messageTemplates.nearest_player_hover() : messageTemplates.nearest_player();
            String nearestPlayerMessage = Component.translatable((String)configMessage, (Object[])new Object[]{nearestPlayer}).getString();
            if (isHoverEnabled5) {
                hoverText = (String)hoverText + nearestPlayerMessage + "\n";
            } else {
                message = ((String)message).replace("{nearest_player}", nearestPlayerMessage);
            }
            message = ((String)message).replace("{nearest_player_unformatted}", Component.translatable((String)messageTemplates.nearest_player_unformatted(), (Object[])new Object[]{nearestPlayer}).getString());
        }
        message = ((String)message).replace("{nearest_player}", "");
        message = ((String)message).replace("{nearest_player_unformatted}", "");
        hoverText = (String)hoverText + "<green>Click to toggle glow</green>";
        message = "<hover:show_text:\"" + (String)hoverText + "\">" + (String)message + "</hover>";
        message = Services.PLATFORM.getPlatform() == Platform.FABRIC ? "<click:run_command:/csa glow " + alertData.spawnData().pokemonUUID().toString() + ">" + (String)message + "</click>" : "<click:suggest_command:/csa glow " + alertData.spawnData().pokemonUUID().toString() + ">" + (String)message + "</click>";
        return message;
    }

    private static String replaceIfNotAvailable(String string) {
        if (!Services.PLATFORM.doesServerHaveMod()) {
            return "N/A";
        }
        return string;
    }
}

