/*
 * Decompiled with CFR 0.152.
 */
package io.github.stainlessstasis.compat;

import io.github.stainlessstasis.config.PokemonConfig;
import io.github.stainlessstasis.core.CobblemonSpawnAlertsClient;
import io.github.stainlessstasis.network.AlertDataPacket;
import io.github.stainlessstasis.util.DimensionUtil;
import java.awt.Color;
import java.util.UUID;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.api.v2.common.waypoint.WaypointFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class JourneymapCompat {
    private static IClientAPI api;

    public static IClientAPI getAPI() {
        return api;
    }

    public static void initAPI(IClientAPI api) {
        JourneymapCompat.api = api;
    }

    public static void createWaypoint(BlockPos pos, AlertDataPacket alertData, PokemonConfig.JourneymapConfig jmConfig) {
        ResourceKey<Level> dimension = DimensionUtil.getDimension(alertData.spawnData().dimensionKey());
        String waypointName = jmConfig.waypointName().isEmpty() ? alertData.spawnData().translatedPokemonName() : jmConfig.waypointName();
        Waypoint waypoint = WaypointFactory.createClientWaypoint((String)"cobblemon_spawn_alerts", (BlockPos)pos, (String)waypointName, dimension, (boolean)jmConfig.persistent());
        if (!jmConfig.waypointHexColor().isEmpty()) {
            Color color = Color.decode(jmConfig.waypointHexColor());
            waypoint.setColor(color.getRGB());
        }
        CobblemonSpawnAlertsClient.waypoints.put(alertData.spawnData().pokemonUUID(), waypoint.getGuid());
        api.addWaypoint("cobblemon_spawn_alerts", waypoint);
    }

    public static void removeWaypoint(UUID uuid) {
        Waypoint waypoint = api.getWaypoint("cobblemon_spawn_alerts", CobblemonSpawnAlertsClient.waypoints.get(uuid));
        if (waypoint == null) {
            CobblemonSpawnAlertsClient.waypoints.remove(uuid);
            return;
        }
        api.removeWaypoint("cobblemon_spawn_alerts", waypoint);
        CobblemonSpawnAlertsClient.waypoints.remove(uuid);
    }
}

