/*
 * Decompiled with CFR 0.152.
 */
package io.github.stainlessstasis.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import io.github.stainlessstasis.config.PokemonConfig;
import io.github.stainlessstasis.core.CobblemonSpawnAlerts;
import io.github.stainlessstasis.platform.Services;
import io.github.stainlessstasis.util.MessageUtils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.minecraft.Util;

public abstract class AbstractConfigManager {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected static final Path MOD_CONFIG_DIR = Services.PLATFORM.getConfigDir().resolve("cobblemon-spawn-alerts");
    protected boolean isReloading;

    public boolean loadConfig() {
        this.isReloading = true;
        try {
            Files.createDirectories(MOD_CONFIG_DIR, new FileAttribute[0]);
        }
        catch (IOException e) {
            CobblemonSpawnAlerts.LOGGER.error("Failed to create mod config directory `" + String.valueOf(MOD_CONFIG_DIR) + "`. Error: ", (Throwable)e);
            this.failedLoad(MOD_CONFIG_DIR);
            return false;
        }
        if (!this.onConfigLoad()) {
            return false;
        }
        this.isReloading = false;
        return true;
    }

    abstract boolean onConfigLoad();

    public void failedLoad(Path path) {
        MessageUtils.sendTranslated("cobblemon-spawn-alerts.config_load_failed", path);
        this.isReloading = false;
    }

    public <T> T loadConfigFile(File file, Class<T> config) {
        Object finalConfig;
        String fileName = file.getName();
        try {
            String currentVersion;
            Method createDefaultMethod = config.getMethod("createDefault", new Class[0]);
            Object defaultConfig = createDefaultMethod.invoke(null, new Object[0]);
            if (!file.exists()) {
                CobblemonSpawnAlerts.LOGGER.info("No config file `" + fileName + "` found, creating a new one with default settings.");
                this.saveConfigFile(file, defaultConfig);
                return (T)defaultConfig;
            }
            JsonObject userConfigJson = null;
            try (FileReader reader = new FileReader(file);){
                JsonElement json = JsonParser.parseReader((Reader)reader);
                if (json.isJsonObject()) {
                    userConfigJson = json.getAsJsonObject();
                } else {
                    CobblemonSpawnAlerts.LOGGER.warn("Config file `" + fileName + "` is not a valid JSON object. Overwriting with default.");
                }
            }
            catch (JsonSyntaxException e) {
                CobblemonSpawnAlerts.LOGGER.error("Config file `" + fileName + "` is corrupted or malformed JSON. Error: " + e.getMessage());
                return null;
            }
            catch (IOException e) {
                CobblemonSpawnAlerts.LOGGER.error("Failed to read config file `" + fileName + "`. Error: " + e.getMessage());
                return null;
            }
            JsonObject mergedJson = GSON.toJsonTree(defaultConfig).getAsJsonObject();
            if (userConfigJson != null) {
                this.mergeJsonObjects(mergedJson, userConfigJson);
            }
            if (mergedJson.has("configVersion") && !(currentVersion = mergedJson.get("configVersion").getAsString()).equals("1.11.2")) {
                mergedJson.add("configVersion", (JsonElement)new JsonPrimitive("1.11.2"));
            }
            if (config.equals(PokemonConfig.class)) {
                this.applyPokemonConfigMerge(fileName, mergedJson, userConfigJson, (PokemonConfig)defaultConfig);
            }
            finalConfig = GSON.fromJson((JsonElement)mergedJson, config);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            CobblemonSpawnAlerts.LOGGER.error("Something went VERY wrong while trying to load `" + fileName + "`. Error:", (Throwable)e);
            this.failedLoad(file.toPath());
            return null;
        }
        CobblemonSpawnAlerts.LOGGER.info("Config file `" + fileName + "` loaded successfully.");
        this.saveConfigFile(file, finalConfig);
        return (T)finalConfig;
    }

    private void mergeJsonObjects(JsonObject base, JsonObject overwrite) {
        for (Map.Entry entry : overwrite.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (base.has(key) && base.get(key).isJsonObject() && value.isJsonObject()) {
                this.mergeJsonObjects(base.get(key).getAsJsonObject(), value.getAsJsonObject());
                continue;
            }
            base.add(key, value);
        }
    }

    private void applyPokemonConfigMerge(String fileName, JsonObject mergedJson, JsonObject userConfigJson, PokemonConfig defaultConfigs) {
        PokemonConfig.PokemonSpecificConfig defaultPokemonConfig = defaultConfigs.pokemonConfigs().get("default (You can modify anything BELOW this, but dont delete it!)");
        if (defaultPokemonConfig == null) {
            CobblemonSpawnAlerts.LOGGER.error("Default config entry not found in PokemonConfig#createDefault. Skipping specific pokemon config merge.");
            return;
        }
        JsonObject mergedPokemonConfigs = mergedJson.has("pokemonConfigs") ? mergedJson.get("pokemonConfigs").getAsJsonObject() : new JsonObject();
        mergedJson.add("pokemonConfigs", (JsonElement)mergedPokemonConfigs);
        JsonObject userPokemonConfigs = null;
        if (userConfigJson != null && userConfigJson.has("pokemonConfigs") && userConfigJson.get("pokemonConfigs").isJsonObject()) {
            userPokemonConfigs = userConfigJson.get("pokemonConfigs").getAsJsonObject();
        }
        JsonObject defaultSpecificConfig = GSON.toJsonTree((Object)defaultPokemonConfig).getAsJsonObject();
        if (userPokemonConfigs != null && userPokemonConfigs.has("default (You can modify anything BELOW this, but dont delete it!)") && userPokemonConfigs.get("default (You can modify anything BELOW this, but dont delete it!)").isJsonObject()) {
            this.mergeJsonObjects(defaultSpecificConfig, userPokemonConfigs.get("default (You can modify anything BELOW this, but dont delete it!)").getAsJsonObject());
        }
        mergedPokemonConfigs.add("default (You can modify anything BELOW this, but dont delete it!)", (JsonElement)defaultSpecificConfig);
        if (userPokemonConfigs != null) {
            for (Map.Entry entry : userPokemonConfigs.entrySet()) {
                String pokemonName = (String)entry.getKey();
                if (pokemonName.equals("default (You can modify anything BELOW this, but dont delete it!)")) continue;
                JsonElement userSpecificConfigElement = (JsonElement)entry.getValue();
                if (userSpecificConfigElement.isJsonObject()) {
                    JsonObject userSpecificConfig = userSpecificConfigElement.getAsJsonObject();
                    JsonObject specificPokemonDefault = GSON.toJsonTree((Object)PokemonConfig.PokemonSpecificConfig.createDefault()).getAsJsonObject();
                    this.mergeJsonObjects(specificPokemonDefault, userSpecificConfig);
                    mergedPokemonConfigs.add(pokemonName, (JsonElement)specificPokemonDefault);
                    continue;
                }
                CobblemonSpawnAlerts.LOGGER.warn("Invalid entry for Pokemon '" + pokemonName + "' in config file `" + fileName + "`. Skipping.");
            }
        }
    }

    public <T> void saveConfigFile(File file, T config) {
        String fileName = file.getName();
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(config, (Appendable)writer);
            CobblemonSpawnAlerts.LOGGER.info("Config file `" + fileName + "` saved successfully.");
        }
        catch (IOException e) {
            CobblemonSpawnAlerts.LOGGER.error("Failed to save config file `" + fileName + "`. Error: " + e.getMessage());
            MessageUtils.sendTranslated("cobblemon-spawn-alerts.config_save_failed", file.toPath());
            this.isReloading = false;
        }
    }

    public boolean isReloading() {
        return this.isReloading;
    }

    public static void openDirectory() {
        Util.getPlatform().openPath(MOD_CONFIG_DIR);
    }
}

