/*
 * Decompiled with CFR 0.152.
 */
package io.github.stainlessstasis;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import io.github.stainlessstasis.alert.AlertHandler;
import io.github.stainlessstasis.core.CobblemonSpawnAlerts;
import io.github.stainlessstasis.core.CommandRegistry;
import io.github.stainlessstasis.util.EvsUtil;
import io.github.stainlessstasis.util.MessageUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.Commands;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

@Mod(value="cobblemon_spawn_alerts", dist={Dist.CLIENT})
public class CSANeoClient {
    public static boolean doesServerHaveMod = false;

    @EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
    public static class GameBusEvents {
        @SubscribeEvent
        public static void onCommandRegistration(RegisterClientCommandsEvent event) {
            event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"csa").then(Commands.literal((String)"reload").executes(ctx -> CommandRegistry.handleReloadCommand()))).then(Commands.literal((String)"openconfig").executes(ctx -> CommandRegistry.handleOpenConfigCommand()))).then(Commands.literal((String)"glow").then(Commands.argument((String)"uuid", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
                String uuidString = (String)ctx.getArgument("uuid", String.class);
                return CommandRegistry.handleGlowCommand(uuidString);
            }))));
        }

        @SubscribeEvent
        public static void onConnect(ClientPlayerNetworkEvent.LoggingIn event) {
            if (!Minecraft.getInstance().isSingleplayer() && CobblemonSpawnAlerts.CLIENT_CONFIG_MANAGER.getMainConfig().multiplayerWarning()) {
                MessageUtils.sendTranslated("cobblemon-spawn-alerts.multiplayer_warning", new Object[0]);
            }
        }

        @SubscribeEvent
        public static void onDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
            AlertHandler.clearCache();
            EvsUtil.clearCache();
            doesServerHaveMod = false;
        }

        @SubscribeEvent
        public static void onEntityLoad(EntityJoinLevelEvent event) {
            if (!event.getLevel().isClientSide) {
                return;
            }
            Entity entity = event.getEntity();
            if (entity instanceof PokemonEntity) {
                PokemonEntity pe = (PokemonEntity)entity;
                if (!doesServerHaveMod) {
                    AlertHandler.alertClientside(pe);
                }
            }
        }
    }

    @EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ModBusEvents {
        @SubscribeEvent
        public static void onInit(FMLClientSetupEvent event) {
            CobblemonSpawnAlerts.initClient();
        }
    }
}

