/*
 * Decompiled with CFR 0.152.
 */
package net.apple70cents.chattools.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.apple70cents.chattools.utils.ConfigScreenUtils;
import net.apple70cents.chattools.utils.ConfigUtils;
import net.apple70cents.chattools.utils.TextUtils;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class ConfigScreenGenerator {
    private static Map<String, Object> configGuiMap;
    private static int GUI_VERSION;
    public static boolean configGuiMapInitialized;
    private static final Gson GSON;
    private static final Map<String, String> key2TypeMappings;

    public static Map<String, String> getKey2TypeMappings() {
        if (!configGuiMapInitialized || key2TypeMappings.isEmpty()) {
            ConfigScreenGenerator.getConfigBuilder();
        }
        return key2TypeMappings;
    }

    public static void loadConfigGuiMap() {
        try {
            InputStream inputStream = class_310.method_1551().getClass().getClassLoader().getResourceAsStream("assets/chattools/config_gui.json");
            InputStreamReader reader = new InputStreamReader(inputStream);
            configGuiMap = (Map)GSON.fromJson((Reader)reader, Map.class);
            configGuiMapInitialized = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void initializeConfigGuiMapIfNecessary() {
        if (!configGuiMapInitialized) {
            ConfigScreenGenerator.loadConfigGuiMap();
            GUI_VERSION = ((Number)configGuiMap.get("version")).intValue();
        }
    }

    public static ConfigBuilder getConfigBuilder() {
        ConfigScreenGenerator.initializeConfigGuiMapIfNecessary();
        class_2960 backgroundTexture = new class_2960("minecraft:textures/block/oak_planks.png");
        ConfigBuilder builder = ConfigBuilder.create().setTitle(TextUtils.trans("gui.title")).setDefaultBackgroundTexture(backgroundTexture).setTransparentBackground(true).setSavingRunnable(ConfigUtils::save);
        ConfigEntryBuilder eb = builder.entryBuilder();
        for (Object categoryInfo : (List)configGuiMap.get("content")) {
            ConfigCategory category = builder.getOrCreateCategory(TextUtils.trans((String)((Map)categoryInfo).get("key")));
            for (Object element : (List)((Map)categoryInfo).get("content")) {
                String type = (String)((Map)element).get("type");
                String key = (String)((Map)element).get("key");
                key2TypeMappings.put(key, type);
                String errorSupplier = ((Map)element).getOrDefault("errorSupplier", "null");
                if ("intSlider".equals(type)) {
                    category.addEntry((AbstractConfigListEntry)ConfigScreenUtils.getEntryBuilder(eb, type, key, errorSupplier, ((Number)((Map)element).get("min")).intValue(), ((Number)((Map)element).get("max")).intValue()));
                    continue;
                }
                if ("sub".equals(type)) {
                    SubCategoryBuilder sub = eb.startSubCategory(TextUtils.trans(key)).setTooltip(new class_2561[]{ConfigScreenUtils.getTooltip(key, type, null)});
                    for (Object elementInner : (List)((Map)element).get("content")) {
                        String typeInner = (String)((Map)elementInner).get("type");
                        String keyInner = (String)((Map)elementInner).get("key");
                        key2TypeMappings.put(keyInner, typeInner);
                        if ("intSlider".equals(typeInner)) {
                            sub.add((AbstractConfigListEntry)ConfigScreenUtils.getEntryBuilder(eb, typeInner, keyInner, errorSupplier, ((Number)((Map)elementInner).get("min")).intValue(), ((Number)((Map)elementInner).get("max")).intValue()));
                            continue;
                        }
                        sub.add((AbstractConfigListEntry)ConfigScreenUtils.getEntryBuilder(eb, typeInner, keyInner, errorSupplier, new int[0]));
                    }
                    category.addEntry((AbstractConfigListEntry)sub.build());
                    continue;
                }
                category.addEntry((AbstractConfigListEntry)ConfigScreenUtils.getEntryBuilder(eb, type, key, errorSupplier, new int[0]));
            }
        }
        return builder;
    }

    static {
        GUI_VERSION = -1;
        configGuiMapInitialized = false;
        GSON = new GsonBuilder().create();
        key2TypeMappings = new HashMap<String, String>();
    }
}

