/*
 * Decompiled with CFR 0.152.
 */
package net.apple70cents.chattools.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_3675;

public class SpecialUnits {

    public static class CustomJoinMessageRuleUnit {
        public String address;
        public String message;
        public long delayInMilliseconds;
        public boolean forceDisableFormatter;

        public CustomJoinMessageRuleUnit() {
            this.address = "*";
            this.message = "/login xxx";
            this.delayInMilliseconds = 1000L;
            this.forceDisableFormatter = false;
        }

        public CustomJoinMessageRuleUnit(String address, String message, long delayInMilliseconds, boolean forceDisableFormatter) {
            this.address = address;
            this.message = message;
            this.delayInMilliseconds = delayInMilliseconds;
            this.forceDisableFormatter = forceDisableFormatter;
        }

        public static CustomJoinMessageRuleUnit of(Object ele) {
            if (ele instanceof Map) {
                String address = ((Map)ele).getOrDefault("address", "*");
                String message = ((Map)ele).getOrDefault("message", "/login xxx");
                long delayInMilliseconds = ((Number)((Map)ele).getOrDefault("delayInMilliseconds", 1000)).longValue();
                boolean forceDisableFormatter = ((Map)ele).getOrDefault("forceDisableFormatter", false);
                return new CustomJoinMessageRuleUnit(address, message, delayInMilliseconds, forceDisableFormatter);
            }
            if (ele instanceof CustomJoinMessageRuleUnit) {
                return (CustomJoinMessageRuleUnit)ele;
            }
            throw new IllegalArgumentException("Unexpected element type of Object: " + String.valueOf(ele));
        }

        public static List<CustomJoinMessageRuleUnit> fromList(List list) {
            ArrayList<CustomJoinMessageRuleUnit> arr = new ArrayList<CustomJoinMessageRuleUnit>();
            for (Object ele : list) {
                arr.add(CustomJoinMessageRuleUnit.of(ele));
            }
            return arr;
        }
    }

    public static class FormatterUnit {
        public String address;
        public String formatter;

        public FormatterUnit() {
            this.address = "*";
            this.formatter = "{text}";
        }

        public FormatterUnit(String address, String formatter) {
            this.address = address;
            this.formatter = formatter;
        }

        public static FormatterUnit of(Object ele) {
            if (ele instanceof Map) {
                String address = ((Map)ele).getOrDefault("address", "*");
                String formatter = ((Map)ele).getOrDefault("formatter", "{text}");
                return new FormatterUnit(address, formatter);
            }
            if (ele instanceof FormatterUnit) {
                return (FormatterUnit)ele;
            }
            throw new IllegalArgumentException("Unexpected element type of Object:" + String.valueOf(ele));
        }

        public static List<FormatterUnit> fromList(List list) {
            ArrayList<FormatterUnit> arr = new ArrayList<FormatterUnit>();
            for (Object ele : list) {
                arr.add(FormatterUnit.of(ele));
            }
            return arr;
        }
    }

    public static class MacroUnit {
        public String key;
        public KeyModifiers modifier;
        public MacroModes mode;
        public String command;

        public MacroUnit() {
            this.key = class_3675.field_16237.method_1441();
            this.modifier = KeyModifiers.NONE;
            this.mode = MacroModes.LAZY;
            this.command = "";
        }

        public MacroUnit(String key, KeyModifiers modifier, MacroModes mode, String command) {
            this.key = key;
            this.modifier = modifier;
            this.mode = mode;
            this.command = command;
        }

        public static MacroUnit of(Object ele) {
            if (ele instanceof Map) {
                String key = ((Map)ele).getOrDefault("key", class_3675.field_16237.method_1441());
                KeyModifiers modifier = KeyModifiers.valueOf((String)((Object)((Map)ele).getOrDefault("modifier", KeyModifiers.NONE)));
                MacroModes mode = MacroModes.valueOf((String)((Object)((Map)ele).getOrDefault("mode", MacroModes.LAZY)));
                String command = ((Map)ele).getOrDefault("command", "");
                return new MacroUnit(key, modifier, mode, command);
            }
            if (ele instanceof MacroUnit) {
                return (MacroUnit)ele;
            }
            throw new IllegalArgumentException("Unexpected element type of Object: " + String.valueOf(ele));
        }

        public static List<MacroUnit> fromList(List list) {
            ArrayList<MacroUnit> arr = new ArrayList<MacroUnit>();
            for (Object ele : list) {
                arr.add(MacroUnit.of(ele));
            }
            return arr;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MacroUnit macroUnit = (MacroUnit)o;
            return this.key.equals(macroUnit.key) && this.modifier == macroUnit.modifier && this.mode == macroUnit.mode && this.command.equals(macroUnit.command);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.key, this.modifier, this.mode, this.command});
        }
    }

    public static class ResponderRuleUnit {
        public String address;
        public String pattern;
        public String message;
        public long delayInMilliseconds;
        public boolean forceDisableFormatter;

        public ResponderRuleUnit() {
            this.address = "*";
            this.pattern = "Repeat my words:(?<word>.*)";
            this.message = "You said {word}.";
            this.delayInMilliseconds = 50L;
            this.forceDisableFormatter = false;
        }

        public ResponderRuleUnit(String address, String pattern, String message, long delayInMilliseconds, boolean forceDisableFormatter) {
            this.address = address;
            this.pattern = pattern;
            this.message = message;
            this.delayInMilliseconds = delayInMilliseconds;
            this.forceDisableFormatter = forceDisableFormatter;
        }

        public static ResponderRuleUnit of(Object ele) {
            if (ele instanceof Map) {
                String address = ((Map)ele).getOrDefault("address", "*");
                String pattern = ((Map)ele).getOrDefault("pattern", "Repeat my words:(?<word>.*)");
                String message = ((Map)ele).getOrDefault("message", "You said {word}.");
                long delayInMilliseconds = ((Number)((Map)ele).getOrDefault("delayInMilliseconds", 50)).longValue();
                boolean forceDisableFormatter = ((Map)ele).getOrDefault("forceDisableFormatter", false);
                return new ResponderRuleUnit(address, pattern, message, delayInMilliseconds, forceDisableFormatter);
            }
            if (ele instanceof ResponderRuleUnit) {
                return (ResponderRuleUnit)ele;
            }
            throw new IllegalArgumentException("Unexpected element type of Object: " + String.valueOf(ele));
        }

        public static List<ResponderRuleUnit> fromList(List list) {
            ArrayList<ResponderRuleUnit> arr = new ArrayList<ResponderRuleUnit>();
            for (Object ele : list) {
                arr.add(ResponderRuleUnit.of(ele));
            }
            return arr;
        }
    }

    public static class BubbleRuleUnit {
        public String address;
        public String pattern;
        public boolean fallback;

        public BubbleRuleUnit() {
            this.address = "*";
            this.pattern = "<(?<name>.*?)> (?<message>.*)";
            this.fallback = false;
        }

        public BubbleRuleUnit(String address, String pattern, boolean fallback) {
            this.address = address;
            this.pattern = pattern;
            this.fallback = fallback;
        }

        public static BubbleRuleUnit of(Object ele) {
            if (ele instanceof Map) {
                String address = ((Map)ele).getOrDefault("address", "*");
                String pattern = ((Map)ele).getOrDefault("pattern", "<(?<name>.*?)> (?<message>.*)");
                boolean fallback = ((Map)ele).getOrDefault("fallback", false);
                return new BubbleRuleUnit(address, pattern, fallback);
            }
            if (ele instanceof BubbleRuleUnit) {
                return (BubbleRuleUnit)ele;
            }
            throw new IllegalArgumentException("Unexpected element type of Object: " + String.valueOf(ele));
        }

        public static List<BubbleRuleUnit> fromList(List list) {
            ArrayList<BubbleRuleUnit> arr = new ArrayList<BubbleRuleUnit>();
            for (Object ele : list) {
                arr.add(BubbleRuleUnit.of(ele));
            }
            return arr;
        }
    }

    public static enum MacroModes {
        LAZY,
        GREEDY;

    }

    public static enum KeyModifiers {
        SHIFT,
        ALT,
        CTRL,
        NONE;

    }

    public static enum ToastModes {
        ADDON,
        POWERSHELL,
        AWT,
        TWO_SLICES;

    }
}

