/*
 * Decompiled with CFR 0.152.
 */
package net.apple70cents.chattools.features.bubble;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.apple70cents.chattools.config.SpecialUnits;
import net.apple70cents.chattools.features.general.NickHider;
import net.apple70cents.chattools.utils.ConfigUtils;
import net.apple70cents.chattools.utils.ContextUtils;
import net.apple70cents.chattools.utils.MessageUtils;
import net.apple70cents.chattools.utils.TextUtils;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_742;
import net.minecraft.class_898;
import org.joml.Matrix4f;

public class BubbleRenderer {
    static class_310 mc = class_310.method_1551();
    static class_327 font = BubbleRenderer.mc.field_1772;
    private static Map<String, BubbleUnit> bubbleMap = new HashMap<String, BubbleUnit>();

    public static void render(class_1297 entity, class_4587 poseStack, class_4597 multiBufferSource, float tickDelta) {
        if (bubbleMap.isEmpty()) {
            return;
        }
        if (BubbleRenderer.mc.field_1687 == null) {
            return;
        }
        for (class_742 potentialSender : BubbleRenderer.mc.field_1687.method_18456()) {
            class_2561 senderDisplayName = potentialSender.method_5476();
            class_2561 entityDisplayName = entity.method_5476();
            if (senderDisplayName == null || entityDisplayName == null) {
                return;
            }
            String senderName = senderDisplayName.getString();
            if (!bubbleMap.containsKey(senderName) || !TextUtils.wash(entityDisplayName.getString()).equals(senderName)) continue;
            if (bubbleMap.get(senderName).getLifetime() >= (long)((Number)ConfigUtils.get("bubble.Lifetime")).intValue() * 1000L) {
                bubbleMap.remove(senderName);
                continue;
            }
            double d = mc.method_1561().method_23168((class_1297)potentialSender);
            if (!(d <= 4096.0)) continue;
            bubbleMap.get(senderName).render(entity, poseStack, multiBufferSource, tickDelta);
        }
    }

    public static void addChatBubble(class_2561 text) {
        String message = TextUtils.wash(text.getString());
        if (BubbleRenderer.mc.field_1687 == null) {
            return;
        }
        String pattern = "";
        boolean serverAddressPass = false;
        boolean fallback = false;
        for (SpecialUnits.BubbleRuleUnit unit : SpecialUnits.BubbleRuleUnit.fromList((List)ConfigUtils.get("bubble.List"))) {
            if (!"*".equals(unit.address) && !Pattern.compile(unit.address).matcher(ContextUtils.getSessionIdentifier()).matches()) continue;
            serverAddressPass = true;
            pattern = unit.pattern;
            fallback = unit.fallback;
            break;
        }
        if (serverAddressPass && !pattern.isEmpty()) {
            Matcher matcher = Pattern.compile(pattern).matcher(message);
            if (matcher.find()) {
                String name = matcher.group("name");
                String messageContext = matcher.group("message");
                bubbleMap.put(name, new BubbleUnit(messageContext, System.currentTimeMillis()));
            } else if (fallback) {
                String sender = MessageUtils.findTheFirstPlayerName(message);
                if (sender == null) {
                    return;
                }
                bubbleMap.put(sender, new BubbleUnit(text, System.currentTimeMillis()));
            }
        }
    }

    protected static class BubbleUnit {
        class_2561 text;
        long startTime;

        BubbleUnit(class_2561 text, long startTime) {
            this.text = text;
            this.startTime = startTime;
        }

        BubbleUnit(String str, long startTime) {
            this.text = TextUtils.of(str);
            this.startTime = startTime;
        }

        public long getLifetime() {
            return System.currentTimeMillis() - this.startTime;
        }

        public String toString() {
            return "BubbleUnit{text=" + String.valueOf(this.text) + ", startTime=" + this.startTime + "}";
        }

        public void render(class_1297 entity, class_4587 poseStack, class_4597 multiBufferSource, float tickDelta) {
            if (BubbleRenderer.mc.field_1724 == null) {
                return;
            }
            class_2561 renderComponent = this.text;
            if (((Boolean)ConfigUtils.get("general.NickHider.Enabled")).booleanValue()) {
                renderComponent = NickHider.work(this.text);
            }
            int yOffset = ((Number)ConfigUtils.get("bubble.YOffset")).intValue();
            class_898 renderDispatcher = mc.method_1561();
            poseStack.method_22903();
            poseStack.method_46416(0.0f, entity.method_17682() + 0.5f + (float)yOffset / 10.0f, 0.0f);
            poseStack.method_22907(renderDispatcher.method_24197());
            poseStack.method_22905(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = poseStack.method_23760().method_23761();
            int maxLineWidth = ((Number)ConfigUtils.get("bubble.MaxLineWidth")).intValue();
            List lines = font.method_1728((class_5348)renderComponent, maxLineWidth);
            int lines_amount = lines.size();
            for (int i = 0; i < lines_amount; ++i) {
                int y = 9 * (i - lines_amount);
                class_5481 line = (class_5481)lines.get(i);
                float xOffset = (float)(-font.method_30880(line)) / 2.0f;
                font.method_22942(line, xOffset, (float)y, 0x20FFFFFF, false, matrix4f, multiBufferSource, class_327.class_6415.field_33994, 0x3F000000, 0xF00000);
                font.method_22942(line, xOffset, (float)y, -1, false, matrix4f, multiBufferSource, class_327.class_6415.field_33993, 0, 0xF00000);
            }
            poseStack.method_22909();
        }
    }
}

