/*
 * Decompiled with CFR 0.152.
 */
package net.apple70cents.chattools.features.notifier;

import com.sshtools.twoslices.ToastActionListener;
import com.sshtools.twoslices.ToastType;
import java.awt.AWTException;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Map;
import javax.swing.SwingUtilities;
import net.apple70cents.chattools.utils.ConfigUtils;
import net.apple70cents.chattools.utils.DownloadUtils;
import net.apple70cents.chattools.utils.LoggerUtils;
import net.apple70cents.chattools.utils.MessageUtils;
import net.apple70cents.chattools.utils.TextUtils;

public class Toast {
    public static void work(String text) {
        String TITLE = TextUtils.trans("texts.toast.title").getString();
        switch ((String)ConfigUtils.get("notifier.Toast.Mode")) {
            case "AWT": {
                Toast.toastWithAWT(TITLE, text);
                break;
            }
            case "POWERSHELL": {
                Toast.toastWithPowershell(TITLE, text);
                break;
            }
            case "ADDON": {
                Toast.toastWithAddon(TITLE, text);
                break;
            }
            case "TWO_SLICES": {
                Toast.toastWithTwoSlices(TITLE, text);
                break;
            }
            default: {
                return;
            }
        }
    }

    public static void toastWithAddon(String caption, String text) {
        if (!DownloadUtils.checkIfFullyReady()) {
            MessageUtils.sendToActionbar(TextUtils.trans("texts.toast.failure"));
            return;
        }
        LoggerUtils.info("[ChatTools] Trying to toast with addon.");
        Runnable runnable = () -> {
            Map<String, String> map = DownloadUtils.getFileNamesMap();
            if (map == null || map.isEmpty()) {
                return;
            }
            String icon = map.get("icon");
            String toastExe = map.get("toastExe");
            File iconFile = Path.of(DownloadUtils.STORAGE_DIR.toString(), icon).toFile();
            File toastExeFile = Path.of(DownloadUtils.STORAGE_DIR.toString(), toastExe).toFile();
            String command = String.format("%s %s %s %s", "\"" + toastExeFile.toString() + "\"", "\"" + caption + "\"", "\"" + text.replace("\n", "\\n") + "\"", "\"" + iconFile.toString() + "\"");
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.redirectErrorStream(true);
            try {
                String line;
                Process process = builder.start();
                InputStream inputStream = process.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                while ((line = reader.readLine()) != null) {
                    LoggerUtils.info(line);
                }
            }
            catch (Exception e) {
                MessageUtils.sendToActionbar(TextUtils.trans("texts.toast.failure"));
                e.printStackTrace();
            }
        };
        Thread thread = new Thread(runnable, "ChatTools-Toast-Thread");
        thread.start();
    }

    public static void toastWithAWT(String caption, String text) {
        LoggerUtils.info("[ChatTools] Toast Notified with AWT.");
        System.setProperty("java.awt.headless", "false");
        LoggerUtils.warn(String.format("[ChatTools] Set java.awt.headless to %s.", GraphicsEnvironment.isHeadless()));
        SwingUtilities.invokeLater(() -> {
            if (GraphicsEnvironment.isHeadless()) {
                System.setProperty("java.awt.headless", "false");
                LoggerUtils.warn(String.format("[ChatTools] GraphicsEnvironment.isHeadless() was true, but now it is set to %s.", GraphicsEnvironment.isHeadless()));
            }
            SystemTray tray = SystemTray.getSystemTray();
            Image image = Toolkit.getDefaultToolkit().createImage("icon.png");
            TrayIcon trayIcon = new TrayIcon(image, "ChatTools");
            try {
                tray.add(trayIcon);
            }
            catch (AWTException e) {
                e.printStackTrace();
            }
            trayIcon.displayMessage(caption, text, TrayIcon.MessageType.NONE);
            tray.remove(trayIcon);
        });
    }

    public static void toastWithPowershell(String caption, String text) {
        try {
            String line;
            LoggerUtils.info("[ChatTools] Toast Notified with Powershell.");
            String COMMAND_TEMPLATE = "powershell.exe -ExecutionPolicy Bypass -Command \"[Windows.UI.Notifications.ToastNotificationManager, Windows.UI.Notifications, ContentType = WindowsRuntime] > $null;$template = [Windows.UI.Notifications.ToastNotificationManager]::GetTemplateContent([Windows.UI.Notifications.ToastTemplateType]::ToastText02);$xml = New-Object Windows.Data.Xml.Dom.XmlDocument;$xml.LoadXml($template.GetXml());$texts = $xml.GetElementsByTagName('text');$texts.Item(0).AppendChild($xml.CreateTextNode('%s')) > $null;$texts.Item(1).AppendChild($xml.CreateTextNode('%s')) > $null;$toast = [Windows.UI.Notifications.ToastNotification]::new($xml);$notifier = [Windows.UI.Notifications.ToastNotificationManager]::CreateToastNotifier('%s');$notifier.Show($toast);\"";
            String command = String.format("powershell.exe -ExecutionPolicy Bypass -Command \"[Windows.UI.Notifications.ToastNotificationManager, Windows.UI.Notifications, ContentType = WindowsRuntime] > $null;$template = [Windows.UI.Notifications.ToastNotificationManager]::GetTemplateContent([Windows.UI.Notifications.ToastTemplateType]::ToastText02);$xml = New-Object Windows.Data.Xml.Dom.XmlDocument;$xml.LoadXml($template.GetXml());$texts = $xml.GetElementsByTagName('text');$texts.Item(0).AppendChild($xml.CreateTextNode('%s')) > $null;$texts.Item(1).AppendChild($xml.CreateTextNode('%s')) > $null;$toast = [Windows.UI.Notifications.ToastNotification]::new($xml);$notifier = [Windows.UI.Notifications.ToastNotificationManager]::CreateToastNotifier('%s');$notifier.Show($toast);\"", caption, text.replace("\n", "'+\\\"`r`n\\\"+'"), "Chat Tools Toast");
            ProcessBuilder builder = new ProcessBuilder("cmd.exe", "/c", command);
            builder.redirectErrorStream(true);
            Process process = builder.start();
            InputStream inputStream = process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                LoggerUtils.info(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void toastWithTwoSlices(String caption, String text) {
        LoggerUtils.info("[ChatTools] Toast Notified with Two-Slices.");
        System.setProperty("java.awt.headless", "false");
        Thread thread = new Thread(() -> com.sshtools.twoslices.Toast.toast((ToastType)ToastType.INFO, (String)caption, (String)text, (ToastActionListener[])new ToastActionListener[0]), "ChatTools-Toast-Thread");
        thread.start();
    }
}

