/*
 * Decompiled with CFR 0.152.
 */
package net.apple70cents.chattools.utils;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.serialization.Codec;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.apple70cents.chattools.config.ConfigScreenGenerator;
import net.apple70cents.chattools.config.ConfigStorage;
import net.apple70cents.chattools.config.SpecialUnits;
import net.apple70cents.chattools.utils.ConfigKeysSuggestionProvider;
import net.apple70cents.chattools.utils.ConfigUtils;
import net.apple70cents.chattools.utils.CopyFeatureScreen;
import net.apple70cents.chattools.utils.DownloadUtils;
import net.apple70cents.chattools.utils.LoggerUtils;
import net.apple70cents.chattools.utils.MessageUtils;
import net.apple70cents.chattools.utils.ScreenOverlayHelper;
import net.apple70cents.chattools.utils.TextUtils;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_4071;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_746;
import net.minecraft.class_8824;
import net.minecraft.class_9010;

public class CommandRegistryUtils {
    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register(CommandRegistryUtils.getBuilder(registryAccess)));
    }

    public static LiteralArgumentBuilder<FabricClientCommandSource> getBuilder(class_7157 buildContext) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"chattools").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"send_to_client").then(ClientCommandManager.literal((String)"text").then(ClientCommandManager.argument((String)"message", (ArgumentType)ClientComponentArgument.textComponent()).executes(t -> {
            class_5250 text = class_2564.method_10881((class_2168)new FakeCommandSource(((FabricClientCommandSource)t.getSource()).getPlayer()), (class_2561)ClientComponentArgument.getComponent((CommandContext<FabricClientCommandSource>)t, "message"), (class_1297)((FabricClientCommandSource)t.getSource()).getPlayer(), (int)0);
            MessageUtils.sendToNonPublicChat((class_2561)text);
            return 1;
        })))).then(ClientCommandManager.literal((String)"actionbar").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"message", (ArgumentType)ClientComponentArgument.textComponent()).executes(t -> {
            class_5250 text = class_2564.method_10881((class_2168)new FakeCommandSource(((FabricClientCommandSource)t.getSource()).getPlayer()), (class_2561)ClientComponentArgument.getComponent((CommandContext<FabricClientCommandSource>)t, "message"), (class_1297)((FabricClientCommandSource)t.getSource()).getPlayer(), (int)0);
            MessageUtils.sendToActionbar((class_2561)text);
            return 1;
        })).then(ClientCommandManager.argument((String)"duration_in_milliseconds", (ArgumentType)IntegerArgumentType.integer()).executes(t -> {
            class_5250 text = class_2564.method_10881((class_2168)new FakeCommandSource(((FabricClientCommandSource)t.getSource()).getPlayer()), (class_2561)ClientComponentArgument.getComponent((CommandContext<FabricClientCommandSource>)t, "message"), (class_1297)((FabricClientCommandSource)t.getSource()).getPlayer(), (int)0);
            int duration = IntegerArgumentType.getInteger((CommandContext)t, (String)"duration_in_milliseconds");
            MessageUtils.sendToActionbar((class_2561)text, duration);
            return 1;
        })))))).then(ClientCommandManager.literal((String)"download").executes(t -> {
            LoggerUtils.info("[ChatTools] Command Executed: Trying to download Addon Toast dependencies");
            DownloadUtils.startDownloadWithCallback((file, progress, nowKB, totalKB) -> MessageUtils.sendToActionbar(TextUtils.trans("texts.download.process", file, progress, nowKB, totalKB)));
            if (DownloadUtils.checkIfFullyReady()) {
                MessageUtils.sendToNonPublicChat(TextUtils.trans("texts.download.success"));
            }
            return 1;
        }))).then(ClientCommandManager.literal((String)"opengui").executes(t -> {
            MessageUtils.sendToActionbar(TextUtils.trans("gui.title"));
            class_310.method_1551().method_18502((class_4071)new ScreenOverlayHelper(class_310.method_1551(), ConfigScreenGenerator.getConfigBuilder().setParentScreen(null).build()){});
            LoggerUtils.info("[ChatTools] Command Executed: GUI opened");
            return 1;
        }))).then(ClientCommandManager.literal((String)"on").executes(t -> {
            ConfigUtils.set("general.ChatTools.Enabled", true);
            LoggerUtils.info("[ChatTools] Command Executed: Enabled ChatTools");
            MessageUtils.sendToActionbar(TextUtils.trans("texts.on"));
            return 1;
        }))).then(ClientCommandManager.literal((String)"off").executes(t -> {
            ConfigUtils.set("general.ChatTools.Enabled", false);
            LoggerUtils.info("[ChatTools] Command Executed: Disabled ChatTools");
            MessageUtils.sendToActionbar(TextUtils.trans("texts.off"));
            return 1;
        }))).then(ClientCommandManager.literal((String)"get_message").then(ClientCommandManager.argument((String)"hash", (ArgumentType)StringArgumentType.string()).executes(t -> {
            String hash = StringArgumentType.getString((CommandContext)t, (String)"hash");
            LoggerUtils.info("[ChatTools] Getting message by hash: " + hash);
            TextUtils.MessageUnit messageUnit = TextUtils.getMessageMap(hash);
            if (messageUnit != null) {
                LoggerUtils.info(String.format("Time:%d Text:%s", messageUnit.unixTimestamp, messageUnit.message));
                class_310.method_1551().method_1507((class_437)new CopyFeatureScreen(messageUnit));
            } else {
                class_5250 errorText = TextUtils.literal("[ChatTools] Failed to get message by hash: " + hash).method_27661().method_27692(class_124.field_1061);
                LoggerUtils.error(errorText.getString());
                MessageUtils.sendToNonPublicChat((class_2561)errorText);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"config").then(ClientCommandManager.literal((String)"openfile").executes(t -> {
            class_156.method_668().method_672(ConfigStorage.FILE);
            MessageUtils.sendToNonPublicChat(TextUtils.trans("texts.requireRestart"));
            return 1;
        }))).then(ClientCommandManager.literal((String)"get").then(ClientCommandManager.argument((String)"key", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new ConfigKeysSuggestionProvider(3)).executes(t -> {
            String key = StringArgumentType.getString((CommandContext)t, (String)"key");
            MessageUtils.sendToNonPublicChat(TextUtils.trans("texts.config.get", key, ConfigUtils.get(key)));
            return 1;
        })))).then(ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"key", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new ConfigKeysSuggestionProvider(2)).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"value", (ArgumentType)StringArgumentType.string()).executes(t -> {
            String key = StringArgumentType.getString((CommandContext)t, (String)"key");
            String value = StringArgumentType.getString((CommandContext)t, (String)"value");
            CommandRegistryUtils.updateConfig(key, value);
            return 1;
        })).then(ClientCommandManager.argument((String)"save", (ArgumentType)BoolArgumentType.bool()).executes(t -> {
            String key = StringArgumentType.getString((CommandContext)t, (String)"key");
            String value = StringArgumentType.getString((CommandContext)t, (String)"value");
            CommandRegistryUtils.updateConfig(key, value);
            if (BoolArgumentType.getBool((CommandContext)t, (String)"save")) {
                ConfigUtils.save();
                MessageUtils.sendToNonPublicChat(TextUtils.trans("texts.config.set.saved"));
            }
            return 1;
        })))))).then(ClientCommandManager.literal((String)"toggle").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"key", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new ConfigKeysSuggestionProvider(1)).executes(t -> {
            String key = StringArgumentType.getString((CommandContext)t, (String)"key");
            CommandRegistryUtils.toggleBooleanConfig(key);
            return 1;
        })).then(ClientCommandManager.argument((String)"save", (ArgumentType)BoolArgumentType.bool()).executes(t -> {
            String key = StringArgumentType.getString((CommandContext)t, (String)"key");
            CommandRegistryUtils.toggleBooleanConfig(key);
            if (BoolArgumentType.getBool((CommandContext)t, (String)"save")) {
                ConfigUtils.save();
                MessageUtils.sendToNonPublicChat(TextUtils.trans("texts.config.set.saved"));
            }
            return 1;
        })))))).then(ClientCommandManager.literal((String)"regex_checker").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"regex", (ArgumentType)StringArgumentType.string()).executes(t -> {
            class_3545<Boolean, String> result = CommandRegistryUtils.checkRegex(StringArgumentType.getString((CommandContext)t, (String)"regex"));
            MessageUtils.sendToNonPublicChat((class_2561)TextUtils.literal((String)result.method_15441()).method_27661().method_27692((Boolean)result.method_15442() != false ? class_124.field_1060 : class_124.field_1061));
            return 1;
        })).then(ClientCommandManager.argument((String)"test_context", (ArgumentType)StringArgumentType.string()).executes(t -> {
            String regex = StringArgumentType.getString((CommandContext)t, (String)"regex");
            String testContext = StringArgumentType.getString((CommandContext)t, (String)"test_context");
            class_3545<Boolean, String> result = CommandRegistryUtils.checkRegex(regex);
            if (!((Boolean)result.method_15442()).booleanValue()) {
                MessageUtils.sendToNonPublicChat((class_2561)TextUtils.literal((String)result.method_15441()).method_27661().method_27692(class_124.field_1061));
                return 1;
            }
            if (Pattern.compile(regex).matcher(testContext).find()) {
                MessageUtils.sendToNonPublicChat((class_2561)TextUtils.literal(String.format("[ChatTools] Context [%s] could pass the RegEx test!", testContext)).method_27661().method_27692(class_124.field_1060));
            } else {
                MessageUtils.sendToNonPublicChat((class_2561)TextUtils.literal(String.format("[ChatTools] Context [%s] could NOT pass the RegEx test!", testContext)).method_27661().method_27692(class_124.field_1061));
            }
            return 1;
        }))));
    }

    public static class_3545<Boolean, String> checkRegex(String pattern) {
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            return new class_3545((Object)false, (Object)e.getMessage().replace("\r", ""));
        }
        return new class_3545((Object)true, (Object)"There's nothing wrong with the RegEx pattern.");
    }

    public static void toggleBooleanConfig(String key) {
        if (ConfigUtils.get(key) == null) {
            MessageUtils.sendToNonPublicChat(TextUtils.trans("texts.config.toggle.error", key));
            return;
        }
        boolean now = (Boolean)ConfigUtils.get(key);
        CommandRegistryUtils.updateConfig(key, String.valueOf(!now));
    }

    public static void updateConfig(String key, String value) {
        try {
            if (!ConfigScreenGenerator.getKey2TypeMappings().containsKey(key)) {
                ConfigUtils.set(key, value);
                MessageUtils.sendToNonPublicChat(TextUtils.trans("texts.config.set.warning", key));
            } else {
                switch (String.valueOf(ConfigScreenGenerator.getKey2TypeMappings().get(key))) {
                    case "boolean": {
                        ConfigUtils.set(key, Boolean.parseBoolean(value));
                        break;
                    }
                    case "String": {
                        ConfigUtils.set(key, String.valueOf(value));
                        break;
                    }
                    case "intSlider": 
                    case "intField": {
                        ConfigUtils.set(key, Integer.parseInt(value));
                        break;
                    }
                    case "doubleField": {
                        ConfigUtils.set(key, Double.parseDouble(value));
                        break;
                    }
                    case "EnumToastModes": {
                        ConfigUtils.set(key, (Object)SpecialUnits.ToastModes.valueOf(value));
                        break;
                    }
                    case "EnumKeyModifiers": {
                        ConfigUtils.set(key, (Object)SpecialUnits.KeyModifiers.valueOf(value));
                        break;
                    }
                    case "FAQ": 
                    case "sub": 
                    case "keycode": 
                    case "StringList": 
                    case "FormatterList": 
                    case "MacroList": 
                    case "BubbleList": 
                    case "ResponderList": 
                    case "CustomJoinMessageList": {
                        MessageUtils.sendToNonPublicChat(TextUtils.trans("texts.config.set.unsupported", key));
                        return;
                    }
                    default: {
                        ConfigUtils.set(key, String.valueOf(value));
                        MessageUtils.sendToNonPublicChat(TextUtils.trans("texts.config.set.warning", key));
                    }
                }
            }
            MessageUtils.sendToNonPublicChat(TextUtils.trans("texts.config.set", key, ConfigUtils.get(key)));
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageUtils.sendToNonPublicChat((class_2561)TextUtils.literal(e.toString()).method_27661().method_10862(class_2583.field_24360.method_27706(class_124.field_1061)));
        }
    }

    public static class ClientComponentArgument
    implements ArgumentType<class_2561> {
        public static final DynamicCommandExceptionType INVALID_COMPONENT_EXCEPTION = new DynamicCommandExceptionType(text -> TextUtils.transWithPrefix("argument.component.invalid", "", text));

        private ClientComponentArgument() {
        }

        public static ClientComponentArgument textComponent() {
            return new ClientComponentArgument();
        }

        public static class_2561 getComponent(CommandContext<FabricClientCommandSource> context, String name) {
            return (class_2561)context.getArgument(name, class_2561.class);
        }

        public class_2561 parse(StringReader stringReader) throws CommandSyntaxException {
            try {
                return (class_2561)class_9010.method_55377((StringReader)stringReader, (Codec)class_8824.field_46597);
            }
            catch (Exception var4) {
                String string = var4.getCause() != null ? var4.getCause().getMessage() : var4.getMessage();
                throw INVALID_COMPONENT_EXCEPTION.createWithContext((ImmutableStringReader)stringReader, (Object)string);
            }
        }
    }

    public static class FakeCommandSource
    extends class_2168 {
        public FakeCommandSource(class_746 player) {
            super(new class_2165(){

                public void method_43496(class_2561 component) {
                    MessageUtils.sendToNonPublicChat(component);
                }

                public boolean method_9200() {
                    return true;
                }

                public boolean method_9202() {
                    return true;
                }

                public boolean method_9201() {
                    return true;
                }
            }, player.method_19538(), player.method_5802(), null, 4, player.method_5820(), player.method_5477(), null, (class_1297)player);
        }
    }
}

