/*
 * Decompiled with CFR 0.152.
 */
package net.apple70cents.chattools.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.apple70cents.chattools.config.ConfigStorage;
import net.apple70cents.chattools.utils.ConfigUtils;
import net.apple70cents.chattools.utils.LoggerUtils;
import net.minecraft.class_310;

public class ConfigMigrationUtils {
    public static final double CURRENT_VERSION = ((Number)ConfigUtils.getDefault("config.version")).doubleValue();
    public static double CONFIG_VERSION = -1.0;

    public static void checkAndMigrate() {
        File configFile = ConfigStorage.FILE;
        if (ConfigMigrationUtils.isConfigOutOfDate(configFile)) {
            LoggerUtils.warn("[ChatTools] The config in version: " + CONFIG_VERSION + " is out of date! Trying to migrate it.");
            ConfigMigrationUtils.migrate(configFile);
        }
    }

    public static void readConfigFileVersion(File configFile) {
        try {
            String content = new String(Files.readAllBytes(Paths.get(configFile.toURI())));
            JsonObject json = (JsonObject)new Gson().fromJson(content, JsonObject.class);
            CONFIG_VERSION = json.has("config.version") ? json.get("config.version").getAsDouble() : 1.0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isConfigOutOfDate(File configFile) {
        ConfigMigrationUtils.readConfigFileVersion(configFile);
        return CONFIG_VERSION < CURRENT_VERSION;
    }

    public static void migrate(File configFile) {
        if (CONFIG_VERSION < 0.0) {
            LoggerUtils.error("[ChatTools] Error: Unknown config version: " + CONFIG_VERSION);
            return;
        }
        if (CONFIG_VERSION < 2.0) {
            ConfigMigrationUtils.migrateFromV1ToV2(configFile, class_310.method_1551().getClass().getClassLoader().getResourceAsStream("assets/chattools/migration_v1_to_v2.json"));
        }
        ConfigMigrationUtils.readConfigFileVersion(configFile);
        if (CONFIG_VERSION < 2.2) {
            ConfigMigrationUtils.migrateFromV2ToV2_2(configFile);
        }
    }

    private static void migrateFromV1ToV2(File file, InputStream migrationMappingsInputStream) {
        try {
            String content = new String(Files.readAllBytes(file.toPath()));
            InputStreamReader reader = new InputStreamReader(migrationMappingsInputStream);
            JsonObject keyMappings = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
            for (Map.Entry ele : keyMappings.entrySet()) {
                String oldKey = (String)ele.getKey();
                String newKey = ((JsonElement)ele.getValue()).getAsString();
                content = content.replace("\"" + oldKey + "\"", "\"" + newKey + "\"");
            }
            String regex = "(?<clear1>\\\"(nickHiderSettings|soundSettings|actionbarSettings|highlightSettings|toastNotifySettings)\\\"\\s*:\\s*\\{)(?<keep>[^{}]*?)(?<clear2>\\})";
            Matcher matcher = Pattern.compile(regex).matcher(content);
            StringBuilder result = new StringBuilder();
            while (matcher.find()) {
                String keepContent = matcher.group("keep");
                matcher.appendReplacement(result, Matcher.quoteReplacement(keepContent));
            }
            matcher.appendTail(result);
            JsonObject json = (JsonObject)new Gson().fromJson(result.toString(), JsonObject.class);
            json.addProperty("config.version", (Number)2.0);
            Files.write(file.toPath(), json.toString().getBytes(), new OpenOption[0]);
            LoggerUtils.info("[ChatTools] Migrated it from v1 to v2!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void migrateFromV2ToV2_2(File file) {
        try {
            String content = new String(Files.readAllBytes(file.toPath()));
            content = content.replace("\"responser.Enabled\":", "\"responder.Enabled\":");
            content = content.replace("\"responser.List\":", "\"responder.List\":");
            JsonObject json = (JsonObject)new Gson().fromJson(content, JsonObject.class);
            json.addProperty("config.version", (Number)2.2);
            Gson GSON = new GsonBuilder().setPrettyPrinting().create();
            try (FileWriter writer = new FileWriter(file);){
                GSON.toJson((JsonElement)json, (Appendable)writer);
                LoggerUtils.info("[ChatTools] Migrated it from v2 to v2.2!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

