/*
 * Decompiled with CFR 0.152.
 */
package net.apple70cents.chattools.features.formatter;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradientParser {
    public static String parse(String input) {
        Pattern pattern = Pattern.compile("<gradient:(\\d+):\\[([^\\]]+)\\](?::(\\d+))?>(.*?)</gradient>", 34);
        Matcher matcher = pattern.matcher(input);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String version = matcher.group(1);
            String colorsStr = matcher.group(2);
            int segmentLength = GradientParser.parseSegmentLength(matcher.group(3));
            String text = matcher.group(4).trim();
            BiFunction<Color, String, String> format = GradientParser.getFormat(version);
            String replacement = GradientParser.processGradient(text, colorsStr, format, segmentLength);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static BiFunction<Color, String, String> getFormat(String formatVersion) {
        switch (formatVersion) {
            case "2": {
                return (color, s) -> String.format("[COLOR=#%02X%02X%02X]%s[/COLOR]", color.getRed(), color.getGreen(), color.getBlue(), s);
            }
            case "3": {
                return (color, s) -> String.format("{&#%02X%02X%02X}%s", color.getRed(), color.getGreen(), color.getBlue(), s);
            }
            case "4": {
                return (color, s) -> String.format("<#%02X%02X%02X>%s", color.getRed(), color.getGreen(), color.getBlue(), s);
            }
            case "5": {
                return (color, s) -> String.format("<##%02X%02X%02X>%s", color.getRed(), color.getGreen(), color.getBlue(), s);
            }
        }
        return (color, s) -> String.format("&#%02X%02X%02X%s", color.getRed(), color.getGreen(), color.getBlue(), s);
    }

    private static int parseSegmentLength(String input) {
        try {
            int size = Integer.parseInt(input);
            return size > 0 ? size : 1;
        }
        catch (Exception e) {
            return 1;
        }
    }

    private static String processGradient(String text, String colorsStr, BiFunction<Color, String, String> format, int segmentLength) {
        List<Color> colors = GradientParser.parseColors(colorsStr);
        if (colors.isEmpty() || text.isEmpty()) {
            return text;
        }
        ArrayList<String> graphemes = new ArrayList<String>();
        BreakIterator boundary = BreakIterator.getCharacterInstance();
        boundary.setText(text);
        int start = boundary.first();
        int end = boundary.next();
        while (end != -1) {
            graphemes.add(text.substring(start, end));
            start = end;
            end = boundary.next();
        }
        ArrayList<String> segments = new ArrayList<String>();
        StringBuilder currentSegment = new StringBuilder();
        int colorableCount = 0;
        for (int i = 0; i < graphemes.size(); ++i) {
            String grapheme = (String)graphemes.get(i);
            if (!grapheme.trim().isEmpty()) {
                ++colorableCount;
            }
            currentSegment.append(grapheme);
            if (colorableCount != segmentLength && i != graphemes.size() - 1) continue;
            segments.add(currentSegment.toString());
            currentSegment.setLength(0);
            colorableCount = 0;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < segments.size(); ++i) {
            double ratio = segments.size() == 1 ? 0.0 : (double)i / (double)(segments.size() - 1);
            Color color = GradientParser.interpolate(colors, ratio);
            result.append(format.apply(color, (String)segments.get(i)));
        }
        return result.toString();
    }

    private static List<Color> parseColors(String colorsStr) {
        String[] hexArray = colorsStr.split(",");
        ArrayList<Color> colors = new ArrayList<Color>();
        for (String hex : hexArray) {
            Color color = Color.fromHex(hex.trim());
            if (color == null) continue;
            colors.add(color);
        }
        return colors;
    }

    private static Color interpolate(List<Color> colors, double t) {
        if (colors.size() == 1) {
            return colors.get(0);
        }
        double segment = 1.0 / (double)(colors.size() - 1);
        int index = Math.min((int)(t / segment), colors.size() - 2);
        double localT = (t - (double)index * segment) / segment;
        Color start = colors.get(index);
        Color end = colors.get(index + 1);
        return new Color(GradientParser.lerp(start.getRed(), end.getRed(), localT), GradientParser.lerp(start.getGreen(), end.getGreen(), localT), GradientParser.lerp(start.getBlue(), end.getBlue(), localT));
    }

    private static int lerp(int start, int end, double t) {
        return (int)Math.round((double)start * (1.0 - t) + (double)end * t);
    }

    public static class Color {
        private final int red;
        private final int green;
        private final int blue;

        private Color(int r, int g, int b) {
            this.red = Color.clamp(r);
            this.green = Color.clamp(g);
            this.blue = Color.clamp(b);
        }

        public static Color fromHex(String hex) {
            int length;
            if (((String)hex).startsWith("#")) {
                hex = ((String)hex).substring(1);
            }
            if ((length = ((String)hex).length()) == 3) {
                hex = "" + ((String)hex).charAt(0) + ((String)hex).charAt(0) + ((String)hex).charAt(1) + ((String)hex).charAt(1) + ((String)hex).charAt(2) + ((String)hex).charAt(2);
            } else if (length != 6) {
                return null;
            }
            try {
                int rgb = Integer.parseInt((String)hex, 16);
                return new Color(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        public int getRed() {
            return this.red;
        }

        public int getGreen() {
            return this.green;
        }

        public int getBlue() {
            return this.blue;
        }

        private static int clamp(int value) {
            return Math.max(0, Math.min(255, value));
        }
    }
}

