/*
 * Decompiled with CFR 0.152.
 */
package net.apple70cents.chattools.features.general;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.apple70cents.chattools.utils.ConfigUtils;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class ExclusiveActionbarHandler {
    private static List<ExclusiveActionbarMessageUnit> messageUnitList = new CopyOnWriteArrayList<ExclusiveActionbarMessageUnit>();

    public static void addToRenderQueue(class_2561 message, long lifeTimeInMillis) {
        messageUnitList.add(new ExclusiveActionbarMessageUnit(message, lifeTimeInMillis));
    }

    public static void tick() {
        long currentTime = System.currentTimeMillis();
        messageUnitList.removeIf(unit -> currentTime - unit.startTime > unit.lifeTimeInMillis);
    }

    public static void render(class_332 context) {
        class_327 font = class_310.method_1551().field_1772;
        float size = ((Number)ConfigUtils.get("general.ExclusiveActionbar.Size")).floatValue();
        int xOffset = ((Number)ConfigUtils.get("general.ExclusiveActionbar.XOffset")).intValue();
        int yOffset = ((Number)ConfigUtils.get("general.ExclusiveActionbar.YOffset")).intValue();
        int index = 0;
        for (ExclusiveActionbarMessageUnit ele : messageUnitList) {
            int opacity = ExclusiveActionbarHandler.calculateOpacity(ele.startTime, ele.lifeTimeInMillis);
            yOffset += ExclusiveActionbarHandler.calculateOffset(ele.startTime, ele.lifeTimeInMillis);
            if (opacity <= 2) continue;
            context.method_51448().method_22903();
            context.method_51448().method_46416((float)context.method_51421() / 2.0f, (float)context.method_51443() - 68.0f - 4.0f, 0.0f);
            context.method_51448().method_22905(size, size, 1.0f);
            context.method_27534(font, ele.text, xOffset, yOffset + index * 12, opacity << 24 | 0xFFFFFF);
            context.method_51448().method_22909();
            ++index;
        }
    }

    private static int calculateOpacity(long startTime, long lifeTime) {
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - startTime;
        if (elapsedTime <= 0L || elapsedTime >= lifeTime) {
            return 0;
        }
        long fadeDuration = 500L;
        if (elapsedTime <= fadeDuration) {
            return (int)((double)elapsedTime * 255.0 / (double)fadeDuration);
        }
        if (elapsedTime <= lifeTime - fadeDuration) {
            return 255;
        }
        return (int)((double)(lifeTime - elapsedTime) * 255.0 / (double)fadeDuration);
    }

    private static int calculateOffset(long startTime, long lifeTime) {
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - startTime;
        if (elapsedTime <= 0L || elapsedTime >= lifeTime) {
            return 10;
        }
        long fadeDuration = 200L;
        if (elapsedTime <= fadeDuration) {
            double progress = Math.sin((double)elapsedTime / (double)fadeDuration * Math.PI / 2.0);
            return (int)(10.0 - progress * 10.0);
        }
        return 0;
    }

    protected static class ExclusiveActionbarMessageUnit {
        class_2561 text;
        long startTime;
        long lifeTimeInMillis;

        ExclusiveActionbarMessageUnit(class_2561 text, long startTime, long lifeTimeInMillis) {
            this.text = text;
            this.startTime = startTime;
            this.lifeTimeInMillis = lifeTimeInMillis;
        }

        ExclusiveActionbarMessageUnit(class_2561 text, long lifeTimeInMillis) {
            this.text = text;
            this.startTime = System.currentTimeMillis();
            this.lifeTimeInMillis = lifeTimeInMillis;
        }
    }
}

