/*
 * Decompiled with CFR 0.152.
 */
package net.apple70cents.chattools.features.general;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import net.apple70cents.chattools.config.SpecialUnits;
import net.apple70cents.chattools.utils.ConfigUtils;
import net.apple70cents.chattools.utils.KeyboardUtils;
import net.apple70cents.chattools.utils.LoggerUtils;
import net.apple70cents.chattools.utils.TextUtils;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_408;

public class Translator {
    public static boolean shouldWork() {
        if (!((Boolean)ConfigUtils.get("general.Translator.Enabled")).booleanValue()) {
            return false;
        }
        if (!(class_310.method_1551().field_1755 instanceof class_408)) {
            return false;
        }
        return KeyboardUtils.isKeyPressingWithModifier("key.keyboard.tab", SpecialUnits.KeyModifiers.SHIFT, SpecialUnits.MacroModes.LAZY);
    }

    public static void work(class_342 chatField) {
        String method;
        String originalText = chatField.method_1882();
        String string = method = (Boolean)ConfigUtils.get("general.Translator.PostInstead") != false ? "POST" : "GET";
        if (((String)ConfigUtils.get("general.Translator.API")).isBlank()) {
            chatField.method_1852(TextUtils.trans("texts.translator.requireApi").getString());
            return;
        }
        chatField.method_1852(TextUtils.trans("texts.translator.await").getString());
        Runnable runnable = () -> {
            try {
                Object api = (String)ConfigUtils.get("general.Translator.API");
                api = ((String)api).contains("{text}") ? ((String)api).replace("{text}", URLEncoder.encode(originalText, StandardCharsets.UTF_8)) : (String)api + URLEncoder.encode(originalText, StandardCharsets.UTF_8);
                URL formattedUrl = new URL((String)api);
                HttpURLConnection connection = (HttpURLConnection)formattedUrl.openConnection();
                connection.setRequestMethod(method);
                LoggerUtils.info("[ChatTools] Visiting \"" + (String)api + "\" with method: " + method);
                int responseCode = connection.getResponseCode();
                if (responseCode != 200) {
                    throw new RuntimeException("Failed with HTTP Error Code " + responseCode);
                }
                try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                    String line;
                    StringBuilder response = new StringBuilder();
                    while ((line = in.readLine()) != null) {
                        response.append(line);
                    }
                    chatField.method_1852(response.toString());
                    LoggerUtils.info("[ChatTools] Response: " + String.valueOf(response));
                    return;
                }
            }
            catch (Exception e) {
                LoggerUtils.error("[ChatTools] Error occurred when visiting Translation API");
                chatField.method_1852(e.toString());
                e.printStackTrace();
                return;
            }
        };
        Thread thread = new Thread(runnable, "ChatTools-Translation-Thread");
        thread.start();
    }
}

