/*
 * Decompiled with CFR 0.152.
 */
package net.apple70cents.chattools.features.responder;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.apple70cents.chattools.config.SpecialUnits;
import net.apple70cents.chattools.utils.ConfigUtils;
import net.apple70cents.chattools.utils.ContextUtils;
import net.apple70cents.chattools.utils.LoggerUtils;
import net.apple70cents.chattools.utils.MessageUtils;
import net.apple70cents.chattools.utils.TextUtils;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class Responder {
    static class_310 mc = class_310.method_1551();

    static String replaceAllGroupNames(String rawMessageReceived, String rawPattern, String message) {
        String groupNamePattern = "(?<!\\\\)\\{(?<group>.*?)(?<!\\\\)}";
        Matcher matcher = Pattern.compile("(?<!\\\\)\\{(?<group>.*?)(?<!\\\\)}").matcher(message);
        Matcher rawMessageMatcher = Pattern.compile(rawPattern).matcher(rawMessageReceived);
        if (rawMessageMatcher.find()) {
            while (matcher.find()) {
                String groupName = matcher.group("group");
                String context = rawMessageMatcher.group(groupName);
                if (context == null || context.isBlank()) continue;
                message = message.replace("{" + groupName + "}", context);
            }
        }
        return message;
    }

    public static void work(class_2561 text) {
        String messageReceived = TextUtils.wash(text.getString());
        boolean shouldRespond = false;
        String pattern = "";
        String message = "";
        long delayInMilliseconds = 0L;
        boolean forceDisableFormatter = false;
        for (SpecialUnits.ResponderRuleUnit unit : SpecialUnits.ResponderRuleUnit.fromList((List)ConfigUtils.get("responder.List"))) {
            if (!"*".equals(unit.address) && !Pattern.compile(unit.address).matcher(ContextUtils.getSessionIdentifier()).matches() || !Pattern.compile(unit.pattern, 8).matcher(messageReceived).find()) continue;
            shouldRespond = true;
            pattern = unit.pattern;
            message = unit.message;
            delayInMilliseconds = unit.delayInMilliseconds;
            forceDisableFormatter = unit.forceDisableFormatter;
            break;
        }
        if (shouldRespond) {
            Responder.makeMessageSchedule(messageReceived, pattern, message, delayInMilliseconds, forceDisableFormatter);
        }
    }

    public static void makeMessageSchedule(String messageReceived, String pattern, String msg, long delayInMilliseconds, boolean forceDisableFormatter) {
        LoggerUtils.info("[ChatTools] Will respond within " + delayInMilliseconds + "ms");
        new Thread(() -> {
            try {
                Thread.sleep(delayInMilliseconds);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            String message = msg;
            if (Responder.mc.field_1724 != null) {
                message = message.replace("{pos}", String.format("(%d,%d,%d)", (int)Responder.mc.field_1724.method_23317(), (int)Responder.mc.field_1724.method_23318(), (int)Responder.mc.field_1724.method_23321()));
            }
            try {
                message = Responder.replaceAllGroupNames(messageReceived, pattern, message);
            }
            catch (Exception e) {
                LoggerUtils.error("[ChatTools] Failed when auto responding: " + e.getMessage());
                MessageUtils.sendToNonPublicChat(TextUtils.trans("texts.respond.failure", e.getMessage()));
                MessageUtils.sendToActionbar(TextUtils.trans("texts.respond.failure", e.getMessage()));
                e.printStackTrace();
                return;
            }
            LoggerUtils.info("[ChatTools] Respond to `" + pattern + "`, with message `" + message + "`");
            message = message.replace("\\{", "{").replace("\\}", "}");
            MessageUtils.sendToPublicChat(message, forceDisableFormatter);
            MessageUtils.setJustSentMessage(false);
        }).start();
    }
}

