/*
 * Decompiled with CFR 0.152.
 */
package net.apple70cents.chattools.mixins;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import java.time.Instant;
import java.util.List;
import net.apple70cents.chattools.features.bubble.BubbleRenderer;
import net.apple70cents.chattools.features.filter.ChatFilter;
import net.apple70cents.chattools.features.general.ChatColorEraser;
import net.apple70cents.chattools.features.general.ChatCompactor;
import net.apple70cents.chattools.features.general.ClickEventsPreviewer;
import net.apple70cents.chattools.features.general.NickHider;
import net.apple70cents.chattools.features.general.Timestamp;
import net.apple70cents.chattools.features.notifier.BasicNotifier;
import net.apple70cents.chattools.features.responder.Responder;
import net.apple70cents.chattools.utils.ConfigUtils;
import net.apple70cents.chattools.utils.LoggerUtils;
import net.apple70cents.chattools.utils.MessageUtils;
import net.apple70cents.chattools.utils.TextUtils;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_303;
import net.minecraft.class_338;
import net.minecraft.class_7469;
import net.minecraft.class_7591;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={class_338.class})
public abstract class ChatComponentMixin {
    @Shadow
    @Final
    private List<class_303> field_2061;

    @Shadow
    public abstract void method_1817();

    @ModifyExpressionValue(method={"addRecentChat", "addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;ILnet/minecraft/client/GuiMessageTag;Z)V"}, at={@At(value="CONSTANT", args={"intValue=100"})})
    public int modifyMaxHistorySize(int originalMaxSize) {
        if (((Boolean)ConfigUtils.get("general.ChatTools.Enabled")).booleanValue()) {
            return ((Number)ConfigUtils.get("general.MaxHistoryLength")).intValue();
        }
        return 100;
    }

    @Inject(method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;Lnet/minecraft/client/GuiMessageTag;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onReceivingMessages(class_2561 message, class_7469 signature, class_7591 indicator, CallbackInfo ci) {
        if (!((Boolean)ConfigUtils.get("general.ChatTools.Enabled")).booleanValue()) {
            return;
        }
        if (ChatFilter.shouldFilter(message)) {
            LoggerUtils.info("[ChatTools] Filtered message: " + message.getString());
            if (((Boolean)ConfigUtils.get("responder.RespondToFilteredMessages")).booleanValue()) {
                Responder.work(message);
            }
            ChatFilter.sendPlaceholderIfActive();
            ci.cancel();
        }
    }

    @ModifyArgs(method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;Lnet/minecraft/client/GuiMessageTag;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/ChatComponent;addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;ILnet/minecraft/client/GuiMessageTag;Z)V"))
    public void onReceivingMessages(Args args) {
        boolean MESSAGE_IDX = false;
        if (!((Boolean)ConfigUtils.get("general.ChatTools.Enabled")).booleanValue()) {
            return;
        }
        class_2561 message = (class_2561)args.get(0);
        if (ChatFilter.shouldFilter(message)) {
            return;
        }
        if (((Boolean)ConfigUtils.get("bubble.Enabled")).booleanValue()) {
            BubbleRenderer.addChatBubble(message);
        }
        if (((Boolean)ConfigUtils.get("responder.Enabled")).booleanValue() && !MessageUtils.hadJustSentMessage()) {
            Responder.work(message);
        }
        if (((Boolean)ConfigUtils.get("general.OverrideChatColor.Enabled")).booleanValue()) {
            message = ChatColorEraser.work(message);
        }
        if (((Boolean)ConfigUtils.get("general.NickHider.Enabled")).booleanValue()) {
            message = NickHider.work(message);
        }
        int occurrenceCount = 1;
        if (((Boolean)ConfigUtils.get("general.ChatCompactor.Enabled")).booleanValue() && (occurrenceCount = ChatCompactor.calculateOccurrenceCount(message)) > 1 && !this.field_2061.isEmpty()) {
            this.field_2061.remove(0);
            this.method_1817();
        }
        String hashcode = TextUtils.putMessageMap(message, Instant.now().getEpochSecond(), occurrenceCount);
        if (((Boolean)ConfigUtils.get("notifier.Highlight.InsertBeforeTimestamps")).booleanValue()) {
            if (((Boolean)ConfigUtils.get("general.Timestamp.Enabled")).booleanValue()) {
                message = Timestamp.work(message, hashcode);
            }
            if (BasicNotifier.shouldWork(message)) {
                message = BasicNotifier.work(message);
            }
        } else {
            if (BasicNotifier.shouldWork(message)) {
                message = BasicNotifier.work(message);
            }
            if (((Boolean)ConfigUtils.get("general.Timestamp.Enabled")).booleanValue()) {
                message = Timestamp.work(message, hashcode);
            }
        }
        if (((Boolean)ConfigUtils.get("general.ChatCompactor.Enabled")).booleanValue()) {
            message = ChatCompactor.appendTrailing(message, occurrenceCount);
        }
        MessageUtils.setJustSentMessage(false);
        args.set(0, (Object)message);
    }

    @Inject(method={"getClickedComponentStyleAt"}, at={@At(value="RETURN")}, cancellable=true)
    public void modifyHoverEvent(double x, double y, CallbackInfoReturnable<class_2583> cir) {
        class_2583 style = (class_2583)cir.getReturnValue();
        if (!((Boolean)ConfigUtils.get("general.ChatTools.Enabled")).booleanValue()) {
            cir.setReturnValue((Object)style);
            return;
        }
        if (!((Boolean)ConfigUtils.get("general.PreviewClickEvents.Enabled")).booleanValue()) {
            cir.setReturnValue((Object)style);
            return;
        }
        cir.setReturnValue((Object)ClickEventsPreviewer.work(style));
    }
}

