/*
 * Decompiled with CFR 0.152.
 */
package net.apple70cents.chattools.utils;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.apple70cents.chattools.utils.CopyFeatureScreen;
import net.apple70cents.chattools.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public class ChatHistoryNavigatorScreen
extends class_437 {
    @Nullable
    public class_342 keywordField;
    ChatUnitListWidget chatUnitListWidget;
    class_4185 modeSelectorWidget;

    public ChatHistoryNavigatorScreen(class_2561 title) {
        super(title);
    }

    protected void method_25426() {
        super.method_25426();
        this.keywordField = new class_342(this.field_22793, 30, 35, this.field_22789 - 155, 20, this.keywordField, TextUtils.trans("texts.ChatHistoryNavigator.placeholder"));
        this.keywordField.method_1880(Integer.MAX_VALUE);
        this.keywordField.method_1863(keyword -> this.chatUnitListWidget.setKeyword((String)keyword));
        this.method_37063((class_364)this.keywordField);
        this.method_48265((class_364)this.keywordField);
        class_310 class_3102 = class_310.method_1551();
        Objects.requireNonNull(this.field_22793);
        this.chatUnitListWidget = new ChatUnitListWidget(class_3102, this.field_22789 - 60, this.field_22790 - 120, 65, 9 + 3, this.keywordField.method_1882(), this.chatUnitListWidget);
        this.chatUnitListWidget.method_25333(30);
        this.chatUnitListWidget.method_31322(false);
        this.chatUnitListWidget.method_31323(false);
        this.method_25429((class_364)this.chatUnitListWidget);
        class_2561 modeSelectorButtonText = TextUtils.trans("texts.ChatHistoryNavigator.modes." + String.valueOf((Object)this.chatUnitListWidget.getSearchMode()));
        class_4185.class_4241 pressAction = button -> {
            this.chatUnitListWidget.switchToNextSearchMode();
            this.modeSelectorWidget.method_25355(TextUtils.trans("texts.ChatHistoryNavigator.modes." + String.valueOf((Object)this.chatUnitListWidget.getSearchMode())));
            this.modeSelectorWidget.method_47400(class_7919.method_47407((class_2561)TextUtils.trans("texts.ChatHistoryNavigator.modes." + String.valueOf((Object)this.chatUnitListWidget.getSearchMode()) + ".@Tooltip")));
            this.chatUnitListWidget.setKeyword(this.keywordField.method_1882());
            this.chatUnitListWidget.refreshUnitEntries();
        };
        this.modeSelectorWidget = class_4185.method_46430((class_2561)modeSelectorButtonText, (class_4185.class_4241)pressAction).method_46434(this.field_22789 - 120, 35, 90, 20).method_46431();
        this.method_37063((class_364)this.modeSelectorWidget);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46434(this.field_22789 / 2 - 80, this.field_22790 - 28, 160, 20).method_46431());
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        if (this.chatUnitListWidget.searchMode == SearchModes.REGEX) {
            try {
                if (this.keywordField != null) {
                    Pattern.compile(this.keywordField.method_1882());
                }
            }
            catch (PatternSyntaxException e) {
                class_5250 errorText = TextUtils.literal(e.getDescription()).method_27661().method_10862(class_2583.field_24360.method_27706(class_124.field_1061));
                context.method_51438(this.field_22793, (class_2561)errorText, mouseX, mouseY);
            }
        }
        if (!this.chatUnitListWidget.hashcodeResultList.isEmpty()) {
            this.chatUnitListWidget.method_25394(context, mouseX, mouseY, delta);
        }
    }

    protected class ChatUnitListWidget
    extends class_350<ChatUnitEntry> {
        private List<String> hashcodeResultList;
        private SearchModes searchMode;

        protected void updateResultList(String keyword) {
            if (this.hashcodeResultList == null) {
                this.hashcodeResultList = new ArrayList<String>();
            }
            this.hashcodeResultList.clear();
            if (keyword == null || keyword.trim().isEmpty()) {
                return;
            }
            if (this.searchMode == SearchModes.REGEX) {
                try {
                    Pattern.compile(keyword);
                }
                catch (PatternSyntaxException e) {
                    return;
                }
            }
            Predicate<Map.Entry> filter = null;
            switch (this.searchMode.ordinal()) {
                case 0: {
                    filter = entry -> TextUtils.wash(((TextUtils.MessageUnit)entry.getValue()).message.getString().toUpperCase()).contains(keyword.toUpperCase());
                    break;
                }
                case 1: {
                    filter = entry -> TextUtils.wash(((TextUtils.MessageUnit)entry.getValue()).message.getString()).contains(keyword);
                    break;
                }
                case 2: {
                    try {
                        filter = entry -> Pattern.compile(keyword, 8).matcher(TextUtils.wash(((TextUtils.MessageUnit)entry.getValue()).message.getString())).find();
                        break;
                    }
                    catch (PatternSyntaxException e) {
                        return;
                    }
                }
            }
            Stream stream = TextUtils.messageMap.entrySet().stream();
            this.hashcodeResultList = stream.filter(filter).map(Map.Entry::getKey).collect(Collectors.toList());
        }

        protected void refreshUnitEntries() {
            if (ChatHistoryNavigatorScreen.this.chatUnitListWidget == null) {
                return;
            }
            this.method_25339();
            for (String hashcode : this.hashcodeResultList) {
                this.method_25321((class_350.class_351)new ChatUnitEntry(hashcode));
            }
        }

        public void setKeyword(String keyword) {
            this.updateResultList(keyword);
            this.refreshUnitEntries();
        }

        public void switchToNextSearchMode() {
            if (this.searchMode == SearchModes.CASE_INSENSITIVE) {
                this.searchMode = SearchModes.CASE_SENSITIVE;
            } else if (this.searchMode == SearchModes.CASE_SENSITIVE) {
                this.searchMode = SearchModes.REGEX;
            } else if (this.searchMode == SearchModes.REGEX) {
                this.searchMode = SearchModes.CASE_INSENSITIVE;
            }
        }

        public void setSearchMode(SearchModes searchMode) {
            this.searchMode = searchMode;
        }

        public SearchModes getSearchMode() {
            return this.searchMode;
        }

        public ChatUnitListWidget(class_310 client, int width, int height, int y, int itemHeight, @Nullable String keyword, ChatUnitListWidget copyFrom) {
            super(client, width, height, y, y + height, itemHeight);
            this.searchMode = SearchModes.CASE_INSENSITIVE;
            if (copyFrom != null) {
                this.hashcodeResultList = copyFrom.hashcodeResultList;
                this.searchMode = copyFrom.getSearchMode();
            } else {
                this.hashcodeResultList = new ArrayList<String>();
                this.updateResultList(keyword);
            }
            this.refreshUnitEntries();
        }

        public int method_25322() {
            return this.field_22742 - 15;
        }

        protected int method_25329() {
            int x = this.field_19088;
            return this.field_22742 - 7 + x;
        }

        public boolean method_25401(double mouseX, double mouseY, double verticalAmount) {
            Objects.requireNonNull(ChatHistoryNavigatorScreen.this.field_22793);
            int lineHeight = 9 + 3;
            double scrollAmount = class_437.method_25442() ? (double)lineHeight : (double)(lineHeight * 7);
            this.method_25307(this.method_25341() - verticalAmount * scrollAmount);
            return true;
        }

        @Nullable
        public class_7919 getTooltip() {
            if (this.method_37019() == null) {
                return null;
            }
            return class_7919.method_47407((class_2561)((ChatUnitEntry)this.method_37019()).getTooltip());
        }

        public void method_37020(class_6382 builder) {
            if (this.method_37019() != null) {
                builder.method_37034(class_6381.field_33788, ((ChatUnitEntry)this.method_37019()).getText());
            }
        }
    }

    public static enum SearchModes {
        CASE_INSENSITIVE,
        CASE_SENSITIVE,
        REGEX;

    }

    protected class ChatUnitEntry
    extends class_4265.class_4266<ChatUnitEntry> {
        TextUtils.MessageUnit messageUnit;

        public ChatUnitEntry(String hashcode) {
            this.messageUnit = TextUtils.getMessageMap(hashcode);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                class_310.method_1551().method_1507((class_437)new CopyFeatureScreen(this.messageUnit));
                return true;
            }
            return false;
        }

        public class_2561 getText() {
            if (this.messageUnit == null) {
                return TextUtils.literal("\u00a7lOutdated message! It should NOT be here!");
            }
            return this.messageUnit.message;
        }

        public class_2561 getTooltip() {
            LocalDateTime time = LocalDateTime.ofEpochSecond(this.messageUnit.unixTimestamp, 0, ZoneId.systemDefault().getRules().getOffset(Instant.now()));
            String offsetString = ZoneId.systemDefault().getRules().getOffset(Instant.now()).getId();
            class_2561 longTimeDisplay = TextUtils.of(String.format("%4d/%d/%d %02d:%02d:%02d\nUTC%s", time.getYear(), time.getMonth().getValue(), time.getDayOfMonth(), time.getHour(), time.getMinute(), time.getSecond(), offsetString));
            return longTimeDisplay;
        }

        public List<? extends class_6379> method_37025() {
            return Collections.emptyList();
        }

        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }

        public void method_25343(class_332 context, int index, int y, int x, int itemWidth, int itemHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            context.method_27535(ChatHistoryNavigatorScreen.this.field_22793, this.getText(), x, y, 0xFFFFFF);
            if (hovered) {
                List timestamps = Arrays.stream(this.getTooltip().getString().split("\n")).map(TextUtils::of).collect(Collectors.toList());
                context.method_51434(ChatHistoryNavigatorScreen.this.field_22793, timestamps, mouseX, mouseY);
            }
        }
    }
}

