/*
 * Decompiled with CFR 0.152.
 */
package net.apple70cents.chattools.utils;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import net.apple70cents.chattools.utils.ChatHistoryNavigatorScreen;
import net.apple70cents.chattools.utils.TextUtils;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5489;

public class CopyFeatureScreen
extends class_437 {
    private class_5489 messageSplit;
    private class_437 oldScreen;
    private TextUtils.MessageUnit unit;
    private Map<String, class_4185> buttons;
    private final Map<String, ButtonData> buttonDatas;
    private class_5489 previewTextSplit;

    public CopyFeatureScreen(TextUtils.MessageUnit unit) {
        super(TextUtils.trans("texts.copy.title"));
        this.oldScreen = class_310.method_1551().field_1755;
        this.messageSplit = class_5489.field_26528;
        this.unit = unit;
        this.buttons = new HashMap<String, class_4185>();
        this.buttonDatas = new HashMap<String, ButtonData>();
    }

    protected void method_25426() {
        super.method_25426();
        this.messageSplit = class_5489.method_30890((class_327)this.field_22793, (class_5348)this.unit.message, (int)(this.field_22789 - 50));
        this.buttonDatas.put("copyObjectData", new ButtonData(-3, this.unit.message.toString()));
        this.buttonDatas.put("copyRaw", new ButtonData(-2, this.unit.message.getString()));
        this.buttonDatas.put("copyWithColorCodeEscaped", new ButtonData(-1, TextUtils.decodeColorCodes(this.unit.message.getString())));
        this.buttonDatas.put("copyWithNoColorCode", new ButtonData(0, TextUtils.wash(this.unit.message.getString())));
        this.buttonDatas.put("copyUnixTimestamp", new ButtonData(1, String.valueOf(this.unit.unixTimestamp)));
        this.buttonDatas.put("copyTimestamp", new ButtonData(2, this.getLongTimeDisplay(this.unit.unixTimestamp)));
        this.addButtons();
    }

    protected void addButtons() {
        int midH = this.field_22790 / 2;
        for (Map.Entry<String, ButtonData> buttonData : this.buttonDatas.entrySet()) {
            this.buttons.put(buttonData.getKey(), this.addCenterButton(buttonData.getKey(), midH + 21 * buttonData.getValue().index, button -> class_310.method_1551().field_1774.method_1455(((ButtonData)buttonData.getValue()).content)));
        }
        this.addCenterButton("cancel", this.field_22790 - 30, button -> {
            if (this.oldScreen instanceof ChatHistoryNavigatorScreen) {
                if (((ChatHistoryNavigatorScreen)this.oldScreen).keywordField != null) {
                    ((ChatHistoryNavigatorScreen)this.oldScreen).chatUnitListWidget.setKeyword(((ChatHistoryNavigatorScreen)this.oldScreen).keywordField.method_1882());
                } else {
                    ((ChatHistoryNavigatorScreen)this.oldScreen).chatUnitListWidget.setKeyword("");
                }
            }
            class_310.method_1551().method_1507(this.oldScreen);
        });
    }

    protected class_4185 addCenterButton(String translationKey, int y, class_4185.class_4241 func) {
        int buttonW = 200;
        int buttonH = 20;
        class_4185 buttonWidget = class_4185.method_46430((class_2561)TextUtils.trans("texts.copy." + translationKey), (class_4185.class_4241)func).method_46433(this.field_22789 / 2 - buttonW / 2, y - buttonH / 2).method_46437(buttonW, buttonH).method_46431();
        this.method_37063((class_364)buttonWidget);
        return buttonWidget;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.messageSplit.method_30888(context, this.field_22789 / 2, this.getMessageY());
        class_2561 previewText = TextUtils.SPACER;
        for (Map.Entry<String, class_4185> button : this.buttons.entrySet()) {
            if (!button.getValue().method_25405((double)mouseX, (double)mouseY)) continue;
            previewText = TextUtils.of(this.buttonDatas.get((Object)button.getKey()).content);
        }
        this.previewTextSplit = class_5489.method_30890((class_327)this.field_22793, (class_5348)previewText, (int)(this.field_22789 - 50));
        this.previewTextSplit.method_30888(context, this.field_22789 / 2, this.field_22790 / 2 + 60);
    }

    private int getTitleY() {
        int i = (this.field_22790 - this.getMessagesHeight()) / 2;
        return class_3532.method_15340((int)(i - 29), (int)10, (int)30);
    }

    private int getMessageY() {
        return this.getTitleY() + 20;
    }

    private int getMessagesHeight() {
        return this.messageSplit.method_30887() * 9;
    }

    private String getLongTimeDisplay(long timestamp) {
        Instant instant = Instant.ofEpochSecond(timestamp);
        LocalDateTime currentTime = LocalDateTime.ofEpochSecond(timestamp, 0, ZoneId.systemDefault().getRules().getOffset(instant));
        String offsetString = ZoneId.systemDefault().getRules().getOffset(instant).getId();
        String longTimeDisplay = String.format("%4d/%d/%d %02d:%02d:%02d\nUTC%s", currentTime.getYear(), currentTime.getMonth().getValue(), currentTime.getDayOfMonth(), currentTime.getHour(), currentTime.getMinute(), currentTime.getSecond(), offsetString);
        return longTimeDisplay;
    }

    protected static class ButtonData {
        public int index;
        public String content;

        public ButtonData(int index, String content) {
            this.index = index;
            this.content = content;
        }
    }
}

