/*
 * Decompiled with CFR 0.152.
 */
package net.apple70cents.chattools.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import net.apple70cents.chattools.utils.ConfigUtils;
import net.apple70cents.chattools.utils.LoggerUtils;
import net.apple70cents.chattools.utils.QuadConsumer;
import net.fabricmc.loader.api.FabricLoader;

public class DownloadUtils {
    private static final String DOWNLOAD_SITE = "https://70centsapple.top/download/chat_tools/download.php?";
    public static final Path STORAGE_DIR = Path.of(FabricLoader.getInstance().getGameDir().toString(), "chattools");
    private static final Map<String, String> WIN_7_FILENAMES = Map.of("icon", "icon.ico", "toastExe", "toast-win7.exe");
    private static final Map<String, String> WIN_10_11_FILENAMES = Map.of("icon", "icon.ico", "toastExe", "toast-win10-and-win11.exe");
    private static final String OS = System.getProperty("os.name");
    private static boolean shouldCheckMD5OnJudgingReadiness = true;

    public static boolean shouldCheckIfFullyReady() {
        return (Boolean)ConfigUtils.get("notifier.Toast.Enabled") != false && "ADDON".equals((String)ConfigUtils.get("notifier.Toast.Mode"));
    }

    public static boolean checkIfFullyReady() {
        Map<String, String> fileNames = DownloadUtils.getFileNamesMap();
        if (fileNames == null) {
            return false;
        }
        for (String fileName : fileNames.values()) {
            File file = Path.of(STORAGE_DIR.toString(), fileName).toFile();
            if (!file.exists()) {
                shouldCheckMD5OnJudgingReadiness = true;
                return false;
            }
            if (!shouldCheckMD5OnJudgingReadiness) continue;
            try {
                String md5Url = DOWNLOAD_SITE + fileName + ".md5";
                String md5 = DownloadUtils.downloadMD5(md5Url);
                if (DownloadUtils.checkMD5(file.toPath(), md5)) continue;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        shouldCheckMD5OnJudgingReadiness = false;
        return true;
    }

    public static Map<String, String> getFileNamesMap() {
        switch (OS) {
            case "Windows 7": 
            case "Windows 8.1": {
                return WIN_7_FILENAMES;
            }
            case "Windows 10": 
            case "Windows 11": {
                return WIN_10_11_FILENAMES;
            }
        }
        return null;
    }

    public static void startDownload() {
        DownloadUtils.startDownloadWithCallback(null);
    }

    public static void startDownloadWithCallback(QuadConsumer<String, Integer, Integer, Integer> processSupplier) {
        Runnable runnable = () -> {
            switch (OS) {
                case "Windows 7": 
                case "Windows 8.1": {
                    DownloadUtils.downloadAndCheckFiles(WIN_7_FILENAMES.values().stream().toList(), STORAGE_DIR, processSupplier);
                    return;
                }
                case "Windows 10": 
                case "Windows 11": {
                    DownloadUtils.downloadAndCheckFiles(WIN_10_11_FILENAMES.values().stream().toList(), STORAGE_DIR, processSupplier);
                    return;
                }
            }
            LoggerUtils.warn(String.format("[ChatTools] Addon toast is not available on %s", OS));
        };
        Thread downloadThread = new Thread(runnable, "ChatTools-Download-Thread");
        downloadThread.start();
    }

    public static void downloadAndCheckFiles(List<String> filesToDownload, Path downloadDirectory, QuadConsumer<String, Integer, Integer, Integer> processSupplier) {
        if (!downloadDirectory.toFile().exists()) {
            downloadDirectory.toFile().mkdirs();
        }
        for (String fileName : filesToDownload) {
            String url = DOWNLOAD_SITE + fileName;
            try {
                String md5Url = url + ".md5";
                String md5 = DownloadUtils.downloadMD5(md5Url);
                Path filePath = Path.of(downloadDirectory.toString(), fileName);
                if (filePath.toFile().exists() && DownloadUtils.checkMD5(filePath, md5)) {
                    LoggerUtils.info("[ChatTools] " + fileName + " md5 checker passed, skip downloading it.");
                    continue;
                }
                DownloadUtils.downloadFile(fileName, filePath, processSupplier);
                if (!DownloadUtils.checkMD5(filePath, md5)) continue;
                LoggerUtils.info("[ChatTools] " + fileName + " was downloaded successfully.");
            }
            catch (Exception e) {
                LoggerUtils.error("[ChatTools] Error occurred while downloading \"" + url + "\".");
                e.printStackTrace();
            }
        }
        LoggerUtils.info("[ChatTools] Addons are fully downloaded and ready.");
    }

    private static void downloadFile(String fileName, Path targetPath, QuadConsumer<String, Integer, Integer, Integer> processSupplier) throws IOException {
        URL url = new URL(DOWNLOAD_SITE + fileName);
        URLConnection connection = url.openConnection();
        int fileSize = connection.getContentLength();
        try (InputStream in = connection.getInputStream();
             FileOutputStream fos = new FileOutputStream(targetPath.toFile());){
            int bytesRead;
            byte[] buffer = new byte[4096];
            long totalBytesRead = 0L;
            int prevPercentage = 0;
            while ((bytesRead = in.read(buffer)) != -1) {
                fos.write(buffer, 0, bytesRead);
                int percentage = (int)((totalBytesRead += (long)bytesRead) * 100L / (long)fileSize);
                if (percentage != prevPercentage) {
                    System.out.print("\rDownloading " + fileName + ": " + percentage + "%");
                    prevPercentage = percentage;
                }
                if (processSupplier == null) continue;
                processSupplier.accept(fileName, percentage, (int)totalBytesRead / 1024, fileSize / 1024);
            }
            System.out.println("\rDownloading " + fileName + ": Completed");
        }
    }

    private static String downloadMD5(String md5Url) throws IOException {
        URL url = new URL(md5Url);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            String string = reader.readLine();
            return string;
        }
    }

    private static boolean checkMD5(Path filePath, String md5) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        try (InputStream is = Files.newInputStream(filePath, new OpenOption[0]);){
            DigestInputStream dis = new DigestInputStream(is, md);
            byte[] buffer = new byte[4096];
            while (dis.read(buffer) != -1) {
            }
        }
        byte[] digest = md.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : digest) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString().equalsIgnoreCase(md5);
    }
}

