/*
 * Decompiled with CFR 0.152.
 */
package net.apple70cents.chattools.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.apple70cents.chattools.utils.ConfigScreenUtils;
import net.apple70cents.chattools.utils.ConfigUtils;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class TextUtils {
    public static final class_2583 WEBSITE_URL_STYLE = class_2583.field_24360.method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11749, "https://70centsapple.top/blogs/#/chat-tools-faq")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)ConfigScreenUtils.getTooltip("general.FAQ", "FAQ", null)));
    public static final String PREFIX = "key.chattools.";
    public static final class_2561 SPACER = TextUtils.literal("").method_27661().method_10862(class_2583.field_24360);
    public static Map<String, MessageUnit> messageMap = new LinkedHashMap<String, MessageUnit>();
    public static MessageUnit latestMessage = null;

    public static String generateRandomString(int length) {
        String CHARACTERS = "0123456789abcdefghijklmnopqrstuvwxyz";
        Random RANDOM = new Random();
        StringBuilder stringBuilder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int index = RANDOM.nextInt("0123456789abcdefghijklmnopqrstuvwxyz".length());
            stringBuilder.append("0123456789abcdefghijklmnopqrstuvwxyz".charAt(index));
        }
        return stringBuilder.toString();
    }

    public static MessageUnit getLatestMessage() {
        return latestMessage;
    }

    protected static void setLatestMessage(MessageUnit unit) {
        latestMessage = unit;
    }

    public static String putMessageMap(class_2561 text, long unixTimestamp, int occurrenceCount) {
        int maxSize = ((Number)ConfigUtils.get("general.MaxHistoryLength")).intValue();
        while (messageMap.size() > maxSize) {
            messageMap.remove(messageMap.keySet().iterator().next());
        }
        String hashcode = TextUtils.generateRandomString(6);
        for (int retries = 0; messageMap.containsKey(hashcode) && retries < 10; ++retries) {
            hashcode = TextUtils.generateRandomString(6);
        }
        MessageUnit messageUnit = new MessageUnit(text, unixTimestamp, occurrenceCount);
        messageMap.put(hashcode, messageUnit);
        TextUtils.setLatestMessage(messageUnit);
        return hashcode;
    }

    public static MessageUnit getMessageMap(String hash) {
        try {
            return messageMap.get(hash);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class_2561 literal(String str) {
        return class_2561.method_43470((String)str);
    }

    public static class_2561 transWithPrefix(String str, String prefix) {
        return class_2561.method_43471((String)(prefix + str));
    }

    public static class_2561 transWithPrefix(String str, String prefix, Object ... args) {
        return class_2561.method_43469((String)(prefix + str), (Object[])args);
    }

    public static class_2561 trans(String str, Object ... args) {
        return TextUtils.transWithPrefix(str, PREFIX, args);
    }

    public static class_2561 trans(String str) {
        return TextUtils.transWithPrefix(str, PREFIX);
    }

    public static class_2561 of(String str) {
        return class_2561.method_30163((String)str);
    }

    public static class_2561 empty() {
        return class_2561.method_43473();
    }

    public static String wash(String str) {
        return Pattern.compile("\u00a7.").matcher(str).replaceAll("");
    }

    public static String encodeColorCodes(String str) {
        return str.replace('&', '\u00a7').replace("\\\u00a7", "&");
    }

    public static String decodeColorCodes(String str) {
        return str.replace('\u00a7', '&');
    }

    public static class_2561 textArray2text(List<class_2561> texts) {
        class_5250 result = (class_5250)TextUtils.literal("");
        for (int i = 0; i < texts.size(); ++i) {
            result.method_10852(texts.get(i));
            if (i == texts.size() - 1) continue;
            result.method_10852(TextUtils.literal("\n"));
        }
        return result;
    }

    public static class_5250 replaceComponentText(class_5250 text, Pattern oldStringPattern, String newString) {
        JsonElement jsonElement = class_2561.class_2562.method_10868((class_2561)text);
        TextUtils.replaceTextFieldValue(jsonElement, oldStringPattern, newString);
        return class_2561.class_2562.method_10872((JsonElement)jsonElement);
    }

    private static void replaceTextFieldValue(JsonElement jsonElement, Pattern oldValuePattern, String newValue) {
        block4: {
            block3: {
                if (!jsonElement.isJsonObject()) break block3;
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                for (Map.Entry ele : jsonObject.entrySet()) {
                    String key = (String)ele.getKey();
                    JsonElement value = (JsonElement)ele.getValue();
                    if (TextUtils.isProtectedField(key)) continue;
                    if (TextUtils.isTextField(key) && value.isJsonPrimitive()) {
                        Matcher matcher = oldValuePattern.matcher(value.getAsString());
                        if (!matcher.find()) continue;
                        jsonObject.addProperty(key, matcher.replaceAll(newValue));
                        continue;
                    }
                    TextUtils.replaceTextFieldValue(value, oldValuePattern, newValue);
                }
                break block4;
            }
            if (!jsonElement.isJsonArray()) break block4;
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            for (JsonElement element : jsonArray) {
                TextUtils.replaceTextFieldValue(element, oldValuePattern, newValue);
            }
        }
    }

    public static class_5250 replaceComponentColor(class_5250 text) {
        JsonElement jsonElement = class_2561.class_2562.method_10868((class_2561)text);
        TextUtils.replaceColorFieldValue(jsonElement);
        return class_2561.class_2562.method_10872((JsonElement)jsonElement);
    }

    private static void replaceColorFieldValue(JsonElement jsonElement) {
        block5: {
            block4: {
                if (!jsonElement.isJsonObject()) break block4;
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                for (Map.Entry ele : jsonObject.entrySet()) {
                    String key = (String)ele.getKey();
                    JsonElement value = (JsonElement)ele.getValue();
                    if (TextUtils.isProtectedField(key)) continue;
                    if (TextUtils.isTextField(key) && value.isJsonPrimitive()) {
                        jsonObject.addProperty(key, value.getAsString().replaceAll("\u00a7.", ""));
                        continue;
                    }
                    if (TextUtils.isColorField(key) && value.isJsonPrimitive()) {
                        jsonObject.addProperty(key, "white");
                        continue;
                    }
                    TextUtils.replaceColorFieldValue(value);
                }
                break block5;
            }
            if (!jsonElement.isJsonArray()) break block5;
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            for (JsonElement element : jsonArray) {
                TextUtils.replaceColorFieldValue(element);
            }
        }
    }

    private static boolean isProtectedField(String key) {
        return key.contains("enchantments") || key.contains("tag");
    }

    private static boolean isTextField(String key) {
        return key.contains("text") || key.contains("value");
    }

    private static boolean isColorField(String key) {
        return key.contains("color");
    }

    public static class MessageUnit {
        public class_2561 message;
        public long unixTimestamp;
        public int occurrenceCount;

        public MessageUnit(class_2561 message, long unixTimestamp, int occurrenceCount) {
            this.message = message;
            this.unixTimestamp = unixTimestamp;
            this.occurrenceCount = occurrenceCount;
        }
    }
}

