/*
 * Decompiled with CFR 0.152.
 */
package net.a5ho9999.CottageCraft.world.trees.colouredTree;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.a5ho9999.CottageCraft.world.trees.ModdedTrunkPlacerType;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;

public class ColouredTrunkPlacer
extends class_5141 {
    public static final MapCodec<ColouredTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> ColouredTrunkPlacer.method_28904((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, ColouredTrunkPlacer::new));

    public ColouredTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
    }

    protected class_5142<?> method_28903() {
        return ModdedTrunkPlacerType.LargeColouredTrunkPlacer;
    }

    public List<class_4647.class_5208> method_26991(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, int height, class_2338 startPos, class_4643 config) {
        int n = 12;
        int i = 5;
        int j = height + 2;
        int k = class_3532.method_15357((double)((double)j * 0.618));
        class_2338 trunkBlockPos = startPos.method_10074();
        ColouredTrunkPlacer.method_27400((class_3746)world, replacer, (class_5819)random, (class_2338)trunkBlockPos, (class_4643)config);
        ColouredTrunkPlacer.method_27400((class_3746)world, replacer, (class_5819)random, (class_2338)trunkBlockPos.method_10078(), (class_4643)config);
        ColouredTrunkPlacer.method_27400((class_3746)world, replacer, (class_5819)random, (class_2338)trunkBlockPos.method_10072(), (class_4643)config);
        ColouredTrunkPlacer.method_27400((class_3746)world, replacer, (class_5819)random, (class_2338)trunkBlockPos.method_10072().method_10078(), (class_4643)config);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int fk = 0; fk < height; ++fk) {
            this.setLog(world, replacer, random, mutable, config, startPos, 0, fk, 0);
            if (fk >= height - 1) continue;
            this.setLog(world, replacer, random, mutable, config, startPos, 1, fk, 0);
            this.setLog(world, replacer, random, mutable, config, startPos, 1, fk, 1);
            this.setLog(world, replacer, random, mutable, config, startPos, 0, fk, 1);
        }
        double d = 1.0;
        int l = Math.min(1, class_3532.method_15357((double)(1.382 + Math.pow(1.0 * (double)j / 13.0, 2.0))));
        int m = startPos.method_10264() + k;
        ArrayList list = Lists.newArrayList();
        list.add(new BranchPosition(startPos.method_10086(n), m));
        for (n = j - 5; n >= 0; --n) {
            float f = ColouredTrunkPlacer.shouldGenerateBranch(j, n);
            if (f < 0.0f) continue;
            for (int o = 0; o < l; ++o) {
                class_2338 blockPos2;
                double e = 1.0;
                double g = 1.0 * (double)f * ((double)random.method_43057() + 0.328);
                double h = (double)(random.method_43057() * 2.0f) * Math.PI;
                double p = g * Math.sin(h) + 0.5;
                double q = g * Math.cos(h) + 0.5;
                class_2338 blockPos = startPos.method_10069(class_3532.method_15357((double)p), n - 1, class_3532.method_15357((double)q));
                if (!this.makeOrCheckBranch(world, replacer, random, blockPos, blockPos2 = blockPos.method_10086(5), false, config)) continue;
                int r = startPos.method_10263() - blockPos.method_10263();
                int s = startPos.method_10260() - blockPos.method_10260();
                double t = (double)blockPos.method_10264() - Math.sqrt(r * r + s * s) * 0.381;
                int u = t > (double)m ? m : (int)t;
                class_2338 blockPos3 = new class_2338(startPos.method_10263(), u, startPos.method_10260());
                if (!this.makeOrCheckBranch(world, replacer, random, blockPos3, blockPos, false, config)) continue;
                list.add(new BranchPosition(blockPos, blockPos3.method_10264()));
            }
        }
        this.makeOrCheckBranch(world, replacer, random, startPos, startPos.method_10086(k), true, config);
        this.makeBranches(world, replacer, random, j, startPos, list, config);
        ArrayList list2 = Lists.newArrayList();
        for (BranchPosition branchPosition : list) {
            if (!this.isHighEnough(j, branchPosition.getEndY() - startPos.method_10264())) continue;
            list2.add(branchPosition.node);
        }
        return list2;
    }

    private boolean makeOrCheckBranch(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338 startPos, class_2338 branchPos, boolean make, class_4643 config) {
        if (!make && Objects.equals(startPos, branchPos)) {
            return true;
        }
        class_2338 blockPos = branchPos.method_10069(-startPos.method_10263(), -startPos.method_10264(), -startPos.method_10260());
        int i = this.getLongestSide(blockPos);
        float f = (float)blockPos.method_10263() / (float)i;
        float g = (float)blockPos.method_10264() / (float)i;
        float h = (float)blockPos.method_10260() / (float)i;
        for (int j = 0; j <= i; ++j) {
            class_2338 blockPos2 = startPos.method_10069(class_3532.method_15375((float)(0.5f + (float)j * f)), class_3532.method_15375((float)(0.5f + (float)j * g)), class_3532.method_15375((float)(0.5f + (float)j * h)));
            if (make) {
                this.method_27402(world, replacer, random, blockPos2, config, state -> (class_2680)state.method_47968((class_2769)class_2465.field_11459, (Comparable)this.getLogAxis(startPos, blockPos2)));
                continue;
            }
            if (this.method_43198(world, blockPos2)) continue;
            return false;
        }
        return true;
    }

    private void setLog(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338.class_2339 tmpPos, class_4643 config, class_2338 startPos, int dx, int dy, int dz) {
        tmpPos.method_25504((class_2382)startPos, dx, dy, dz);
        this.method_27401(world, replacer, random, tmpPos, config);
    }

    private int getLongestSide(class_2338 offset) {
        int i = class_3532.method_15382((int)offset.method_10263());
        int j = class_3532.method_15382((int)offset.method_10264());
        int k = class_3532.method_15382((int)offset.method_10260());
        return Math.max(i, Math.max(j, k));
    }

    private class_2350.class_2351 getLogAxis(class_2338 branchStart, class_2338 branchEnd) {
        int j;
        class_2350.class_2351 axis = class_2350.class_2351.field_11052;
        int i = Math.abs(branchEnd.method_10263() - branchStart.method_10263());
        int k = Math.max(i, j = Math.abs(branchEnd.method_10260() - branchStart.method_10260()));
        if (k > 0) {
            axis = i == k ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051;
        }
        return axis;
    }

    private boolean isHighEnough(int treeHeight, int height) {
        return (double)height >= (double)treeHeight * 0.2;
    }

    private void makeBranches(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, int treeHeight, class_2338 startPos, List<BranchPosition> branchPositions, class_4643 config) {
        for (BranchPosition branchPosition : branchPositions) {
            int i = branchPosition.getEndY();
            class_2338 blockPos = new class_2338(startPos.method_10263(), i, startPos.method_10260());
            if (blockPos.equals((Object)branchPosition.node.method_27388()) || !this.isHighEnough(treeHeight, i - startPos.method_10264())) continue;
            this.makeOrCheckBranch(world, replacer, random, blockPos, branchPosition.node.method_27388(), true, config);
        }
    }

    private static float shouldGenerateBranch(int treeHeight, int height) {
        if ((float)height < (float)treeHeight * 0.3f) {
            return -1.0f;
        }
        float f = (float)treeHeight / 2.0f;
        float g = f - (float)height;
        float h = class_3532.method_15355((float)(f * f - g * g));
        if (g == 0.0f) {
            h = f;
        } else if (Math.abs(g) >= f) {
            return 0.0f;
        }
        return h * 0.5f;
    }

    static class BranchPosition {
        final class_4647.class_5208 node;
        private final int endY;

        public BranchPosition(class_2338 pos, int width) {
            this.node = new class_4647.class_5208(pos, 0, false);
            this.endY = width;
        }

        public int getEndY() {
            return this.endY;
        }
    }
}

