/*
 * Decompiled with CFR 0.152.
 */
package me.mklv.handshaker.paper;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import me.mklv.handshaker.paper.HandShakerPlugin;
import org.bukkit.configuration.file.YamlConfiguration;

public class BlacklistConfig {
    private final HandShakerPlugin plugin;
    private File file;
    private YamlConfiguration config;
    private KickMode kickMode = KickMode.FABRIC;
    private final Set<String> blacklistedMods = new LinkedHashSet<String>();
    private String kickMessage = "Remove: {mod}";

    public BlacklistConfig(HandShakerPlugin plugin) {
        this.plugin = plugin;
    }

    public void load() {
        if (this.file == null) {
            this.file = new File(this.plugin.getDataFolder(), "config.yml");
        }
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            this.plugin.saveResource("config.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.blacklistedMods.clear();
        String mode = this.config.getString("Kick Mode", this.config.getString("KickMode", "Fabric")).toUpperCase(Locale.ROOT);
        this.kickMode = mode.startsWith("ALL") ? KickMode.ALL : KickMode.FABRIC;
        this.kickMessage = this.config.getString("Kick Message", "Remove: {mod}");
        if (this.config.isList("Blacklisted Mods")) {
            for (Object o : this.config.getList("Blacklisted Mods")) {
                if (o == null) continue;
                this.blacklistedMods.add(o.toString().toLowerCase(Locale.ROOT));
            }
        }
    }

    public KickMode getKickMode() {
        return this.kickMode;
    }

    public Set<String> getBlacklistedMods() {
        return Collections.unmodifiableSet(this.blacklistedMods);
    }

    public String getKickMessage() {
        return this.kickMessage;
    }

    public boolean addMod(String modId) {
        boolean added = this.blacklistedMods.add(modId.toLowerCase(Locale.ROOT));
        this.save();
        return added;
    }

    public boolean removeMod(String modId) {
        boolean removed = this.blacklistedMods.remove(modId.toLowerCase(Locale.ROOT));
        this.save();
        return removed;
    }

    public void save() {
        this.config.set("Kick Mode", (Object)(this.kickMode == KickMode.ALL ? "All" : "Fabric"));
        this.config.set("Kick Message", (Object)this.kickMessage);
        this.config.set("Blacklisted Mods", new ArrayList<String>(this.blacklistedMods));
        try {
            this.config.save(this.file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static enum KickMode {
        ALL,
        FABRIC;

    }
}

