/*
 * Decompiled with CFR 0.152.
 */
package me.mklv.handshaker.paper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import me.mklv.handshaker.paper.HandShakerPlugin;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;

public class HandShakerCommand
implements TabExecutor {
    private final HandShakerPlugin plugin;

    public HandShakerCommand(HandShakerPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage("/handshaker reload | add <mod> | remove <mod>");
            return true;
        }
        switch (args[0].toLowerCase(Locale.ROOT)) {
            case "reload": {
                this.plugin.getBlacklistConfig().load();
                sender.sendMessage("HandShaker blacklist reloaded.");
                return true;
            }
            case "remove": {
                if (args.length < 2) {
                    sender.sendMessage("Usage: /handshaker remove <mod>");
                    return true;
                }
                boolean removed = this.plugin.getBlacklistConfig().removeMod(args[1]);
                sender.sendMessage(removed ? "Removed " + args[1] : args[1] + " not found in blacklist.");
                return true;
            }
            case "add": {
                if (args.length < 2) {
                    sender.sendMessage("Usage: /handshaker add <mod>");
                    return true;
                }
                boolean added = this.plugin.getBlacklistConfig().addMod(args[1]);
                sender.sendMessage(added ? "Added " + args[1] : args[1] + " already in blacklist.");
                return true;
            }
        }
        sender.sendMessage("Unknown subcommand.");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        Player p;
        Set<String> clientMods;
        if (args.length == 1) {
            return Arrays.asList("reload", "add", "remove");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("remove")) {
            return new ArrayList<String>(this.plugin.getBlacklistConfig().getBlacklistedMods());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("add") && sender instanceof Player && (clientMods = this.plugin.getClientMods((p = (Player)sender).getUniqueId())) != null) {
            ArrayList<String> suggestions = new ArrayList<String>(clientMods);
            suggestions.removeAll(this.plugin.getBlacklistConfig().getBlacklistedMods());
            return suggestions;
        }
        return Collections.emptyList();
    }
}

