/*
 * Decompiled with CFR 0.152.
 */
package me.mklv.handshaker.paper;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import me.mklv.handshaker.paper.HandShakerPlugin;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class BlacklistConfig {
    private final HandShakerPlugin plugin;
    private File file;
    private YamlConfiguration config;
    private Mode mode = Mode.BLACKLIST;
    private Behavior behavior = Behavior.STRICT;
    private IntegrityMode integrityMode = IntegrityMode.SIGNED;
    private final Set<String> blacklistedMods = new LinkedHashSet<String>();
    private final Set<String> whitelistedMods = new LinkedHashSet<String>();
    private String kickMessage = "You are using a blacklisted mod: {mod}. Please remove it to join this server.";
    private String noHandshakeKickMessage = "To connect to this server please download 'Hand-shaker' mod.";
    private String missingWhitelistModMessage = "You are missing required mods: {mod}. Please install them to join this server.";
    private String extraWhitelistModMessage = "You have mods that are not on the whitelist: {mod}. Please remove them to join.";
    private String invalidSignatureKickMessage = "Invalid client signature. Please use the official client.";
    private boolean isV2Config = false;
    private final Map<String, ModStatus> modStatusMap = new LinkedHashMap<String, ModStatus>();
    private DefaultMode defaultMode = DefaultMode.ALLOWED;

    public BlacklistConfig(HandShakerPlugin plugin) {
        this.plugin = plugin;
    }

    public void load() {
        block16: {
            block15: {
                String oldMode;
                if (this.file == null) {
                    this.file = new File(this.plugin.getDataFolder(), "config.yml");
                }
                if (!this.file.exists()) {
                    this.file.getParentFile().mkdirs();
                    this.plugin.saveResource("config.yml", false);
                }
                this.config = YamlConfiguration.loadConfiguration((File)this.file);
                this.blacklistedMods.clear();
                this.whitelistedMods.clear();
                this.modStatusMap.clear();
                String configVersion = this.config.getString("config", "v1");
                this.isV2Config = configVersion.equalsIgnoreCase("v2");
                String integrityString = this.config.getString("Integrity", "signed").toUpperCase(Locale.ROOT);
                this.integrityMode = integrityString.equals("SIGNED") ? IntegrityMode.SIGNED : IntegrityMode.DEV;
                String behaviorString = this.config.getString("Behavior", "strict").toUpperCase(Locale.ROOT);
                this.behavior = behaviorString.isEmpty() ? ((oldMode = this.config.getString("Kick Mode", this.config.getString("KickMode", "Fabric")).toUpperCase(Locale.ROOT)).startsWith("ALL") ? Behavior.STRICT : Behavior.VANILLA) : (behaviorString.startsWith("STRICT") ? Behavior.STRICT : Behavior.VANILLA);
                this.kickMessage = this.config.getString("Kick Message", "You are using a blacklisted mod: {mod}. Please remove it to join this server.");
                this.noHandshakeKickMessage = this.config.getString("Missing mod message", "To connect to this server please download 'Hand-shaker' mod.");
                this.missingWhitelistModMessage = this.config.getString("Missing whitelist mod message", this.config.getString("Missing required mod message", "You are missing required mods: {mod}. Please install them to join this server."));
                this.extraWhitelistModMessage = this.config.getString("Extra whitelist mod message", "You have mods that are not on the whitelist: {mod}. Please remove them to join.");
                this.invalidSignatureKickMessage = this.config.getString("Invalid signature kick message", "Invalid client signature. Please use the official client.");
                if (!this.isV2Config) break block15;
                String defaultModeString = this.config.getString("Default Mode", "allowed").toUpperCase(Locale.ROOT);
                this.defaultMode = defaultModeString.equals("BLACKLISTED") ? DefaultMode.BLACKLISTED : DefaultMode.ALLOWED;
                ConfigurationSection modsSection = this.config.getConfigurationSection("Mods");
                if (modsSection == null) break block16;
                for (String modId : modsSection.getKeys(false)) {
                    String statusString;
                    this.modStatusMap.put(modId.toLowerCase(Locale.ROOT), switch (statusString = modsSection.getString(modId, "allowed").toUpperCase(Locale.ROOT)) {
                        case "REQUIRED" -> ModStatus.REQUIRED;
                        case "BLACKLISTED" -> ModStatus.BLACKLISTED;
                        default -> ModStatus.ALLOWED;
                    });
                }
                break block16;
            }
            String modeString = this.config.getString("Operation Mode", "blacklist").toUpperCase(Locale.ROOT);
            this.mode = modeString.equals("WHITELIST") ? Mode.WHITELIST : (modeString.equals("REQUIRE") ? Mode.REQUIRE : Mode.BLACKLIST);
            if (this.config.isList("Blacklisted Mods")) {
                for (Object o : this.config.getList("Blacklisted Mods")) {
                    if (o == null) continue;
                    this.blacklistedMods.add(o.toString().toLowerCase(Locale.ROOT));
                }
            }
            if (this.config.isList("Whitelisted Mods")) {
                for (Object o : this.config.getList("Whitelisted Mods")) {
                    if (o == null) continue;
                    this.whitelistedMods.add(o.toString().toLowerCase(Locale.ROOT));
                }
            }
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.save();
    }

    public Behavior getBehavior() {
        return this.behavior;
    }

    public IntegrityMode getIntegrityMode() {
        return this.integrityMode;
    }

    public Set<String> getBlacklistedMods() {
        return Collections.unmodifiableSet(this.blacklistedMods);
    }

    public Set<String> getWhitelistedMods() {
        return Collections.unmodifiableSet(this.whitelistedMods);
    }

    public String getKickMessage() {
        return this.kickMessage;
    }

    public String getNoHandshakeKickMessage() {
        return this.noHandshakeKickMessage;
    }

    public String getMissingWhitelistModMessage() {
        return this.missingWhitelistModMessage;
    }

    public String getExtraWhitelistModMessage() {
        return this.extraWhitelistModMessage;
    }

    public String getInvalidSignatureKickMessage() {
        return this.invalidSignatureKickMessage;
    }

    public boolean isV2Config() {
        return this.isV2Config;
    }

    public Map<String, ModStatus> getModStatusMap() {
        return Collections.unmodifiableMap(this.modStatusMap);
    }

    public DefaultMode getDefaultMode() {
        return this.defaultMode;
    }

    public boolean setModStatus(String modId, ModStatus status) {
        if (!this.isV2Config) {
            return false;
        }
        ModStatus oldStatus = this.modStatusMap.get(modId = modId.toLowerCase(Locale.ROOT));
        if (oldStatus == status) {
            return false;
        }
        this.modStatusMap.put(modId, status);
        this.save();
        return true;
    }

    public boolean removeModStatus(String modId) {
        boolean removed;
        if (!this.isV2Config) {
            return false;
        }
        boolean bl = removed = this.modStatusMap.remove(modId = modId.toLowerCase(Locale.ROOT)) != null;
        if (removed) {
            this.save();
        }
        return removed;
    }

    public ModStatus getModStatus(String modId) {
        if (!this.isV2Config) {
            return null;
        }
        ModStatus status = this.modStatusMap.get(modId = modId.toLowerCase(Locale.ROOT));
        if (status != null) {
            return status;
        }
        return this.defaultMode == DefaultMode.ALLOWED ? ModStatus.ALLOWED : ModStatus.BLACKLISTED;
    }

    public void addAllMods(Set<String> mods, ModStatus status) {
        if (!this.isV2Config) {
            return;
        }
        for (String mod : mods) {
            this.modStatusMap.put(mod.toLowerCase(Locale.ROOT), status);
        }
        this.save();
    }

    public boolean addMod(String modId) {
        if (this.isV2Config) {
            return this.setModStatus(modId, ModStatus.BLACKLISTED);
        }
        boolean added = this.blacklistedMods.add(modId.toLowerCase(Locale.ROOT));
        if (added) {
            this.save();
        }
        return added;
    }

    public boolean removeMod(String modId) {
        if (this.isV2Config) {
            return this.removeModStatus(modId);
        }
        boolean removed = this.blacklistedMods.remove(modId.toLowerCase(Locale.ROOT));
        if (removed) {
            this.save();
        }
        return removed;
    }

    public void setWhitelistedMods(Set<String> mods) {
        if (this.isV2Config) {
            this.addAllMods(mods, ModStatus.REQUIRED);
            return;
        }
        this.whitelistedMods.clear();
        for (String mod : mods) {
            this.whitelistedMods.add(mod.toLowerCase(Locale.ROOT));
        }
        this.save();
    }

    public void save() {
        if (this.isV2Config) {
            this.config.set("config", (Object)"v2");
            this.config.set("Kick Message", (Object)this.kickMessage);
            this.config.set("Missing required mod message", (Object)this.missingWhitelistModMessage);
            this.config.set("Missing mod message", (Object)this.noHandshakeKickMessage);
            this.config.set("Invalid signature kick message", (Object)this.invalidSignatureKickMessage);
            this.config.set("Behavior", (Object)(this.behavior == Behavior.STRICT ? "Strict" : "Vanilla"));
            this.config.set("Integrity", (Object)(this.integrityMode == IntegrityMode.SIGNED ? "Signed" : "Dev"));
            this.config.set("Default Mode", (Object)(this.defaultMode == DefaultMode.ALLOWED ? "allowed" : "blacklisted"));
            this.config.set("Mods", null);
            for (Map.Entry<String, ModStatus> entry : this.modStatusMap.entrySet()) {
                String statusString = switch (entry.getValue().ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> "required";
                    case 2 -> "blacklisted";
                    case 1 -> "allowed";
                };
                this.config.set("Mods." + entry.getKey(), (Object)statusString);
            }
        } else {
            this.config.set("Integrity", (Object)(this.integrityMode == IntegrityMode.SIGNED ? "Signed" : "Dev"));
            this.config.set("Operation Mode", (Object)(this.mode == Mode.WHITELIST ? "whitelist" : (this.mode == Mode.REQUIRE ? "require" : "blacklist")));
            this.config.set("Behavior", (Object)(this.behavior == Behavior.STRICT ? "Strict" : "Vanilla"));
            this.config.set("Kick Message", (Object)this.kickMessage);
            this.config.set("Missing mod message", (Object)this.noHandshakeKickMessage);
            this.config.set("Missing whitelist mod message", (Object)this.missingWhitelistModMessage);
            this.config.set("Extra whitelist mod message", (Object)this.extraWhitelistModMessage);
            this.config.set("Invalid signature kick message", (Object)this.invalidSignatureKickMessage);
            this.config.set("Blacklisted Mods", new ArrayList<String>(this.blacklistedMods));
            this.config.set("Whitelisted Mods", new ArrayList<String>(this.whitelistedMods));
        }
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save config.yml!");
        }
    }

    public static enum Mode {
        BLACKLIST,
        WHITELIST,
        REQUIRE;

    }

    public static enum Behavior {
        STRICT,
        VANILLA;

    }

    public static enum IntegrityMode {
        SIGNED,
        DEV;

    }

    public static enum DefaultMode {
        ALLOWED,
        BLACKLISTED;

    }

    public static enum ModStatus {
        REQUIRED,
        ALLOWED,
        BLACKLISTED;

    }
}

