/*
 * Decompiled with CFR 0.152.
 */
package me.mklv.handshaker.paper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.mklv.handshaker.paper.BlacklistConfig;
import me.mklv.handshaker.paper.HandShakerPlugin;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class HandShakerCommand
implements TabExecutor {
    private final HandShakerPlugin plugin;

    public HandShakerCommand(HandShakerPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.sendUsage(sender);
            return true;
        }
        BlacklistConfig config = this.plugin.getBlacklistConfig();
        boolean isV2 = config.isV2Config();
        block10 : switch (args[0].toLowerCase(Locale.ROOT)) {
            case "reload": {
                config.load();
                sender.sendMessage("HandShaker config reloaded. Re-checking all online players.");
                this.plugin.checkAllPlayers();
                break;
            }
            case "mode": {
                if (isV2) {
                    sender.sendMessage("\u00a7cThe 'mode' command is not available in v2 config. Use per-mod configuration instead.");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage("Usage: /handshaker mode <blacklist|whitelist|require>");
                    return true;
                }
                switch (args[1].toLowerCase(Locale.ROOT)) {
                    case "blacklist": {
                        config.setMode(BlacklistConfig.Mode.BLACKLIST);
                        sender.sendMessage("HandShaker mode set to blacklist.");
                        this.plugin.checkAllPlayers();
                        break block10;
                    }
                    case "whitelist": {
                        config.setMode(BlacklistConfig.Mode.WHITELIST);
                        sender.sendMessage("HandShaker mode set to whitelist.");
                        this.plugin.checkAllPlayers();
                        break block10;
                    }
                    case "require": {
                        config.setMode(BlacklistConfig.Mode.REQUIRE);
                        sender.sendMessage("HandShaker mode set to require.");
                        this.plugin.checkAllPlayers();
                        break block10;
                    }
                }
                sender.sendMessage("Unknown mode. Use blacklist, whitelist, or require.");
                break;
            }
            case "add": {
                if (args.length < 2) {
                    sender.sendMessage("Usage: /handshaker add <mod|*> [allowed|required|blacklisted]");
                    return true;
                }
                String modId = args[1];
                if (isV2) {
                    BlacklistConfig.ModStatus status;
                    if (modId.equals("*")) {
                        BlacklistConfig.ModStatus status2;
                        if (args.length < 3) {
                            sender.sendMessage("\u00a7cUsage: /handshaker add * <allowed|required|blacklisted>");
                            return true;
                        }
                        if (!(sender instanceof Player)) {
                            sender.sendMessage("\u00a7cThis command can only be used by players.");
                            return true;
                        }
                        switch (args[2].toLowerCase(Locale.ROOT)) {
                            case "required": {
                                status2 = BlacklistConfig.ModStatus.REQUIRED;
                                break;
                            }
                            case "allowed": {
                                status2 = BlacklistConfig.ModStatus.ALLOWED;
                                break;
                            }
                            case "blacklisted": {
                                status2 = BlacklistConfig.ModStatus.BLACKLISTED;
                                break;
                            }
                            default: {
                                sender.sendMessage("\u00a7cInvalid status. Use: allowed, required, or blacklisted");
                                return true;
                            }
                        }
                        Player senderPlayer = (Player)sender;
                        Set<String> mods = this.plugin.getClientMods(senderPlayer.getUniqueId());
                        if (mods == null || mods.isEmpty()) {
                            sender.sendMessage("\u00a7cNo mod list found for you. Make sure you're using a modded client.");
                            return true;
                        }
                        config.addAllMods(mods, status2);
                        sender.sendMessage("\u00a7aAdded " + mods.size() + " of your mods as " + args[2].toLowerCase());
                        this.plugin.checkAllPlayers();
                        break;
                    }
                    if (args.length < 3) {
                        sender.sendMessage("\u00a7cUsage: /handshaker add <mod> <allowed|required|blacklisted>");
                        return true;
                    }
                    switch (args[2].toLowerCase(Locale.ROOT)) {
                        case "required": {
                            status = BlacklistConfig.ModStatus.REQUIRED;
                            break;
                        }
                        case "allowed": {
                            status = BlacklistConfig.ModStatus.ALLOWED;
                            break;
                        }
                        case "blacklisted": {
                            status = BlacklistConfig.ModStatus.BLACKLISTED;
                            break;
                        }
                        default: {
                            sender.sendMessage("\u00a7cInvalid status. Use: allowed, required, or blacklisted");
                            return true;
                        }
                    }
                    config.setModStatus(modId, status);
                    sender.sendMessage("\u00a7aSet " + modId + " to " + args[2].toLowerCase());
                    this.plugin.checkAllPlayers();
                    break;
                }
                boolean added = config.addMod(modId);
                sender.sendMessage(added ? "Added " + modId : modId + " already in blacklist.");
                if (!added) break;
                this.plugin.checkAllPlayers();
                break;
            }
            case "change": {
                BlacklistConfig.ModStatus status;
                if (!isV2) {
                    sender.sendMessage("\u00a7cThe 'change' command is only available in v2 config.");
                    return true;
                }
                if (args.length < 3) {
                    sender.sendMessage("\u00a7cUsage: /handshaker change <mod> <allowed|required|blacklisted>");
                    return true;
                }
                String modId = args[1];
                switch (args[2].toLowerCase(Locale.ROOT)) {
                    case "required": {
                        status = BlacklistConfig.ModStatus.REQUIRED;
                        break;
                    }
                    case "allowed": {
                        status = BlacklistConfig.ModStatus.ALLOWED;
                        break;
                    }
                    case "blacklisted": {
                        status = BlacklistConfig.ModStatus.BLACKLISTED;
                        break;
                    }
                    default: {
                        sender.sendMessage("\u00a7cInvalid status. Use: allowed, required, or blacklisted");
                        return true;
                    }
                }
                config.setModStatus(modId, status);
                sender.sendMessage("\u00a7aChanged " + modId + " to " + args[2].toLowerCase());
                this.plugin.checkAllPlayers();
                break;
            }
            case "remove": {
                if (args.length < 2) {
                    sender.sendMessage("Usage: /handshaker remove <mod>");
                    return true;
                }
                boolean removed = config.removeMod(args[1]);
                sender.sendMessage(removed ? "Removed " + args[1] : args[1] + " not found.");
                break;
            }
            case "list": {
                if (!isV2) {
                    sender.sendMessage("\u00a7cThe 'list' command is only available in v2 config.");
                    return true;
                }
                Map<String, BlacklistConfig.ModStatus> mods = config.getModStatusMap();
                if (mods.isEmpty()) {
                    sender.sendMessage("\u00a7eNo mods configured. Default mode: " + String.valueOf((Object)config.getDefaultMode()));
                    return true;
                }
                sender.sendMessage("\u00a76=== Configured Mods (Default: " + String.valueOf((Object)config.getDefaultMode()) + ") ===");
                if (!(sender instanceof Player)) {
                    for (Map.Entry<String, BlacklistConfig.ModStatus> entry : mods.entrySet()) {
                        String statusColor = switch (entry.getValue()) {
                            default -> throw new MatchException(null, null);
                            case BlacklistConfig.ModStatus.REQUIRED -> "\u00a7a";
                            case BlacklistConfig.ModStatus.ALLOWED -> "\u00a7e";
                            case BlacklistConfig.ModStatus.BLACKLISTED -> "\u00a7c";
                        };
                        sender.sendMessage(statusColor + entry.getKey() + " \u00a77- \u00a7f" + String.valueOf((Object)entry.getValue()));
                    }
                } else {
                    Player player = (Player)sender;
                    for (Map.Entry<String, BlacklistConfig.ModStatus> entry : mods.entrySet()) {
                        NamedTextColor statusColor = switch (entry.getValue()) {
                            default -> throw new MatchException(null, null);
                            case BlacklistConfig.ModStatus.REQUIRED -> NamedTextColor.GREEN;
                            case BlacklistConfig.ModStatus.ALLOWED -> NamedTextColor.YELLOW;
                            case BlacklistConfig.ModStatus.BLACKLISTED -> NamedTextColor.RED;
                        };
                        Component modComponent = ((TextComponent)((TextComponent)Component.text((String)entry.getKey()).color((TextColor)statusColor)).append(Component.text((String)(" - " + String.valueOf((Object)entry.getValue()))).color((TextColor)NamedTextColor.WHITE))).append(((TextComponent)((TextComponent)Component.text((String)" [Remove]").color((TextColor)NamedTextColor.GRAY)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to remove")))).clickEvent(ClickEvent.runCommand((String)("/handshaker remove " + entry.getKey()))));
                        player.sendMessage(modComponent);
                    }
                }
                break;
            }
            case "player": {
                if (args.length < 2) {
                    sender.sendMessage("Usage: /handshaker player <player>");
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target == null) {
                    sender.sendMessage("Player '" + args[1] + "' not found.");
                    return true;
                }
                Set<String> mods = this.plugin.getClientMods(target.getUniqueId());
                if (mods == null || mods.isEmpty()) {
                    sender.sendMessage("No mod list found for " + target.getName() + ".");
                    return true;
                }
                if (!(sender instanceof Player)) {
                    sender.sendMessage(target.getName() + "'s mods: " + String.join((CharSequence)", ", mods));
                    return true;
                }
                Player player = (Player)sender;
                if (isV2) {
                    player.sendMessage(((TextComponent)Component.text((String)("=== " + target.getName() + "'s Mods ===")).color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD));
                    for (String mod : mods) {
                        BlacklistConfig.ModStatus currentStatus = config.getModStatus(mod);
                        String statusStr = currentStatus.toString().toLowerCase();
                        NamedTextColor statusColor = switch (currentStatus) {
                            default -> throw new MatchException(null, null);
                            case BlacklistConfig.ModStatus.REQUIRED -> NamedTextColor.GREEN;
                            case BlacklistConfig.ModStatus.ALLOWED -> NamedTextColor.YELLOW;
                            case BlacklistConfig.ModStatus.BLACKLISTED -> NamedTextColor.RED;
                        };
                        Component modName = Component.text((String)("  " + mod)).color((TextColor)NamedTextColor.WHITE);
                        Component currentStatusComp = Component.text((String)(" [" + statusStr + "] ")).color((TextColor)statusColor);
                        Component allowedBtn = ((TextComponent)((TextComponent)Component.text((String)"[A]").color((TextColor)NamedTextColor.YELLOW)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Set as ALLOWED")))).clickEvent(ClickEvent.runCommand((String)("/handshaker change " + mod + " allowed")));
                        Component requiredBtn = ((TextComponent)((TextComponent)Component.text((String)"[R]").color((TextColor)NamedTextColor.GREEN)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Set as REQUIRED")))).clickEvent(ClickEvent.runCommand((String)("/handshaker change " + mod + " required")));
                        Component blacklistedBtn = ((TextComponent)((TextComponent)Component.text((String)"[B]").color((TextColor)NamedTextColor.RED)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Set as BLACKLISTED")))).clickEvent(ClickEvent.runCommand((String)("/handshaker change " + mod + " blacklisted")));
                        player.sendMessage(modName.append(currentStatusComp).append(allowedBtn).append((Component)Component.text((String)" ")).append(requiredBtn).append((Component)Component.text((String)" ")).append(blacklistedBtn));
                    }
                } else {
                    player.sendMessage(Component.text((String)("=== " + target.getName() + "'s Mods ===")).color((TextColor)NamedTextColor.GOLD));
                    for (String mod : mods) {
                        boolean isBlacklisted = config.getBlacklistedMods().contains(mod);
                        Component modComponent = isBlacklisted ? Component.text((String)("  \u2022 " + mod + " [BLACKLISTED]")).color((TextColor)NamedTextColor.RED) : ((TextComponent)Component.text((String)("  \u2022 " + mod)).color((TextColor)NamedTextColor.WHITE)).append(((TextComponent)((TextComponent)Component.text((String)" [Add to Blacklist]").color((TextColor)NamedTextColor.GRAY)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to blacklist")))).clickEvent(ClickEvent.runCommand((String)("/handshaker add " + mod))));
                        player.sendMessage(modComponent);
                    }
                }
                break;
            }
            case "whitelist_update": {
                if (isV2) {
                    sender.sendMessage("\u00a7cThis command is deprecated in v2 config. Use: /handshaker add * required <player>");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage("Usage: /handshaker whitelist_update <player>");
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target == null) {
                    sender.sendMessage("Player not found.");
                    return true;
                }
                Set<String> mods = this.plugin.getClientMods(target.getUniqueId());
                if (mods == null) {
                    sender.sendMessage("Mod list for " + target.getName() + " not found. Make sure they are online and using Fabric.");
                    return true;
                }
                config.setWhitelistedMods(mods);
                sender.sendMessage("Whitelist updated with " + target.getName() + "'s mods. " + mods.size() + " mods added.");
                this.plugin.checkAllPlayers();
                break;
            }
            default: {
                this.sendUsage(sender);
            }
        }
        return true;
    }

    private void sendUsage(CommandSender sender) {
        boolean isV2 = this.plugin.getBlacklistConfig().isV2Config();
        if (isV2) {
            sender.sendMessage("\u00a76=== HandShaker Commands (v2) ===");
            sender.sendMessage("\u00a7e/handshaker reload \u00a77- Reload config");
            sender.sendMessage("\u00a7e/handshaker add <mod> <allowed|required|blacklisted> \u00a77- Add/set mod status");
            sender.sendMessage("\u00a7e/handshaker add * <status> \u00a77- Add all your mods");
            sender.sendMessage("\u00a7e/handshaker change <mod> <status> \u00a77- Change mod status");
            sender.sendMessage("\u00a7e/handshaker remove <mod> \u00a77- Remove mod from config");
            sender.sendMessage("\u00a7e/handshaker list \u00a77- List configured mods");
            sender.sendMessage("\u00a7e/handshaker player <player> \u00a77- View player's mods (interactive)");
        } else {
            sender.sendMessage("\u00a76=== HandShaker Commands (v1) ===");
            sender.sendMessage("\u00a7e/handshaker reload \u00a77- Reload config");
            sender.sendMessage("\u00a7e/handshaker mode <blacklist|whitelist|require> \u00a77- Set mode");
            sender.sendMessage("\u00a7e/handshaker add <mod> \u00a77- Add to blacklist");
            sender.sendMessage("\u00a7e/handshaker remove <mod> \u00a77- Remove from blacklist");
            sender.sendMessage("\u00a7e/handshaker player <player> \u00a77- View player's mods");
            sender.sendMessage("\u00a7e/handshaker whitelist_update <player> \u00a77- Update whitelist");
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        boolean isV2 = this.plugin.getBlacklistConfig().isV2Config();
        if (args.length == 1) {
            ArrayList<String> commands = new ArrayList<String>(Arrays.asList("reload", "add", "remove", "player"));
            if (isV2) {
                commands.addAll(Arrays.asList("change", "list"));
            } else {
                commands.addAll(Arrays.asList("mode", "whitelist_update"));
            }
            return (List)StringUtil.copyPartialMatches((String)args[0], commands, new ArrayList());
        }
        if (args.length == 2) {
            switch (args[0].toLowerCase(Locale.ROOT)) {
                case "remove": {
                    if (isV2) {
                        return (List)StringUtil.copyPartialMatches((String)args[1], this.plugin.getBlacklistConfig().getModStatusMap().keySet(), new ArrayList());
                    }
                    return (List)StringUtil.copyPartialMatches((String)args[1], this.plugin.getBlacklistConfig().getBlacklistedMods(), new ArrayList());
                }
                case "change": {
                    if (!isV2) break;
                    return (List)StringUtil.copyPartialMatches((String)args[1], this.plugin.getBlacklistConfig().getModStatusMap().keySet(), new ArrayList());
                }
                case "add": {
                    Player p;
                    Set<String> clientMods;
                    if (isV2) {
                        Player p2;
                        Set<String> clientMods2;
                        ArrayList<String> suggestions = new ArrayList<String>(Arrays.asList("*"));
                        if (sender instanceof Player && (clientMods2 = this.plugin.getClientMods((p2 = (Player)sender).getUniqueId())) != null) {
                            suggestions.addAll(clientMods2);
                        }
                        return (List)StringUtil.copyPartialMatches((String)args[1], suggestions, new ArrayList());
                    }
                    if (!(sender instanceof Player) || (clientMods = this.plugin.getClientMods((p = (Player)sender).getUniqueId())) == null) break;
                    ArrayList<String> suggestions = new ArrayList<String>(clientMods);
                    suggestions.removeAll(this.plugin.getBlacklistConfig().getBlacklistedMods());
                    return (List)StringUtil.copyPartialMatches((String)args[1], suggestions, new ArrayList());
                }
                case "player": 
                case "whitelist_update": {
                    List playerNames = Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
                    return (List)StringUtil.copyPartialMatches((String)args[1], playerNames, new ArrayList());
                }
                case "mode": {
                    if (isV2) break;
                    return (List)StringUtil.copyPartialMatches((String)args[1], Arrays.asList("blacklist", "whitelist", "require"), new ArrayList());
                }
            }
        }
        if (args.length == 3 && (args[0].equalsIgnoreCase("add") || args[0].equalsIgnoreCase("change")) && isV2) {
            return (List)StringUtil.copyPartialMatches((String)args[2], Arrays.asList("allowed", "required", "blacklisted"), new ArrayList());
        }
        return Collections.emptyList();
    }
}

