/*
 * Decompiled with CFR 0.152.
 */
package me.mklv.handshaker.paper;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.mklv.handshaker.paper.BlacklistConfig;
import me.mklv.handshaker.paper.HandShakerCommand;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class HandShakerPlugin
extends JavaPlugin
implements Listener {
    public static final String MODS_CHANNEL = "hand-shaker:mods";
    public static final String INTEGRITY_CHANNEL = "hand-shaker:integrity";
    private final Map<UUID, ClientInfo> clients = new ConcurrentHashMap<UUID, ClientInfo>();
    private BlacklistConfig blacklistConfig;
    private byte[] serverCertificate;

    public void onEnable() {
        this.blacklistConfig = new BlacklistConfig(this);
        this.blacklistConfig.load();
        this.loadServerCertificate();
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this, MODS_CHANNEL, (channel, player, message) -> this.handleModList(player, message));
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this, INTEGRITY_CHANNEL, (channel, player, message) -> this.handleIntegrityPayload(player, message));
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, MODS_CHANNEL);
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, INTEGRITY_CHANNEL);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        PluginCommand cmd = this.getCommand("handshaker");
        if (cmd != null) {
            cmd.setExecutor((CommandExecutor)new HandShakerCommand(this));
        }
        this.getLogger().info("HandShaker plugin enabled");
    }

    private void loadServerCertificate() {
        try (InputStream is = this.getResource("public.cer");){
            if (is == null) {
                if (this.blacklistConfig.getIntegrityMode() == BlacklistConfig.IntegrityMode.SIGNED) {
                    this.getLogger().severe("Could not find 'public.cer' in the plugin JAR. Integrity checking will fail.");
                }
                this.serverCertificate = new byte[0];
                return;
            }
            this.serverCertificate = is.readAllBytes();
            this.getLogger().info("Successfully loaded embedded server certificate (" + this.serverCertificate.length + " bytes)");
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to load embedded server certificate: " + e.getMessage());
            this.serverCertificate = new byte[0];
        }
    }

    public void onDisable() {
        Bukkit.getMessenger().unregisterIncomingPluginChannel((Plugin)this, MODS_CHANNEL);
        Bukkit.getMessenger().unregisterIncomingPluginChannel((Plugin)this, INTEGRITY_CHANNEL);
        this.clients.clear();
    }

    private void handleModList(Player player, byte[] data) {
        try {
            String payload = this.decodeLengthPrefixedString(data);
            if (payload == null) {
                this.getLogger().warning("Failed to decode mod list from " + player.getName() + ". Rejecting.");
                player.kick(Component.text((String)"Corrupted handshake data").color((TextColor)NamedTextColor.RED));
                return;
            }
            String nonce = this.decodeLengthPrefixedString(data, payload.length());
            if (nonce == null || nonce.isEmpty()) {
                this.getLogger().warning("Received mod list from " + player.getName() + " with invalid/missing nonce. Rejecting.");
                player.kick(Component.text((String)"Invalid handshake: missing nonce").color((TextColor)NamedTextColor.RED));
                return;
            }
            HashSet<String> mods = new HashSet<String>();
            if (!payload.isBlank()) {
                for (String s : payload.split(",")) {
                    if (s.isBlank()) continue;
                    mods.add(s.trim().toLowerCase(Locale.ROOT));
                }
            }
            this.getLogger().info("Received mod list from " + player.getName() + " with nonce: " + nonce);
            this.clients.compute(player.getUniqueId(), (uuid, oldInfo) -> oldInfo == null ? new ClientInfo(true, mods, false, nonce, null) : new ClientInfo(true, mods, oldInfo.signatureVerified(), nonce, oldInfo.integrityNonce()));
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to decode mod list from " + player.getName() + ". Terminating connection: " + e.getMessage());
            player.kick(Component.text((String)"Corrupted handshake data").color((TextColor)NamedTextColor.RED));
        }
    }

    private void handleIntegrityPayload(Player player, byte[] data) {
        try {
            byte[] clientCertificate = this.decodeLengthPrefixedByteArray(data);
            if (clientCertificate == null) {
                this.getLogger().warning("Failed to decode integrity payload from " + player.getName() + ". Rejecting.");
                player.kick(Component.text((String)"Corrupted handshake data").color((TextColor)NamedTextColor.RED));
                return;
            }
            String nonce = this.decodeLengthPrefixedString(data, clientCertificate.length);
            if (nonce == null || nonce.isEmpty()) {
                this.getLogger().warning("Received integrity payload from " + player.getName() + " with invalid/missing nonce. Rejecting.");
                player.kick(Component.text((String)"Invalid handshake: missing nonce").color((TextColor)NamedTextColor.RED));
                return;
            }
            boolean verified = false;
            if (clientCertificate.length > 0 && this.serverCertificate.length > 0) {
                verified = Arrays.equals(clientCertificate, this.serverCertificate);
            }
            this.getLogger().info("Integrity check for " + player.getName() + " with nonce " + nonce + ": " + (verified ? "PASSED" : "FAILED"));
            boolean finalVerified = verified;
            this.clients.compute(player.getUniqueId(), (uuid, oldInfo) -> oldInfo == null ? new ClientInfo(false, Collections.emptySet(), finalVerified, null, nonce) : new ClientInfo(oldInfo.fabric(), oldInfo.mods(), finalVerified, oldInfo.modListNonce(), nonce));
            this.check(player);
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to decode integrity payload from " + player.getName() + ". Terminating connection: " + e.getMessage());
            player.kick(Component.text((String)"Corrupted handshake data").color((TextColor)NamedTextColor.RED));
        }
    }

    private void check(Player player) {
        ClientInfo info = this.clients.get(player.getUniqueId());
        if (info == null) {
            return;
        }
        if (this.blacklistConfig.getBehavior() == BlacklistConfig.Behavior.STRICT && !info.fabric()) {
            player.kick(Component.text((String)this.blacklistConfig.getNoHandshakeKickMessage()).color((TextColor)NamedTextColor.RED));
            return;
        }
        if (this.blacklistConfig.getIntegrityMode() == BlacklistConfig.IntegrityMode.SIGNED && !info.signatureVerified()) {
            player.kick(Component.text((String)this.blacklistConfig.getInvalidSignatureKickMessage()).color((TextColor)NamedTextColor.RED));
            return;
        }
        Set<String> mods = info.mods();
        if (this.blacklistConfig.isV2Config()) {
            String msg;
            ArrayList<String> requiredMissing = new ArrayList<String>();
            ArrayList<String> blacklistedPresent = new ArrayList<String>();
            for (String string : mods) {
                BlacklistConfig.ModStatus status = this.blacklistConfig.getModStatus(string);
                if (status != BlacklistConfig.ModStatus.BLACKLISTED) continue;
                blacklistedPresent.add(string);
            }
            for (Map.Entry entry : this.blacklistConfig.getModStatusMap().entrySet()) {
                if (entry.getValue() != BlacklistConfig.ModStatus.REQUIRED || mods.contains(entry.getKey())) continue;
                requiredMissing.add((String)entry.getKey());
            }
            if (!requiredMissing.isEmpty()) {
                msg = this.blacklistConfig.getMissingWhitelistModMessage().replace("{mod}", String.join((CharSequence)", ", requiredMissing));
                player.kick(Component.text((String)msg).color((TextColor)NamedTextColor.RED));
                return;
            }
            if (!blacklistedPresent.isEmpty()) {
                msg = this.blacklistConfig.getKickMessage().replace("{mod}", String.join((CharSequence)", ", blacklistedPresent));
                player.kick(Component.text((String)msg).color((TextColor)NamedTextColor.RED));
                return;
            }
        } else if (this.blacklistConfig.getMode() == BlacklistConfig.Mode.BLACKLIST) {
            ArrayList<String> hits = new ArrayList<String>();
            for (String mod : this.blacklistConfig.getBlacklistedMods()) {
                if (!mods.contains(mod)) continue;
                hits.add(mod);
            }
            if (!hits.isEmpty()) {
                String msg = this.blacklistConfig.getKickMessage().replace("{mod}", String.join((CharSequence)", ", hits));
                player.kick(Component.text((String)msg).color((TextColor)NamedTextColor.RED));
            }
        } else if (info.fabric() || !this.blacklistConfig.getWhitelistedMods().isEmpty()) {
            Set<String> whitelistedMods = this.blacklistConfig.getWhitelistedMods();
            ArrayList<String> missing = new ArrayList<String>();
            for (String string : whitelistedMods) {
                if (mods.contains(string)) continue;
                missing.add(string);
            }
            if (!missing.isEmpty()) {
                String msg = this.blacklistConfig.getMissingWhitelistModMessage().replace("{mod}", String.join((CharSequence)", ", missing));
                player.kick(Component.text((String)msg).color((TextColor)NamedTextColor.RED));
                return;
            }
            if (this.blacklistConfig.getMode() == BlacklistConfig.Mode.REQUIRE) {
                ArrayList<String> banned = new ArrayList<String>();
                for (String mod : this.blacklistConfig.getBlacklistedMods()) {
                    if (!mods.contains(mod)) continue;
                    banned.add(mod);
                }
                if (!banned.isEmpty()) {
                    String string = this.blacklistConfig.getKickMessage().replace("{mod}", String.join((CharSequence)", ", banned));
                    player.kick(Component.text((String)string).color((TextColor)NamedTextColor.RED));
                    return;
                }
            } else if (this.blacklistConfig.getMode() == BlacklistConfig.Mode.WHITELIST) {
                ArrayList<String> extra = new ArrayList<String>();
                for (String mod : mods) {
                    if (whitelistedMods.contains(mod)) continue;
                    extra.add(mod);
                }
                if (!extra.isEmpty()) {
                    String string = this.blacklistConfig.getExtraWhitelistModMessage().replace("{mod}", String.join((CharSequence)", ", extra));
                    player.kick(Component.text((String)string).color((TextColor)NamedTextColor.RED));
                }
            }
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            this.clients.putIfAbsent(e.getPlayer().getUniqueId(), new ClientInfo(false, Collections.emptySet(), false, null, null));
            this.check(e.getPlayer());
        }, 100L);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        this.clients.remove(e.getPlayer().getUniqueId());
    }

    public BlacklistConfig getBlacklistConfig() {
        return this.blacklistConfig;
    }

    public Set<String> getClientMods(UUID uuid) {
        ClientInfo info = this.clients.get(uuid);
        return info != null ? info.mods : null;
    }

    public void checkAllPlayers() {
        this.getLogger().info("Re-checking all online players...");
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.check(player);
        }
    }

    private byte[] decodeLengthPrefixedByteArray(byte[] data) {
        try {
            byte read;
            int idx = 0;
            int numRead = 0;
            int result = 0;
            do {
                read = data[idx++];
                int value = read & 0x7F;
                result |= value << 7 * numRead;
                if (++numRead <= 5) continue;
                return null;
            } while ((read & 0x80) != 0);
            int length = result;
            if (length < 0 || idx + length > data.length) {
                return null;
            }
            byte[] bytes = new byte[length];
            System.arraycopy(data, idx, bytes, 0, length);
            return bytes;
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to decode byte array payload: " + e.getMessage());
            return null;
        }
    }

    private String decodeLengthPrefixedString(byte[] data) {
        try {
            byte read;
            int idx = 0;
            int numRead = 0;
            int result = 0;
            do {
                read = data[idx++];
                int value = read & 0x7F;
                result |= value << 7 * numRead;
                if (++numRead <= 5) continue;
                return null;
            } while ((read & 0x80) != 0);
            int length = result;
            if (length < 0 || idx + length > data.length) {
                return null;
            }
            return new String(data, idx, length, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to decode mods payload: " + e.getMessage());
            return null;
        }
    }

    private String decodeLengthPrefixedString(byte[] data, int previousDataLength) {
        try {
            byte read;
            int offset = 0;
            int numRead = 0;
            do {
                read = data[offset++];
                if (++numRead <= 5) continue;
                return null;
            } while ((read & 0x80) != 0);
            int idx = offset += previousDataLength;
            numRead = 0;
            int result = 0;
            do {
                if (idx >= data.length) {
                    return null;
                }
                read = data[idx++];
                int value = read & 0x7F;
                result |= value << 7 * numRead;
                if (++numRead <= 5) continue;
                return null;
            } while ((read & 0x80) != 0);
            int length = result;
            if (length < 0 || idx + length > data.length) {
                return null;
            }
            return new String(data, idx, length, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to decode string at offset: " + e.getMessage());
            return null;
        }
    }

    private record ClientInfo(boolean fabric, Set<String> mods, boolean signatureVerified, String modListNonce, String integrityNonce) {
    }
}

