/*
 * Decompiled with CFR 0.152.
 */
package me.mklv.handshaker.server;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import me.mklv.handshaker.server.BlacklistConfig;
import me.mklv.handshaker.server.HandShakerServer;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class HandShakerCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        BlacklistConfig config = HandShakerServer.getInstance().getBlacklistConfig();
        boolean isV2 = config.isV2Config();
        LiteralArgumentBuilder handshaker = (LiteralArgumentBuilder)class_2170.method_9247((String)"handshaker").then(class_2170.method_9247((String)"reload").executes(HandShakerCommand::reload));
        if (isV2) {
            ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)handshaker.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").then(class_2170.method_9247((String)"*").then(class_2170.method_9244((String)"status", (ArgumentType)StringArgumentType.word()).suggests(HandShakerCommand::suggestStatuses).executes(HandShakerCommand::addAllMods)))).then(class_2170.method_9244((String)"mod", (ArgumentType)StringArgumentType.word()).suggests(HandShakerCommand::suggestMods).then(class_2170.method_9244((String)"status", (ArgumentType)StringArgumentType.word()).suggests(HandShakerCommand::suggestStatuses).executes(HandShakerCommand::addMod))))).then(class_2170.method_9247((String)"change").then(class_2170.method_9244((String)"mod", (ArgumentType)StringArgumentType.word()).suggests(HandShakerCommand::suggestConfiguredMods).then(class_2170.method_9244((String)"status", (ArgumentType)StringArgumentType.word()).suggests(HandShakerCommand::suggestStatuses).executes(HandShakerCommand::changeMod))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"mod", (ArgumentType)StringArgumentType.word()).suggests(HandShakerCommand::suggestConfiguredMods).executes(HandShakerCommand::removeMod)))).then(class_2170.method_9247((String)"list").executes(HandShakerCommand::listMods))).then(class_2170.method_9247((String)"player").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests(HandShakerCommand::suggestPlayers).executes(HandShakerCommand::showPlayer)).then(class_2170.method_9244((String)"mod", (ArgumentType)StringArgumentType.word()).suggests(HandShakerCommand::suggestPlayerMods).then(class_2170.method_9244((String)"status", (ArgumentType)StringArgumentType.word()).suggests(HandShakerCommand::suggestStatuses).executes(HandShakerCommand::setPlayerModStatus)))));
        } else {
            ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)handshaker.then(class_2170.method_9247((String)"mode").then(class_2170.method_9244((String)"mode", (ArgumentType)StringArgumentType.word()).suggests(HandShakerCommand::suggestModes).executes(HandShakerCommand::setMode)))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"mod", (ArgumentType)StringArgumentType.word()).suggests(HandShakerCommand::suggestMods).executes(HandShakerCommand::addModV1)))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"mod", (ArgumentType)StringArgumentType.word()).suggests(HandShakerCommand::suggestBlacklistedMods).executes(HandShakerCommand::removeMod)))).then(class_2170.method_9247((String)"player").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests(HandShakerCommand::suggestPlayers).executes(HandShakerCommand::showPlayerV1)))).then(class_2170.method_9247((String)"whitelist_update").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests(HandShakerCommand::suggestPlayers).executes(HandShakerCommand::whitelistUpdate)));
        }
        dispatcher.register(handshaker);
    }

    private static int reload(CommandContext<class_2168> ctx) {
        BlacklistConfig config = HandShakerServer.getInstance().getBlacklistConfig();
        config.load();
        class_5250 message = class_2561.method_43470((String)"HandShaker config reloaded. Re-checking all online players.");
        ((class_2168)ctx.getSource()).method_9226(() -> HandShakerCommand.lambda$reload$0((class_2561)message), true);
        HandShakerServer.getInstance().checkAllPlayers();
        return 1;
    }

    private static int addMod(CommandContext<class_2168> ctx) {
        BlacklistConfig.ModStatus status;
        String modId = StringArgumentType.getString(ctx, (String)"mod");
        String statusStr = StringArgumentType.getString(ctx, (String)"status");
        try {
            status = BlacklistConfig.ModStatus.valueOf(statusStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid status. Use: allowed, required, or blacklisted"));
            return 0;
        }
        BlacklistConfig config = HandShakerServer.getInstance().getBlacklistConfig();
        config.setModStatus(modId, status);
        class_5250 message = class_2561.method_43470((String)("Set " + modId + " to " + statusStr.toLowerCase())).method_27692(class_124.field_1060);
        ((class_2168)ctx.getSource()).method_9226(() -> HandShakerCommand.lambda$addMod$1((class_2561)message), true);
        HandShakerServer.getInstance().checkAllPlayers();
        return 1;
    }

    private static int addAllMods(CommandContext<class_2168> ctx) {
        Set<String> mods;
        BlacklistConfig.ModStatus status;
        String statusStr = StringArgumentType.getString(ctx, (String)"status");
        try {
            status = BlacklistConfig.ModStatus.valueOf(statusStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid status. Use: allowed, required, or blacklisted"));
            return 0;
        }
        class_1297 class_12972 = ((class_2168)ctx.getSource()).method_9228();
        if (!(class_12972 instanceof class_3222)) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players."));
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        HandShakerServer.ClientInfo clientInfo = HandShakerServer.getInstance().getClients().get(player.method_5667());
        Set<String> set = mods = clientInfo != null ? clientInfo.mods() : null;
        if (mods == null || mods.isEmpty()) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No mod list found for you. Make sure you're using a modded client."));
            return 0;
        }
        BlacklistConfig config = HandShakerServer.getInstance().getBlacklistConfig();
        config.addAllMods(mods, status);
        int size = mods.size();
        class_5250 message = class_2561.method_43470((String)("Added " + size + " of your mods as " + statusStr.toLowerCase())).method_27692(class_124.field_1060);
        ((class_2168)ctx.getSource()).method_9226(() -> HandShakerCommand.lambda$addAllMods$2((class_2561)message), true);
        HandShakerServer.getInstance().checkAllPlayers();
        return 1;
    }

    private static int changeMod(CommandContext<class_2168> ctx) {
        BlacklistConfig.ModStatus status;
        String modId = StringArgumentType.getString(ctx, (String)"mod");
        String statusStr = StringArgumentType.getString(ctx, (String)"status");
        try {
            status = BlacklistConfig.ModStatus.valueOf(statusStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid status. Use: allowed, required, or blacklisted"));
            return 0;
        }
        BlacklistConfig config = HandShakerServer.getInstance().getBlacklistConfig();
        config.setModStatus(modId, status);
        class_5250 message = class_2561.method_43470((String)("Changed " + modId + " to " + statusStr.toLowerCase())).method_27692(class_124.field_1060);
        ((class_2168)ctx.getSource()).method_9226(() -> HandShakerCommand.lambda$changeMod$3((class_2561)message), true);
        HandShakerServer.getInstance().checkAllPlayers();
        return 1;
    }

    private static int listMods(CommandContext<class_2168> ctx) {
        BlacklistConfig config = HandShakerServer.getInstance().getBlacklistConfig();
        Map<String, BlacklistConfig.ModStatus> mods = config.getModStatusMap();
        if (mods.isEmpty()) {
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("No mods configured. Default mode: " + String.valueOf((Object)config.getDefaultMode()))).method_27692(class_124.field_1054));
            return 1;
        }
        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("=== Configured Mods (Default: " + String.valueOf((Object)config.getDefaultMode()) + ") ===")).method_27692(class_124.field_1065));
        for (Map.Entry<String, BlacklistConfig.ModStatus> entry : mods.entrySet()) {
            String modId = entry.getKey();
            BlacklistConfig.ModStatus status = entry.getValue();
            class_124 statusColor = switch (status) {
                default -> throw new MatchException(null, null);
                case BlacklistConfig.ModStatus.REQUIRED -> class_124.field_1060;
                case BlacklistConfig.ModStatus.ALLOWED -> class_124.field_1054;
                case BlacklistConfig.ModStatus.BLACKLISTED -> class_124.field_1061;
            };
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)(modId + " [" + String.valueOf((Object)status) + "]")).method_27692(statusColor));
        }
        return 1;
    }

    private static int showPlayer(CommandContext<class_2168> ctx) {
        Set<String> mods;
        String playerName = StringArgumentType.getString(ctx, (String)"player");
        class_3222 player = ((class_2168)ctx.getSource()).method_9211().method_3760().method_14566(playerName);
        if (player == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Player '" + playerName + "' not found.")));
            return 0;
        }
        HandShakerServer.ClientInfo clientInfo = HandShakerServer.getInstance().getClients().get(player.method_5667());
        Set<String> set = mods = clientInfo != null ? clientInfo.mods() : null;
        if (mods == null || mods.isEmpty()) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("No mod list found for " + playerName + ".")));
            return 0;
        }
        BlacklistConfig config = HandShakerServer.getInstance().getBlacklistConfig();
        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("=== " + playerName + "'s Mods ===")).method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}));
        for (String mod : mods) {
            BlacklistConfig.ModStatus currentStatus = config.getModStatus(mod);
            if (currentStatus == null) {
                currentStatus = BlacklistConfig.ModStatus.ALLOWED;
            }
            class_124 statusColor = switch (currentStatus) {
                default -> throw new MatchException(null, null);
                case BlacklistConfig.ModStatus.REQUIRED -> class_124.field_1060;
                case BlacklistConfig.ModStatus.ALLOWED -> class_124.field_1054;
                case BlacklistConfig.ModStatus.BLACKLISTED -> class_124.field_1061;
            };
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("  " + mod + " [" + String.valueOf((Object)currentStatus) + "]")).method_27692(statusColor));
        }
        return 1;
    }

    private static int setPlayerModStatus(CommandContext<class_2168> ctx) {
        BlacklistConfig.ModStatus status;
        Set<String> mods;
        String playerName = StringArgumentType.getString(ctx, (String)"player");
        String modId = StringArgumentType.getString(ctx, (String)"mod");
        String statusStr = StringArgumentType.getString(ctx, (String)"status");
        class_3222 player = ((class_2168)ctx.getSource()).method_9211().method_3760().method_14566(playerName);
        if (player == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Player '" + playerName + "' not found.")));
            return 0;
        }
        HandShakerServer.ClientInfo clientInfo = HandShakerServer.getInstance().getClients().get(player.method_5667());
        Set<String> set = mods = clientInfo != null ? clientInfo.mods() : null;
        if (mods == null || !mods.contains(modId)) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Player " + playerName + " does not have mod: " + modId)));
            return 0;
        }
        try {
            status = BlacklistConfig.ModStatus.valueOf(statusStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid status. Use: allowed, required, or blacklisted"));
            return 0;
        }
        BlacklistConfig config = HandShakerServer.getInstance().getBlacklistConfig();
        config.setModStatus(modId, status);
        class_5250 message = class_2561.method_43470((String)("Set " + modId + " to " + statusStr.toLowerCase())).method_27692(class_124.field_1060);
        ((class_2168)ctx.getSource()).method_9226(() -> HandShakerCommand.lambda$setPlayerModStatus$4((class_2561)message), true);
        HandShakerServer.getInstance().checkAllPlayers();
        return 1;
    }

    private static int setMode(CommandContext<class_2168> ctx) {
        BlacklistConfig.Mode mode;
        String modeStr = StringArgumentType.getString(ctx, (String)"mode");
        BlacklistConfig config = HandShakerServer.getInstance().getBlacklistConfig();
        try {
            mode = BlacklistConfig.Mode.valueOf(modeStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Unknown mode. Use blacklist, whitelist, or require."));
            return 0;
        }
        config.setMode(mode);
        class_5250 message = class_2561.method_43470((String)("HandShaker mode set to " + modeStr + "."));
        ((class_2168)ctx.getSource()).method_9226(() -> HandShakerCommand.lambda$setMode$5((class_2561)message), true);
        HandShakerServer.getInstance().checkAllPlayers();
        return 1;
    }

    private static int addModV1(CommandContext<class_2168> ctx) {
        String modId = StringArgumentType.getString(ctx, (String)"mod");
        BlacklistConfig config = HandShakerServer.getInstance().getBlacklistConfig();
        boolean added = config.addMod(modId);
        class_5250 message = class_2561.method_43470((String)(added ? "Added " + modId : modId + " already in blacklist."));
        ((class_2168)ctx.getSource()).method_9226(() -> HandShakerCommand.lambda$addModV1$6((class_2561)message), true);
        if (added) {
            HandShakerServer.getInstance().checkAllPlayers();
        }
        return 1;
    }

    private static int showPlayerV1(CommandContext<class_2168> ctx) {
        Set<String> mods;
        String playerName = StringArgumentType.getString(ctx, (String)"player");
        class_3222 player = ((class_2168)ctx.getSource()).method_9211().method_3760().method_14566(playerName);
        if (player == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Player '" + playerName + "' not found.")));
            return 0;
        }
        HandShakerServer.ClientInfo clientInfo = HandShakerServer.getInstance().getClients().get(player.method_5667());
        Set<String> set = mods = clientInfo != null ? clientInfo.mods() : null;
        if (mods == null || mods.isEmpty()) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("No mod list found for " + playerName + ".")));
            return 0;
        }
        BlacklistConfig config = HandShakerServer.getInstance().getBlacklistConfig();
        Set<String> blacklisted = config.getBlacklistedMods();
        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("=== " + playerName + "'s Mods ===")).method_27692(class_124.field_1065));
        for (String mod : mods) {
            if (blacklisted.contains(mod)) {
                ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("  \u2022 " + mod + " [BLACKLISTED]")).method_27692(class_124.field_1061));
                continue;
            }
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("  \u2022 " + mod)).method_27692(class_124.field_1068));
        }
        return 1;
    }

    private static int whitelistUpdate(CommandContext<class_2168> ctx) {
        Set<String> mods;
        String playerName = StringArgumentType.getString(ctx, (String)"player");
        class_3222 player = ((class_2168)ctx.getSource()).method_9211().method_3760().method_14566(playerName);
        if (player == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Player not found."));
            return 0;
        }
        HandShakerServer.ClientInfo clientInfo = HandShakerServer.getInstance().getClients().get(player.method_5667());
        Set<String> set = mods = clientInfo != null ? clientInfo.mods() : null;
        if (mods == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Mod list for " + playerName + " not found. Make sure they are online and using Fabric.")));
            return 0;
        }
        BlacklistConfig config = HandShakerServer.getInstance().getBlacklistConfig();
        config.setWhitelist(mods);
        int size = mods.size();
        class_5250 message = class_2561.method_43470((String)("Whitelist updated with " + playerName + "'s mods. " + size + " mods added."));
        ((class_2168)ctx.getSource()).method_9226(() -> HandShakerCommand.lambda$whitelistUpdate$7((class_2561)message), true);
        HandShakerServer.getInstance().checkAllPlayers();
        return 1;
    }

    private static int removeMod(CommandContext<class_2168> ctx) {
        String modId = StringArgumentType.getString(ctx, (String)"mod");
        BlacklistConfig config = HandShakerServer.getInstance().getBlacklistConfig();
        boolean removed = config.removeMod(modId);
        class_5250 message = class_2561.method_43470((String)(removed ? "Removed " + modId : modId + " not found."));
        ((class_2168)ctx.getSource()).method_9226(() -> HandShakerCommand.lambda$removeMod$8((class_2561)message), true);
        return 1;
    }

    private static CompletableFuture<Suggestions> suggestStatuses(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        return class_2172.method_9253((String[])new String[]{"allowed", "required", "blacklisted"}, (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> suggestModes(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        return class_2172.method_9253((String[])new String[]{"blacklist", "whitelist", "require"}, (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> suggestPlayers(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        return class_2172.method_9264(((class_2168)ctx.getSource()).method_9211().method_3760().method_14571().stream().map(p -> p.method_5477().getString()), (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> suggestMods(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        class_2168 source = (class_2168)ctx.getSource();
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            Set<String> mods;
            class_3222 player = (class_3222)class_12972;
            HandShakerServer.ClientInfo clientInfo = HandShakerServer.getInstance().getClients().get(player.method_5667());
            Set<String> set = mods = clientInfo != null ? clientInfo.mods() : null;
            if (mods != null && !mods.isEmpty()) {
                return class_2172.method_9265(mods, (SuggestionsBuilder)builder);
            }
        }
        return Suggestions.empty();
    }

    private static CompletableFuture<Suggestions> suggestPlayerMods(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        try {
            String playerName = StringArgumentType.getString(ctx, (String)"player");
            class_3222 player = ((class_2168)ctx.getSource()).method_9211().method_3760().method_14566(playerName);
            if (player != null) {
                Set<String> mods;
                HandShakerServer.ClientInfo clientInfo = HandShakerServer.getInstance().getClients().get(player.method_5667());
                Set<String> set = mods = clientInfo != null ? clientInfo.mods() : null;
                if (mods != null && !mods.isEmpty()) {
                    return class_2172.method_9265(mods, (SuggestionsBuilder)builder);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return Suggestions.empty();
    }

    private static CompletableFuture<Suggestions> suggestConfiguredMods(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        BlacklistConfig config = HandShakerServer.getInstance().getBlacklistConfig();
        return class_2172.method_9265(config.getModStatusMap().keySet(), (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> suggestBlacklistedMods(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        BlacklistConfig config = HandShakerServer.getInstance().getBlacklistConfig();
        return class_2172.method_9265(config.getBlacklistedMods(), (SuggestionsBuilder)builder);
    }

    private static /* synthetic */ class_2561 lambda$removeMod$8(class_2561 message) {
        return message;
    }

    private static /* synthetic */ class_2561 lambda$whitelistUpdate$7(class_2561 message) {
        return message;
    }

    private static /* synthetic */ class_2561 lambda$addModV1$6(class_2561 message) {
        return message;
    }

    private static /* synthetic */ class_2561 lambda$setMode$5(class_2561 message) {
        return message;
    }

    private static /* synthetic */ class_2561 lambda$setPlayerModStatus$4(class_2561 message) {
        return message;
    }

    private static /* synthetic */ class_2561 lambda$changeMod$3(class_2561 message) {
        return message;
    }

    private static /* synthetic */ class_2561 lambda$addAllMods$2(class_2561 message) {
        return message;
    }

    private static /* synthetic */ class_2561 lambda$addMod$1(class_2561 message) {
        return message;
    }

    private static /* synthetic */ class_2561 lambda$reload$0(class_2561 message) {
        return message;
    }
}

