/*
 * Decompiled with CFR 0.152.
 */
package me.mklv.handshaker.paper;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import me.mklv.handshaker.paper.HandShakerPlugin;
import org.bukkit.configuration.file.YamlConfiguration;

public class BlacklistConfig {
    private final HandShakerPlugin plugin;
    private File file;
    private YamlConfiguration config;
    private Behavior behavior = Behavior.VANILLA;
    private final Set<String> blacklistedMods = new LinkedHashSet<String>();
    private String kickMessage = "Remove: {mod}";
    private String noHandshakeKickMessage = "This server requires Hand-shaker mod.";

    public BlacklistConfig(HandShakerPlugin plugin) {
        this.plugin = plugin;
    }

    public void load() {
        String mode;
        if (this.file == null) {
            this.file = new File(this.plugin.getDataFolder(), "config.yml");
        }
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            this.plugin.saveResource("config.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.blacklistedMods.clear();
        String behaviorString = this.config.getString("Behavior", "").toUpperCase(Locale.ROOT);
        this.behavior = behaviorString.isEmpty() ? ((mode = this.config.getString("Kick Mode", this.config.getString("KickMode", "Fabric")).toUpperCase(Locale.ROOT)).startsWith("ALL") ? Behavior.STRICT : Behavior.VANILLA) : (behaviorString.startsWith("STRICT") ? Behavior.STRICT : Behavior.VANILLA);
        this.kickMessage = this.config.getString("Kick Message", "Remove: {mod}");
        this.noHandshakeKickMessage = this.config.getString("Missing mod message", "This server requires Hand-shaker mod.");
        if (this.config.isList("Blacklisted Mods")) {
            for (Object o : this.config.getList("Blacklisted Mods")) {
                if (o == null) continue;
                this.blacklistedMods.add(o.toString().toLowerCase(Locale.ROOT));
            }
        }
    }

    public Behavior getBehavior() {
        return this.behavior;
    }

    public Set<String> getBlacklistedMods() {
        return Collections.unmodifiableSet(this.blacklistedMods);
    }

    public String getKickMessage() {
        return this.kickMessage;
    }

    public String getNoHandshakeKickMessage() {
        return this.noHandshakeKickMessage;
    }

    public boolean addMod(String modId) {
        boolean added = this.blacklistedMods.add(modId.toLowerCase(Locale.ROOT));
        this.save();
        return added;
    }

    public boolean removeMod(String modId) {
        boolean removed = this.blacklistedMods.remove(modId.toLowerCase(Locale.ROOT));
        this.save();
        return removed;
    }

    public void save() {
        this.config.set("Behavior", (Object)(this.behavior == Behavior.STRICT ? "Strict" : "Vanilla"));
        this.config.set("Kick Message", (Object)this.kickMessage);
        this.config.set("Missing mod message", (Object)this.noHandshakeKickMessage);
        this.config.set("Blacklisted Mods", new ArrayList<String>(this.blacklistedMods));
        try {
            this.config.save(this.file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static enum Behavior {
        STRICT,
        VANILLA;

    }
}

