/*
 * Decompiled with CFR 0.152.
 */
package me.mklv.handshaker.paper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import me.mklv.handshaker.paper.HandShakerPlugin;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class HandShakerCommand
implements TabExecutor {
    private final HandShakerPlugin plugin;

    public HandShakerCommand(HandShakerPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage("/handshaker reload | add <mod> | remove <mod> | player <player> [mod]");
            return true;
        }
        switch (args[0].toLowerCase(Locale.ROOT)) {
            case "reload": {
                this.plugin.getBlacklistConfig().load();
                sender.sendMessage("HandShaker blacklist reloaded. Re-checking all online players.");
                this.plugin.checkAllPlayers();
                return true;
            }
            case "remove": {
                if (args.length < 2) {
                    sender.sendMessage("Usage: /handshaker remove <mod>");
                    return true;
                }
                boolean removed = this.plugin.getBlacklistConfig().removeMod(args[1]);
                sender.sendMessage(removed ? "Removed " + args[1] : args[1] + " not found in blacklist.");
                return true;
            }
            case "add": {
                if (args.length < 2) {
                    sender.sendMessage("Usage: /handshaker add <mod>");
                    return true;
                }
                boolean added = this.plugin.getBlacklistConfig().addMod(args[1]);
                sender.sendMessage(added ? "Added " + args[1] : args[1] + " already in blacklist.");
                if (added) {
                    this.plugin.checkAllPlayers();
                }
                return true;
            }
            case "player": {
                if (args.length < 2) {
                    sender.sendMessage("Usage: /handshaker player <player> [mod]");
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target == null) {
                    sender.sendMessage("Player '" + args[1] + "' not found.");
                    return true;
                }
                Set<String> mods = this.plugin.getClientMods(target.getUniqueId());
                if (mods == null || mods.isEmpty()) {
                    sender.sendMessage("No mod list found for " + target.getName() + ".");
                    return true;
                }
                if (args.length == 2) {
                    sender.sendMessage(target.getName() + "'s mods: " + String.join((CharSequence)", ", mods));
                    return true;
                }
                if (args.length == 3) {
                    String modToBlock = args[2];
                    if (!mods.contains(modToBlock)) {
                        sender.sendMessage(target.getName() + " does not have the mod '" + modToBlock + "'.");
                        return true;
                    }
                    boolean added = this.plugin.getBlacklistConfig().addMod(modToBlock);
                    sender.sendMessage(added ? "Added " + modToBlock + " to the blacklist." : modToBlock + " is already in the blacklist.");
                    if (added) {
                        this.plugin.checkAllPlayers();
                    }
                    return true;
                }
                sender.sendMessage("Usage: /handshaker player <player> [mod]");
                return true;
            }
        }
        sender.sendMessage("Unknown subcommand.");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        Set<String> clientMods;
        Player target;
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], Arrays.asList("reload", "add", "remove", "player"), new ArrayList());
        }
        if (args.length == 2) {
            Player p;
            Set<String> clientMods2;
            String currentInput = args[1];
            if (args[0].equalsIgnoreCase("remove")) {
                return (List)StringUtil.copyPartialMatches((String)currentInput, this.plugin.getBlacklistConfig().getBlacklistedMods(), new ArrayList());
            }
            if (args[0].equalsIgnoreCase("add") && sender instanceof Player && (clientMods2 = this.plugin.getClientMods((p = (Player)sender).getUniqueId())) != null) {
                ArrayList<String> suggestions = new ArrayList<String>(clientMods2);
                suggestions.removeAll(this.plugin.getBlacklistConfig().getBlacklistedMods());
                return (List)StringUtil.copyPartialMatches((String)currentInput, suggestions, new ArrayList());
            }
            if (args[0].equalsIgnoreCase("player")) {
                List playerNames = Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
                return (List)StringUtil.copyPartialMatches((String)currentInput, playerNames, new ArrayList());
            }
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("player") && (target = Bukkit.getPlayer((String)args[1])) != null && (clientMods = this.plugin.getClientMods(target.getUniqueId())) != null) {
            ArrayList<String> suggestions = new ArrayList<String>(clientMods);
            suggestions.removeAll(this.plugin.getBlacklistConfig().getBlacklistedMods());
            return (List)StringUtil.copyPartialMatches((String)args[2], suggestions, new ArrayList());
        }
        return Collections.emptyList();
    }
}

