/*
 * Decompiled with CFR 0.152.
 */
package me.mklv;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandShaker
implements ClientModInitializer {
    public static final String MOD_ID = "hand-shaker";
    public static final class_2960 MODS_CHANNEL = class_2960.method_60655((String)"hand-shaker", (String)"mods");
    public static final class_2960 INTEGRITY_CHANNEL = class_2960.method_60655((String)"hand-shaker", (String)"integrity");
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"hand-shaker");

    public void onInitializeClient() {
        LOGGER.info("HandShaker client initializing");
        PayloadTypeRegistry.playC2S().register(ModsListPayload.ID, ModsListPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(IntegrityPayload.ID, IntegrityPayload.CODEC);
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            this.sendModList();
            this.sendSignature();
        });
    }

    private void sendModList() {
        class_310 client = class_310.method_1551();
        if (client == null || client.method_1562() == null) {
            return;
        }
        String payload = FabricLoader.getInstance().getAllMods().stream().map(m -> m.getMetadata().getId()).sorted().reduce((a, b) -> a + "," + b).orElse("");
        ClientPlayNetworking.send((class_8710)new ModsListPayload(payload));
        LOGGER.info("Sent mod list ({} chars)", (Object)payload.length());
    }

    private void sendSignature() {
        class_310 client = class_310.method_1551();
        if (client == null || client.method_1562() == null) {
            return;
        }
        Optional<byte[]> certificate = this.getEmbeddedCertificate();
        if (certificate.isPresent()) {
            ClientPlayNetworking.send((class_8710)new IntegrityPayload(certificate.get()));
            LOGGER.info("Sent integrity certificate ({} bytes)", (Object)certificate.get().length);
        } else {
            LOGGER.warn("Could not find own embedded certificate. Sending empty payload.");
            ClientPlayNetworking.send((class_8710)new IntegrityPayload(new byte[0]));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<byte[]> getEmbeddedCertificate() {
        try (InputStream is = HandShaker.class.getClassLoader().getResourceAsStream("public.cer");){
            if (is == null) {
                LOGGER.error("Could not find 'public.cer' in the mod JAR.");
                Optional<byte[]> optional2 = Optional.empty();
                return optional2;
            }
            Optional<byte[]> optional = Optional.of(is.readAllBytes());
            return optional;
        }
        catch (IOException e) {
            LOGGER.error("Failed to load embedded certificate", (Throwable)e);
            return Optional.empty();
        }
    }

    public record ModsListPayload(String mods) implements class_8710
    {
        public static final class_8710.class_9154<ModsListPayload> ID = new class_8710.class_9154(MODS_CHANNEL);
        public static final class_9139<class_2540, ModsListPayload> CODEC = class_9139.method_56434((class_9139)class_9135.field_48554, ModsListPayload::mods, ModsListPayload::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    public record IntegrityPayload(byte[] signature) implements class_8710
    {
        public static final class_8710.class_9154<IntegrityPayload> ID = new class_8710.class_9154(INTEGRITY_CHANNEL);
        public static final class_9139<class_2540, IntegrityPayload> CODEC = class_9139.method_56434((class_9139)class_9135.field_48987, IntegrityPayload::signature, IntegrityPayload::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }
}

