/*
 * Decompiled with CFR 0.152.
 */
package me.mklv.handshaker.paper;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import me.mklv.handshaker.paper.HandShakerPlugin;
import org.bukkit.configuration.file.YamlConfiguration;

public class BlacklistConfig {
    private final HandShakerPlugin plugin;
    private File file;
    private YamlConfiguration config;
    private Mode mode = Mode.BLACKLIST;
    private Behavior behavior = Behavior.STRICT;
    private IntegrityMode integrityMode = IntegrityMode.SIGNED;
    private final Set<String> blacklistedMods = new LinkedHashSet<String>();
    private final Set<String> whitelistedMods = new LinkedHashSet<String>();
    private String kickMessage = "You are using a blacklisted mod: {mod}. Please remove it to join this server.";
    private String noHandshakeKickMessage = "To connect to this server please download 'Hand-shaker' mod.";
    private String missingWhitelistModMessage = "You are missing required mods: {mod}. Please install them to join this server.";
    private String extraWhitelistModMessage = "You have mods that are not on the whitelist: {mod}. Please remove them to join.";
    private String invalidSignatureKickMessage = "Invalid client signature. Please use the official client.";

    public BlacklistConfig(HandShakerPlugin plugin) {
        this.plugin = plugin;
    }

    public void load() {
        String oldMode;
        if (this.file == null) {
            this.file = new File(this.plugin.getDataFolder(), "config.yml");
        }
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            this.plugin.saveResource("config.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.blacklistedMods.clear();
        this.whitelistedMods.clear();
        String integrityString = this.config.getString("Integrity", "signed").toUpperCase(Locale.ROOT);
        this.integrityMode = integrityString.equals("SIGNED") ? IntegrityMode.SIGNED : IntegrityMode.DEV;
        String modeString = this.config.getString("Operation Mode", "blacklist").toUpperCase(Locale.ROOT);
        this.mode = modeString.equals("WHITELIST") ? Mode.WHITELIST : Mode.BLACKLIST;
        String behaviorString = this.config.getString("Behavior", "strict").toUpperCase(Locale.ROOT);
        this.behavior = behaviorString.isEmpty() ? ((oldMode = this.config.getString("Kick Mode", this.config.getString("KickMode", "Fabric")).toUpperCase(Locale.ROOT)).startsWith("ALL") ? Behavior.STRICT : Behavior.VANILLA) : (behaviorString.startsWith("STRICT") ? Behavior.STRICT : Behavior.VANILLA);
        this.kickMessage = this.config.getString("Kick Message", "You are using a blacklisted mod: {mod}. Please remove it to join this server.");
        this.noHandshakeKickMessage = this.config.getString("Missing mod message", "To connect to this server please download 'Hand-shaker' mod.");
        this.missingWhitelistModMessage = this.config.getString("Missing whitelist mod message", "You are missing required mods: {mod}. Please install them to join this server.");
        this.extraWhitelistModMessage = this.config.getString("Extra whitelist mod message", "You have mods that are not on the whitelist: {mod}. Please remove them to join.");
        this.invalidSignatureKickMessage = this.config.getString("Invalid signature kick message", "Invalid client signature. Please use the official client.");
        if (this.config.isList("Blacklisted Mods")) {
            for (Object o : this.config.getList("Blacklisted Mods")) {
                if (o == null) continue;
                this.blacklistedMods.add(o.toString().toLowerCase(Locale.ROOT));
            }
        }
        if (this.config.isList("Whitelisted Mods")) {
            for (Object o : this.config.getList("Whitelisted Mods")) {
                if (o == null) continue;
                this.whitelistedMods.add(o.toString().toLowerCase(Locale.ROOT));
            }
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.save();
    }

    public Behavior getBehavior() {
        return this.behavior;
    }

    public IntegrityMode getIntegrityMode() {
        return this.integrityMode;
    }

    public Set<String> getBlacklistedMods() {
        return Collections.unmodifiableSet(this.blacklistedMods);
    }

    public Set<String> getWhitelistedMods() {
        return Collections.unmodifiableSet(this.whitelistedMods);
    }

    public String getKickMessage() {
        return this.kickMessage;
    }

    public String getNoHandshakeKickMessage() {
        return this.noHandshakeKickMessage;
    }

    public String getMissingWhitelistModMessage() {
        return this.missingWhitelistModMessage;
    }

    public String getExtraWhitelistModMessage() {
        return this.extraWhitelistModMessage;
    }

    public String getInvalidSignatureKickMessage() {
        return this.invalidSignatureKickMessage;
    }

    public boolean addMod(String modId) {
        boolean added = this.blacklistedMods.add(modId.toLowerCase(Locale.ROOT));
        if (added) {
            this.save();
        }
        return added;
    }

    public boolean removeMod(String modId) {
        boolean removed = this.blacklistedMods.remove(modId.toLowerCase(Locale.ROOT));
        if (removed) {
            this.save();
        }
        return removed;
    }

    public void setWhitelistedMods(Set<String> mods) {
        this.whitelistedMods.clear();
        for (String mod : mods) {
            this.whitelistedMods.add(mod.toLowerCase(Locale.ROOT));
        }
        this.save();
    }

    public void save() {
        this.config.set("Integrity", (Object)(this.integrityMode == IntegrityMode.SIGNED ? "Signed" : "Dev"));
        this.config.set("Operation Mode", (Object)(this.mode == Mode.WHITELIST ? "whitelist" : "blacklist"));
        this.config.set("Behavior", (Object)(this.behavior == Behavior.STRICT ? "Strict" : "Vanilla"));
        this.config.set("Kick Message", (Object)this.kickMessage);
        this.config.set("Missing mod message", (Object)this.noHandshakeKickMessage);
        this.config.set("Missing whitelist mod message", (Object)this.missingWhitelistModMessage);
        this.config.set("Extra whitelist mod message", (Object)this.extraWhitelistModMessage);
        this.config.set("Invalid signature kick message", (Object)this.invalidSignatureKickMessage);
        this.config.set("Blacklisted Mods", new ArrayList<String>(this.blacklistedMods));
        this.config.set("Whitelisted Mods", new ArrayList<String>(this.whitelistedMods));
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save config.yml!");
        }
    }

    public static enum Mode {
        BLACKLIST,
        WHITELIST;

    }

    public static enum Behavior {
        STRICT,
        VANILLA;

    }

    public static enum IntegrityMode {
        SIGNED,
        DEV;

    }
}

