/*
 * Decompiled with CFR 0.152.
 */
package me.mklv.handshaker.paper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import me.mklv.handshaker.paper.BlacklistConfig;
import me.mklv.handshaker.paper.HandShakerPlugin;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class HandShakerCommand
implements TabExecutor {
    private final HandShakerPlugin plugin;

    public HandShakerCommand(HandShakerPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.sendUsage(sender);
            return true;
        }
        block8 : switch (args[0].toLowerCase(Locale.ROOT)) {
            case "reload": {
                this.plugin.getBlacklistConfig().load();
                sender.sendMessage("HandShaker config reloaded. Re-checking all online players.");
                this.plugin.checkAllPlayers();
                break;
            }
            case "mode": {
                if (args.length < 2) {
                    sender.sendMessage("Usage: /handshaker mode <blacklist|whitelist>");
                    return true;
                }
                switch (args[1].toLowerCase(Locale.ROOT)) {
                    case "blacklist": {
                        this.plugin.getBlacklistConfig().setMode(BlacklistConfig.Mode.BLACKLIST);
                        sender.sendMessage("HandShaker mode set to blacklist.");
                        this.plugin.checkAllPlayers();
                        break block8;
                    }
                    case "whitelist": {
                        this.plugin.getBlacklistConfig().setMode(BlacklistConfig.Mode.WHITELIST);
                        sender.sendMessage("HandShaker mode set to whitelist.");
                        this.plugin.checkAllPlayers();
                        break block8;
                    }
                }
                sender.sendMessage("Unknown mode. Use blacklist or whitelist.");
                break;
            }
            case "whitelist_update": {
                if (args.length < 2) {
                    sender.sendMessage("Usage: /handshaker whitelist_update <player>");
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target == null) {
                    sender.sendMessage("Player not found.");
                    return true;
                }
                Set<String> mods = this.plugin.getClientMods(target.getUniqueId());
                if (mods == null) {
                    sender.sendMessage("Mod list for " + target.getName() + " not found. Make sure they are online and using Fabric.");
                    return true;
                }
                this.plugin.getBlacklistConfig().setWhitelistedMods(mods);
                sender.sendMessage("Whitelist updated with " + target.getName() + "'s mods. " + mods.size() + " mods added.");
                this.plugin.checkAllPlayers();
                break;
            }
            case "remove": {
                if (args.length < 2) {
                    sender.sendMessage("Usage: /handshaker remove <mod>");
                    return true;
                }
                boolean removed = this.plugin.getBlacklistConfig().removeMod(args[1]);
                sender.sendMessage(removed ? "Removed " + args[1] : args[1] + " not found in blacklist.");
                break;
            }
            case "add": {
                if (args.length < 2) {
                    sender.sendMessage("Usage: /handshaker add <mod>");
                    return true;
                }
                boolean added = this.plugin.getBlacklistConfig().addMod(args[1]);
                sender.sendMessage(added ? "Added " + args[1] : args[1] + " already in blacklist.");
                if (!added) break;
                this.plugin.checkAllPlayers();
                break;
            }
            case "player": {
                if (args.length < 2) {
                    sender.sendMessage("Usage: /handshaker player <player> [mod]");
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target == null) {
                    sender.sendMessage("Player '" + args[1] + "' not found.");
                    return true;
                }
                Set<String> mods = this.plugin.getClientMods(target.getUniqueId());
                if (mods == null || mods.isEmpty()) {
                    sender.sendMessage("No mod list found for " + target.getName() + ".");
                    return true;
                }
                if (args.length == 2) {
                    sender.sendMessage(target.getName() + "'s mods: " + String.join((CharSequence)", ", mods));
                    return true;
                }
                if (args.length != 3) break;
                String modToBlock = args[2];
                if (!mods.contains(modToBlock)) {
                    sender.sendMessage(target.getName() + " does not have the mod '" + modToBlock + "'.");
                    return true;
                }
                boolean added = this.plugin.getBlacklistConfig().addMod(modToBlock);
                sender.sendMessage(added ? "Added " + modToBlock + " to the blacklist." : modToBlock + " is already in the blacklist.");
                if (!added) break;
                this.plugin.checkAllPlayers();
                break;
            }
            default: {
                this.sendUsage(sender);
            }
        }
        return true;
    }

    private void sendUsage(CommandSender sender) {
        sender.sendMessage("/handshaker reload | add <mod> | remove <mod> | player <player> [mod] | mode <b|w> | whitelist_update <player>");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        Set<String> clientMods;
        Player target;
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], Arrays.asList("reload", "add", "remove", "player", "mode", "whitelist_update"), new ArrayList());
        }
        if (args.length == 2) {
            switch (args[0].toLowerCase(Locale.ROOT)) {
                case "remove": {
                    return (List)StringUtil.copyPartialMatches((String)args[1], this.plugin.getBlacklistConfig().getBlacklistedMods(), new ArrayList());
                }
                case "add": {
                    Player p;
                    Set<String> clientMods2;
                    if (!(sender instanceof Player) || (clientMods2 = this.plugin.getClientMods((p = (Player)sender).getUniqueId())) == null) break;
                    ArrayList<String> suggestions = new ArrayList<String>(clientMods2);
                    suggestions.removeAll(this.plugin.getBlacklistConfig().getBlacklistedMods());
                    return (List)StringUtil.copyPartialMatches((String)args[1], suggestions, new ArrayList());
                }
                case "player": 
                case "whitelist_update": {
                    List playerNames = Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
                    return (List)StringUtil.copyPartialMatches((String)args[1], playerNames, new ArrayList());
                }
                case "mode": {
                    return (List)StringUtil.copyPartialMatches((String)args[1], Arrays.asList("blacklist", "whitelist"), new ArrayList());
                }
            }
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("player") && (target = Bukkit.getPlayer((String)args[1])) != null && (clientMods = this.plugin.getClientMods(target.getUniqueId())) != null) {
            ArrayList<String> suggestions = new ArrayList<String>(clientMods);
            suggestions.removeAll(this.plugin.getBlacklistConfig().getBlacklistedMods());
            return (List)StringUtil.copyPartialMatches((String)args[2], suggestions, new ArrayList());
        }
        return Collections.emptyList();
    }
}

