/*
 * Decompiled with CFR 0.152.
 */
package me.mklv.handshaker.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import me.mklv.handshaker.server.HandShakerServer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class BlacklistConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Behavior.class, (Object)new BehaviorDeserializer()).registerTypeAdapter(Mode.class, (Object)new ModeDeserializer()).registerTypeAdapter(IntegrityMode.class, (Object)new IntegrityModeDeserializer()).create();
    private final HandShakerServer server;
    private File configFile;
    private ConfigData configData;

    public BlacklistConfig(HandShakerServer server) {
        this.server = server;
    }

    public void load() {
        this.configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "hand-shaker.json");
        if (this.configFile.exists()) {
            try (FileReader reader = new FileReader(this.configFile);){
                this.configData = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
                if (this.configData == null) {
                    this.configData = new ConfigData();
                }
                if (this.configData.oldKickMode != null) {
                    this.configData.behavior = this.configData.oldKickMode == KickMode.ALL ? Behavior.STRICT : Behavior.VANILLA;
                    this.configData.oldKickMode = null;
                    this.save();
                }
            }
            catch (IOException e) {
                HandShakerServer.LOGGER.error("Failed to read blacklist config", (Throwable)e);
                this.configData = new ConfigData();
            }
        } else {
            this.configData = new ConfigData();
            this.save();
        }
    }

    public void save() {
        try (FileWriter writer = new FileWriter(this.configFile);){
            GSON.toJson((Object)this.configData, (Appendable)writer);
        }
        catch (IOException e) {
            HandShakerServer.LOGGER.error("Failed to save blacklist config", (Throwable)e);
        }
    }

    public IntegrityMode getIntegrityMode() {
        return this.configData.integrity;
    }

    public Mode getMode() {
        return this.configData.mode;
    }

    public Behavior getBehavior() {
        return this.configData.behavior;
    }

    public String getInvalidSignatureKickMessage() {
        return this.configData.invalidSignatureKickMessage;
    }

    public String getKickMessage() {
        return this.configData.kickMessage;
    }

    public String getNoHandshakeKickMessage() {
        return this.configData.noHandshakeKickMessage;
    }

    public String getMissingWhitelistModMessage() {
        return this.configData.missingWhitelistModMessage;
    }

    public String getExtraWhitelistModMessage() {
        return this.configData.extraWhitelistModMessage;
    }

    public Set<String> getBlacklistedMods() {
        return Collections.unmodifiableSet(this.configData.blacklistedMods);
    }

    public Set<String> getWhitelistedMods() {
        return Collections.unmodifiableSet(this.configData.whitelistedMods);
    }

    public void setMode(Mode mode) {
        this.configData.mode = mode;
        this.save();
    }

    public boolean addMod(String modId) {
        boolean added = this.configData.blacklistedMods.add(modId.toLowerCase(Locale.ROOT));
        if (added) {
            this.save();
        }
        return added;
    }

    public boolean removeMod(String modId) {
        boolean removed = this.configData.blacklistedMods.remove(modId.toLowerCase(Locale.ROOT));
        if (removed) {
            this.save();
        }
        return removed;
    }

    public void setWhitelist(Set<String> mods) {
        this.configData.whitelistedMods = new LinkedHashSet<String>();
        for (String mod : mods) {
            this.configData.whitelistedMods.add(mod.toLowerCase(Locale.ROOT));
        }
        this.save();
    }

    public void checkPlayer(class_3222 player, HandShakerServer.ClientInfo info) {
        boolean isFabric;
        if (info == null) {
            return;
        }
        boolean bl = isFabric = !info.mods().isEmpty();
        if (this.getBehavior() == Behavior.STRICT && !isFabric) {
            player.field_13987.method_52396(class_2561.method_30163((String)this.getNoHandshakeKickMessage()));
            return;
        }
        if (this.getIntegrityMode() == IntegrityMode.SIGNED && !info.signatureVerified()) {
            player.field_13987.method_52396(class_2561.method_30163((String)this.getInvalidSignatureKickMessage()));
            return;
        }
        Set<String> mods = info.mods();
        if (this.getMode() == Mode.BLACKLIST) {
            ArrayList<String> hits = new ArrayList<String>();
            for (String mod : this.getBlacklistedMods()) {
                if (!mods.contains(mod)) continue;
                hits.add(mod);
            }
            if (!hits.isEmpty()) {
                String msg = this.getKickMessage().replace("{mod}", String.join((CharSequence)", ", hits));
                player.field_13987.method_52396(class_2561.method_30163((String)msg));
            }
        } else if (isFabric || !this.getWhitelistedMods().isEmpty()) {
            Set<String> whitelistedMods = this.getWhitelistedMods();
            ArrayList<String> missing = new ArrayList<String>();
            for (String string : whitelistedMods) {
                if (mods.contains(string)) continue;
                missing.add(string);
            }
            if (!missing.isEmpty()) {
                String msg = this.getMissingWhitelistModMessage().replace("{mod}", String.join((CharSequence)", ", missing));
                player.field_13987.method_52396(class_2561.method_30163((String)msg));
                return;
            }
            ArrayList<String> extra = new ArrayList<String>();
            for (String mod : mods) {
                if (whitelistedMods.contains(mod)) continue;
                extra.add(mod);
            }
            if (!extra.isEmpty()) {
                String string = this.getExtraWhitelistModMessage().replace("{mod}", String.join((CharSequence)", ", extra));
                player.field_13987.method_52396(class_2561.method_30163((String)string));
            }
        }
    }

    private static class ConfigData {
        IntegrityMode integrity = IntegrityMode.SIGNED;
        Mode mode = Mode.BLACKLIST;
        Behavior behavior = Behavior.STRICT;
        @SerializedName(value="invalid_signature_kick_message")
        String invalidSignatureKickMessage = "Invalid client signature. Please use the official client.";
        @SerializedName(value="kick_message")
        String kickMessage = "You are using a blacklisted mod: {mod}. Please remove it to join this server.";
        @SerializedName(value="missing_mod_message")
        String noHandshakeKickMessage = "To connect to this server please download 'Hand-shaker' mod.";
        @SerializedName(value="missing_whitelist_mod_message")
        String missingWhitelistModMessage = "You are missing required mods: {mod}. Please install them to join this server.";
        @SerializedName(value="extra_whitelist_mod_message")
        String extraWhitelistModMessage = "You have mods that are not on the whitelist: {mod}. Please remove them to join.";
        @SerializedName(value="blacklisted_mods")
        Set<String> blacklistedMods = new LinkedHashSet<String>();
        @SerializedName(value="whitelisted_mods")
        Set<String> whitelistedMods = new LinkedHashSet<String>();
        @SerializedName(value="kickMode")
        KickMode oldKickMode = null;

        private ConfigData() {
        }
    }

    public static enum KickMode {
        ALL,
        FABRIC;

    }

    public static enum Behavior {
        STRICT,
        VANILLA;

    }

    public static enum IntegrityMode {
        SIGNED,
        DEV;

    }

    public static enum Mode {
        BLACKLIST,
        WHITELIST;

    }

    public static class BehaviorDeserializer
    implements JsonDeserializer<Behavior> {
        public Behavior deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return Behavior.valueOf(json.getAsString().toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                return Behavior.VANILLA;
            }
        }
    }

    public static class ModeDeserializer
    implements JsonDeserializer<Mode> {
        public Mode deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return Mode.valueOf(json.getAsString().toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                return Mode.BLACKLIST;
            }
        }
    }

    public static class IntegrityModeDeserializer
    implements JsonDeserializer<IntegrityMode> {
        public IntegrityMode deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return IntegrityMode.valueOf(json.getAsString().toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                return IntegrityMode.DEV;
            }
        }
    }
}

