/*
 * Decompiled with CFR 0.152.
 */
package me.mklv.handshaker.server;

import com.mojang.brigadier.CommandDispatcher;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.mklv.HandShaker;
import me.mklv.handshaker.server.BlacklistConfig;
import me.mklv.handshaker.server.HandShakerCommand;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandShakerServer
implements DedicatedServerModInitializer {
    public static final String MOD_ID = "hand-shaker";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"hand-shaker-server");
    private final Map<UUID, ClientInfo> clients = new ConcurrentHashMap<UUID, ClientInfo>();
    private BlacklistConfig blacklistConfig;
    private MinecraftServer server;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private byte[] serverCertificate;

    public void onInitializeServer() {
        LOGGER.info("HandShaker server initializing");
        this.blacklistConfig = new BlacklistConfig(this);
        this.blacklistConfig.load();
        this.loadServerCertificate();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            this.server = server;
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> this.scheduler.shutdown());
        PayloadTypeRegistry.playC2S().register(HandShaker.ModsListPayload.ID, HandShaker.ModsListPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(HandShaker.IntegrityPayload.ID, HandShaker.IntegrityPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(HandShaker.ModsListPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            HashSet<String> mods = new HashSet<String>(Arrays.asList(payload.mods().split(",")));
            if (payload.mods().isEmpty()) {
                mods.clear();
            }
            LOGGER.info("Received mod list from {}", (Object)player.method_5477().getString());
            this.clients.compute(player.method_5667(), (uuid, oldInfo) -> new ClientInfo(mods, oldInfo != null && oldInfo.signatureVerified()));
        });
        ServerPlayNetworking.registerGlobalReceiver(HandShaker.IntegrityPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            byte[] clientCertificate = payload.signature();
            boolean verified = false;
            if (clientCertificate != null && clientCertificate.length > 0 && this.serverCertificate.length > 0) {
                verified = Arrays.equals(clientCertificate, this.serverCertificate);
            }
            LOGGER.info("Integrity check for {}: {}", (Object)player.method_5477().getString(), (Object)(verified ? "PASSED" : "FAILED"));
            boolean finalVerified = verified;
            this.clients.compute(player.method_5667(), (uuid, oldInfo) -> new ClientInfo(oldInfo != null ? oldInfo.mods() : Collections.emptySet(), finalVerified));
            this.blacklistConfig.checkPlayer(player, this.clients.get(player.method_5667()));
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> this.scheduler.schedule(() -> server.execute(() -> {
            if (handler.field_14140.field_13987 == null) {
                return;
            }
            ClientInfo info = this.clients.computeIfAbsent(handler.field_14140.method_5667(), uuid -> new ClientInfo(Collections.emptySet(), false));
            this.blacklistConfig.checkPlayer(handler.field_14140, info);
        }), 5L, TimeUnit.SECONDS));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> this.clients.remove(handler.field_14140.method_5667()));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> HandShakerCommand.register((CommandDispatcher<class_2168>)dispatcher, this));
    }

    private void loadServerCertificate() {
        try (InputStream is = HandShakerServer.class.getClassLoader().getResourceAsStream("public.cer");){
            if (is == null) {
                if (this.blacklistConfig.getIntegrityMode() == BlacklistConfig.IntegrityMode.SIGNED) {
                    LOGGER.error("Could not find 'public.cer' in the mod JAR. Integrity checking will fail.");
                }
                this.serverCertificate = new byte[0];
                return;
            }
            this.serverCertificate = is.readAllBytes();
            LOGGER.info("Successfully loaded embedded server certificate ({} bytes)", (Object)this.serverCertificate.length);
        }
        catch (IOException e) {
            LOGGER.error("Failed to load embedded server certificate", (Throwable)e);
            this.serverCertificate = new byte[0];
        }
    }

    public BlacklistConfig getBlacklistConfig() {
        return this.blacklistConfig;
    }

    public Map<UUID, ClientInfo> getClients() {
        return this.clients;
    }

    public void checkAllPlayers() {
        if (this.server == null) {
            return;
        }
        LOGGER.info("Re-checking all online players...");
        for (class_3222 player : this.server.method_3760().method_14571()) {
            this.blacklistConfig.checkPlayer(player, this.clients.getOrDefault(player.method_5667(), new ClientInfo(Collections.emptySet(), false)));
        }
    }

    public record ClientInfo(Set<String> mods, boolean signatureVerified) {
    }
}

