/*
 * Decompiled with CFR 0.152.
 */
package me.mklv.handshaker.server;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.mklv.HandShaker;
import me.mklv.handshaker.server.BlacklistConfig;
import me.mklv.handshaker.server.HandShakerCommand;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandShakerServer
implements DedicatedServerModInitializer {
    public static final String MOD_ID = "hand-shaker";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"hand-shaker-server");
    private final Map<UUID, Set<String>> clientMods = new ConcurrentHashMap<UUID, Set<String>>();
    private BlacklistConfig blacklistConfig;
    private MinecraftServer server;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    public void onInitializeServer() {
        LOGGER.info("HandShaker server initializing");
        this.blacklistConfig = new BlacklistConfig(this);
        this.blacklistConfig.load();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            this.server = server;
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> this.scheduler.shutdown());
        PayloadTypeRegistry.playC2S().register(HandShaker.ModsListPayload.ID, HandShaker.ModsListPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(HandShaker.ModsListPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            HashSet<String> mods = new HashSet<String>(Arrays.asList(payload.mods().split(",")));
            if (payload.mods().isEmpty()) {
                mods.clear();
            }
            this.clientMods.put(player.method_5667(), mods);
            LOGGER.info("Received mod list from {}", (Object)player.method_5477().getString());
            this.blacklistConfig.checkPlayer(player, mods);
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> this.scheduler.schedule(() -> server.execute(() -> {
            if (handler.field_14140.field_13987 == null) {
                return;
            }
            if (!this.clientMods.containsKey(handler.field_14140.method_5667())) {
                this.blacklistConfig.checkPlayer(handler.field_14140, Collections.emptySet());
            }
        }), 5L, TimeUnit.SECONDS));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> this.clientMods.remove(handler.field_14140.method_5667()));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> HandShakerCommand.register((CommandDispatcher<class_2168>)dispatcher, this));
    }

    public BlacklistConfig getBlacklistConfig() {
        return this.blacklistConfig;
    }

    public Map<UUID, Set<String>> getClientMods() {
        return this.clientMods;
    }

    public void checkAllPlayers() {
        if (this.server == null) {
            return;
        }
        LOGGER.info("Re-checking all online players against the mod blacklist...");
        for (class_3222 player : this.server.method_3760().method_14571()) {
            this.blacklistConfig.checkPlayer(player, this.clientMods.getOrDefault(player.method_5667(), Collections.emptySet()));
        }
    }
}

