/*
 * Decompiled with CFR 0.152.
 */
package me.mklv.handshaker.paper;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.mklv.handshaker.paper.BlacklistConfig;
import me.mklv.handshaker.paper.HandShakerCommand;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class HandShakerPlugin
extends JavaPlugin
implements Listener {
    public static final String CHANNEL = "hand-shaker:mods";
    private final Map<UUID, ClientInfo> clients = new ConcurrentHashMap<UUID, ClientInfo>();
    private BlacklistConfig blacklistConfig;

    public void onEnable() {
        this.blacklistConfig = new BlacklistConfig(this);
        this.blacklistConfig.load();
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this, CHANNEL, (channel, player, message) -> this.handleModList(player, message));
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, CHANNEL);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        PluginCommand cmd = this.getCommand("handshaker");
        if (cmd != null) {
            cmd.setExecutor((CommandExecutor)new HandShakerCommand(this));
        }
        this.getLogger().info("HandShaker plugin enabled");
    }

    public BlacklistConfig getBlacklistConfig() {
        return this.blacklistConfig;
    }

    public Set<String> getClientMods(UUID uuid) {
        ClientInfo info = this.clients.get(uuid);
        return info != null ? info.mods : null;
    }

    public void onDisable() {
        Bukkit.getMessenger().unregisterIncomingPluginChannel((Plugin)this, CHANNEL);
        Bukkit.getMessenger().unregisterOutgoingPluginChannel((Plugin)this, CHANNEL);
        this.clients.clear();
    }

    private void handleModList(Player player, byte[] data) {
        String payload = this.decodeLengthPrefixedString(data);
        HashSet<String> mods = new HashSet<String>();
        if (payload != null && !payload.isBlank()) {
            for (String s : payload.split(",")) {
                if (s.isBlank()) continue;
                mods.add(s.trim().toLowerCase(Locale.ROOT));
            }
        }
        this.clients.put(player.getUniqueId(), new ClientInfo(true, mods));
        this.check(player);
    }

    private String decodeLengthPrefixedString(byte[] data) {
        try {
            byte read;
            int idx = 0;
            int numRead = 0;
            int result = 0;
            do {
                read = data[idx++];
                int value = read & 0x7F;
                result |= value << 7 * numRead;
                if (++numRead <= 5) continue;
                return null;
            } while ((read & 0x80) != 0);
            int length = result;
            if (length < 0 || idx + length > data.length) {
                return null;
            }
            return new String(data, idx, length, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to decode mods payload: " + e.getMessage());
            return null;
        }
    }

    private void check(Player player) {
        boolean shouldCheck;
        ClientInfo info = this.clients.get(player.getUniqueId());
        boolean isFabric = info != null && info.fabric;
        Set<Object> mods = info != null ? info.mods : Collections.emptySet();
        Set<String> blacklisted = this.blacklistConfig.getBlacklistedMods();
        BlacklistConfig.KickMode mode = this.blacklistConfig.getKickMode();
        boolean bl = shouldCheck = mode == BlacklistConfig.KickMode.ALL || mode == BlacklistConfig.KickMode.FABRIC && isFabric;
        if (!shouldCheck) {
            return;
        }
        ArrayList<String> hits = new ArrayList<String>();
        for (String mod : blacklisted) {
            if (!mods.contains(mod)) continue;
            hits.add(mod);
        }
        if (!hits.isEmpty()) {
            String msg = this.blacklistConfig.getKickMessage().replace("{mod}", String.join((CharSequence)", ", hits));
            player.kick(Component.text((String)msg).color((TextColor)NamedTextColor.RED));
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            this.clients.putIfAbsent(e.getPlayer().getUniqueId(), new ClientInfo(false, Collections.emptySet()));
            this.check(e.getPlayer());
        }, 100L);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        this.clients.remove(e.getPlayer().getUniqueId());
    }

    private record ClientInfo(boolean fabric, Set<String> mods) {
    }
}

