/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.rewrite.animation.controller;

import mod.azure.azurelibarmor.rewrite.animation.AzAnimationContext;
import mod.azure.azurelibarmor.rewrite.animation.controller.AzAnimationController;
import mod.azure.azurelibarmor.rewrite.animation.controller.state.machine.AzAnimationControllerStateMachine;

public class AzAnimationControllerTimer<T> {
    private final AzAnimationController<T> animationController;
    private double adjustedTick;
    private double tickOffset;

    public AzAnimationControllerTimer(AzAnimationController<T> animationController) {
        this.animationController = animationController;
    }

    public void update() {
        AzAnimationControllerStateMachine<T> stateMachine = this.animationController.stateMachine();
        AzAnimationContext animContext = ((AzAnimationControllerStateMachine.Context)stateMachine.getContext()).animationContext();
        double animationSpeed = this.animationController.animationProperties().animationSpeed();
        double tick = animContext.timer().getAnimTime();
        this.adjustedTick = animationSpeed * Math.max(tick - this.tickOffset, 0.0);
    }

    public void reset() {
        AzAnimationControllerStateMachine<T> stateMachine = this.animationController.stateMachine();
        AzAnimationContext animContext = ((AzAnimationControllerStateMachine.Context)stateMachine.getContext()).animationContext();
        this.tickOffset = animContext.timer().getAnimTime();
        this.adjustedTick = 0.0;
    }

    public double getAdjustedTick() {
        return this.adjustedTick;
    }

    public void addToAdjustedTick(double adjustedTick) {
        this.adjustedTick += adjustedTick;
    }
}

