/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.rewrite.animation.primitive;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mod.azure.azurelibarmor.rewrite.animation.controller.AzAnimationController;
import mod.azure.azurelibarmor.rewrite.animation.primitive.AzBakedAnimation;
import org.apache.commons.lang3.function.TriFunction;

@Deprecated(forRemoval=true)
public interface AzLoopType {
    public static final Map<String, AzLoopType> LOOP_TYPES = new ConcurrentHashMap<String, AzLoopType>(5);
    public static final AzLoopType FALSE = AzLoopType.register("false", (animatable, controller, currentAnimation) -> false);
    public static final AzLoopType TRUE = AzLoopType.register("true", (animatable, controller, currentAnimation) -> true);
    public static final AzLoopType PLAY_ONCE = AzLoopType.register("play_once", FALSE);
    public static final AzLoopType HOLD_ON_LAST_FRAME = AzLoopType.register("hold_on_last_frame", (animatable, controller, currentAnimation) -> {
        controller.stateMachine().pause();
        return true;
    });
    public static final AzLoopType LOOP = AzLoopType.register("loop", TRUE);

    public String name();

    public boolean shouldPlayAgain(Object var1, AzAnimationController<?> var2, AzBakedAnimation var3);

    public static AzLoopType fromJson(JsonElement json) {
        if (json == null || !json.isJsonPrimitive()) {
            return PLAY_ONCE;
        }
        JsonPrimitive primitive = json.getAsJsonPrimitive();
        if (primitive.isBoolean()) {
            return primitive.getAsBoolean() ? LOOP : PLAY_ONCE;
        }
        if (primitive.isString()) {
            return AzLoopType.fromString(primitive.getAsString());
        }
        return PLAY_ONCE;
    }

    public static AzLoopType fromString(String name) {
        return LOOP_TYPES.getOrDefault(name, PLAY_ONCE);
    }

    public static AzLoopType register(String name, AzLoopType loopType) {
        return AzLoopType.register(name, (a, b, c) -> loopType.shouldPlayAgain(a, (AzAnimationController<?>)b, (AzBakedAnimation)c));
    }

    public static AzLoopType register(final String name, final TriFunction<Object, AzAnimationController<?>, AzBakedAnimation, Boolean> shouldPlayAgainFunction) {
        AzLoopType loopType = new AzLoopType(){

            @Override
            public String name() {
                return name;
            }

            @Override
            public boolean shouldPlayAgain(Object animatable, AzAnimationController<?> controller, AzBakedAnimation currentAnimation) {
                return (Boolean)shouldPlayAgainFunction.apply(animatable, controller, (Object)currentAnimation);
            }
        };
        LOOP_TYPES.put(name, loopType);
        return loopType;
    }
}

