/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.rewrite.model;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mod.azure.azurelibarmor.rewrite.model.AzBone;
import org.jetbrains.annotations.Nullable;

public class AzBakedModel {
    public static final AzBakedModel EMPTY = new AzBakedModel(List.of());
    private final Map<String, AzBone> bonesByName;
    private final List<AzBone> topLevelBones;

    public AzBakedModel(List<AzBone> topLevelBones) {
        this.topLevelBones = Collections.unmodifiableList(topLevelBones);
        this.bonesByName = Collections.unmodifiableMap(this.mapBonesByName(topLevelBones));
    }

    private Map<String, AzBone> mapBonesByName(List<AzBone> bones) {
        HashMap<String, AzBone> bonesByName = new HashMap<String, AzBone>();
        ArrayDeque<AzBone> nodesToMap = new ArrayDeque<AzBone>(bones);
        while (!nodesToMap.isEmpty()) {
            AzBone currentBone = nodesToMap.poll();
            nodesToMap.addAll(currentBone.getChildBones());
            currentBone.saveInitialSnapshot();
            bonesByName.put(currentBone.getName(), currentBone);
        }
        return bonesByName;
    }

    @Nullable
    public AzBone getBoneOrNull(String name) {
        return this.bonesByName.get(name);
    }

    public Optional<AzBone> getBone(String name) {
        return Optional.ofNullable(this.getBoneOrNull(name));
    }

    public Map<String, AzBone> getBonesByName() {
        return this.bonesByName;
    }

    public List<AzBone> getTopLevelBones() {
        return this.topLevelBones;
    }
}

