/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.rewrite.render.item;

import mod.azure.azurelibarmor.rewrite.animation.impl.AzItemAnimator;
import mod.azure.azurelibarmor.rewrite.model.AzBakedModel;
import mod.azure.azurelibarmor.rewrite.render.AzProvider;
import mod.azure.azurelibarmor.rewrite.render.item.AzItemGuiRenderUtil;
import mod.azure.azurelibarmor.rewrite.render.item.AzItemRendererConfig;
import mod.azure.azurelibarmor.rewrite.render.item.AzItemRendererPipeline;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_918;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AzItemRenderer {
    private final AzItemRendererConfig config;
    private final AzProvider<class_1799> provider;
    private final AzItemRendererPipeline rendererPipeline;
    @Nullable
    private AzItemAnimator reusedAzItemAnimator;

    protected AzItemRenderer(AzItemRendererConfig config) {
        this.rendererPipeline = this.createPipeline(config);
        this.provider = new AzProvider<class_1799>(config::createAnimator, config::modelLocation);
        this.config = config;
    }

    protected AzItemRendererPipeline createPipeline(AzItemRendererConfig config) {
        return new AzItemRendererPipeline(config, this);
    }

    public void renderByGui(class_1799 stack, @NotNull class_4587 poseStack, @NotNull class_4597 source, int packedLight) {
        AzBakedModel model = this.provider.provideBakedModel(stack);
        this.prepareAnimator(stack, model);
        AzItemGuiRenderUtil.renderInGui(this.config, this.rendererPipeline, stack, model, stack, poseStack, source, packedLight);
    }

    public void renderByItem(class_1799 stack, @NotNull class_4587 poseStack, @NotNull class_4597 source, int packedLight) {
        AzBakedModel model = this.provider.provideBakedModel(stack);
        float partialTick = class_310.method_1551().method_60646().method_60636();
        class_2960 textureLocation = this.config.textureLocation(stack);
        class_1921 renderType = this.rendererPipeline.context().getDefaultRenderType(stack, textureLocation, source, partialTick);
        boolean withGlint = stack != null && stack.method_7958();
        class_4588 buffer = class_918.method_29711((class_4597)source, (class_1921)renderType, (boolean)false, (boolean)withGlint);
        this.prepareAnimator(stack, model);
        this.rendererPipeline.render(poseStack, model, stack, source, renderType, buffer, 0.0f, partialTick, packedLight);
    }

    private void prepareAnimator(class_1799 stack, AzBakedModel model) {
        AzItemAnimator cachedEntityAnimator = (AzItemAnimator)this.provider.provideAnimator(stack);
        if (cachedEntityAnimator != null && model != null) {
            cachedEntityAnimator.setActiveModel(model);
        }
        this.reusedAzItemAnimator = cachedEntityAnimator;
    }

    @Nullable
    public AzItemAnimator getAnimator() {
        return this.reusedAzItemAnimator;
    }

    public AzItemRendererConfig config() {
        return this.config;
    }
}

