/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.rewrite.render.item;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.azure.azurelibarmor.rewrite.animation.AzAnimator;
import mod.azure.azurelibarmor.rewrite.render.AzRendererConfig;
import mod.azure.azurelibarmor.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelibarmor.rewrite.render.layer.AzRenderLayer;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class AzItemRendererConfig
extends AzRendererConfig<class_1799> {
    private final boolean useEntityGuiLighting;
    private final boolean useNewOffset;

    private AzItemRendererConfig(Supplier<AzAnimator<class_1799>> animatorProvider, Function<class_1799, class_2960> modelLocationProvider, Function<class_1799, class_1921> renderTypeProvider, List<AzRenderLayer<class_1799>> renderLayers, Function<AzRendererPipelineContext<class_1799>, AzRendererPipelineContext<class_1799>> preRenderEntry, Function<AzRendererPipelineContext<class_1799>, AzRendererPipelineContext<class_1799>> postRenderEntry, Function<class_1799, class_2960> textureLocationProvider, Function<class_1799, Float> alphaFunction, Function<class_1799, Float> scaleHeight, Function<class_1799, Float> scaleWidth, boolean useEntityGuiLighting, boolean useNewOffset) {
        super(animatorProvider, modelLocationProvider, renderTypeProvider, renderLayers, preRenderEntry, postRenderEntry, textureLocationProvider, alphaFunction, scaleHeight, scaleWidth);
        this.useEntityGuiLighting = useEntityGuiLighting;
        this.useNewOffset = useNewOffset;
    }

    public boolean useEntityGuiLighting() {
        return this.useEntityGuiLighting;
    }

    public boolean useNewOffset() {
        return this.useNewOffset;
    }

    public static Builder builder(class_2960 modelLocation, class_2960 textureLocation) {
        return new Builder($ -> modelLocation, $ -> textureLocation);
    }

    public static Builder builder(Function<class_1799, class_2960> modelLocationProvider, Function<class_1799, class_2960> textureLocationProvider) {
        return new Builder(modelLocationProvider, textureLocationProvider);
    }

    public static class Builder
    extends AzRendererConfig.Builder<class_1799> {
        private boolean useEntityGuiLighting;
        private boolean useNewOffset;

        protected Builder(Function<class_1799, class_2960> modelLocationProvider, Function<class_1799, class_2960> textureLocationProvider) {
            super(modelLocationProvider, textureLocationProvider);
            this.renderTypeProvider = $ -> class_1921.method_29379((class_2960)((class_2960)textureLocationProvider.apply((class_1799)$)));
            this.useEntityGuiLighting = false;
            this.useNewOffset = false;
        }

        public Builder addRenderLayer(AzRenderLayer<class_1799> renderLayer) {
            return (Builder)super.addRenderLayer(renderLayer);
        }

        public Builder setRenderType(class_1921 renderType) {
            this.renderTypeProvider = $ -> renderType;
            return this;
        }

        public Builder setRenderType(Function<class_1799, class_1921> renderTypeProvider) {
            this.renderTypeProvider = renderTypeProvider;
            return this;
        }

        public Builder setPrerenderEntry(Function<AzRendererPipelineContext<class_1799>, AzRendererPipelineContext<class_1799>> preRenderEntry) {
            return (Builder)super.setPrerenderEntry(preRenderEntry);
        }

        public Builder setPostRenderEntry(Function<AzRendererPipelineContext<class_1799>, AzRendererPipelineContext<class_1799>> preRenderEntry) {
            return (Builder)super.setPostRenderEntry(preRenderEntry);
        }

        public Builder setAnimatorProvider(Supplier<@Nullable AzAnimator<class_1799>> animatorProvider) {
            return (Builder)super.setAnimatorProvider(animatorProvider);
        }

        public Builder useEntityGuiLighting() {
            this.useEntityGuiLighting = true;
            return this;
        }

        public Builder useNewOffset(boolean useNewOffset) {
            this.useNewOffset = useNewOffset;
            return this;
        }

        public Builder setAlpha(Function<class_1799, Float> alphaFunction) {
            return (Builder)super.setAlpha(alphaFunction);
        }

        public Builder setAlpha(float alpha) {
            return (Builder)super.setAlpha(alpha);
        }

        public Builder setScale(Function<class_1799, Float> scaleFunction) {
            return (Builder)super.setScale(scaleFunction);
        }

        public Builder setScale(Function<class_1799, Float> scaleHeightFunction, Function<class_1799, Float> scaleWidthFunction) {
            return (Builder)super.setScale(scaleHeightFunction, scaleWidthFunction);
        }

        public Builder setScale(float scale) {
            return (Builder)super.setScale(scale);
        }

        public Builder setScale(float scaleWidth, float scaleHeight) {
            return (Builder)super.setScale(scaleWidth, scaleHeight);
        }

        public AzItemRendererConfig build() {
            AzRendererConfig baseConfig = super.build();
            return new AzItemRendererConfig(baseConfig::createAnimator, baseConfig::modelLocation, baseConfig::getRenderType, baseConfig.renderLayers(), baseConfig::preRenderEntry, baseConfig::postRenderEntry, baseConfig::textureLocation, baseConfig::alpha, baseConfig::scaleHeight, baseConfig::scaleWidth, this.useEntityGuiLighting, this.useNewOffset);
        }
    }
}

