/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.animation.controller.keyframe;

import java.util.ArrayDeque;
import java.util.List;
import mod.azure.azurelibarmor.common.animation.controller.keyframe.AzAnimationPoint;
import mod.azure.azurelibarmor.common.animation.controller.keyframe.AzKeyframe;
import mod.azure.azurelibarmor.common.animation.controller.keyframe.AzKeyframeLocation;
import mod.azure.azurelibarmor.core.math.Constant;
import mod.azure.azurelibarmor.core.math.IValue;
import mod.azure.azurelibarmor.core.object.Axis;

public class AzAbstractKeyframeExecutor {
    private static final int MAX_POOL_SIZE = 512;
    private static final ArrayDeque<AzAnimationPoint> pointPool = new ArrayDeque(512);

    protected AzAbstractKeyframeExecutor() {
    }

    protected AzAnimationPoint getAnimationPointAtTick(List<AzKeyframe<IValue>> frames, double tick, boolean isRotation, Axis axis) {
        if (frames.isEmpty()) {
            return AzAbstractKeyframeExecutor.obtainPoint(null, 0.0, 0.0, 0.0, 0.0);
        }
        AzKeyframeLocation<AzKeyframe<IValue>> location = this.getCurrentKeyframeLocation(frames, tick);
        AzKeyframe<IValue> currentFrame = location.keyframe();
        double startValue = currentFrame.startValue().get();
        double endValue = currentFrame.endValue().get();
        if (isRotation) {
            if (!(currentFrame.startValue() instanceof Constant)) {
                startValue = Math.toRadians(startValue);
                if (axis == Axis.X || axis == Axis.Y) {
                    startValue *= -1.0;
                }
            }
            if (!(currentFrame.endValue() instanceof Constant)) {
                endValue = Math.toRadians(endValue);
                if (axis == Axis.X || axis == Axis.Y) {
                    endValue *= -1.0;
                }
            }
        }
        return AzAbstractKeyframeExecutor.obtainPoint(currentFrame, location.startTick(), currentFrame.length(), startValue, endValue);
    }

    protected AzKeyframeLocation<AzKeyframe<IValue>> getCurrentKeyframeLocation(List<AzKeyframe<IValue>> frames, double ageInTicks) {
        double totalFrameTime = 0.0;
        for (AzKeyframe<IValue> frame : frames) {
            if (!((totalFrameTime += frame.length()) > ageInTicks)) continue;
            return new AzKeyframeLocation<AzKeyframe<IValue>>(frame, ageInTicks - (totalFrameTime - frame.length()));
        }
        return new AzKeyframeLocation<AzKeyframe<IValue>>(frames.get(frames.size() - 1), ageInTicks);
    }

    protected static AzAnimationPoint obtainPoint(AzKeyframe<?> keyframe, double currentTick, double len, double start, double end) {
        AzAnimationPoint p = pointPool.pollFirst();
        if (p == null) {
            return new AzAnimationPoint(keyframe, currentTick, len, start, end);
        }
        p.reinit(keyframe, currentTick, len, start, end);
        return p;
    }

    protected static void recyclePoint(AzAnimationPoint point) {
        if (point == null) {
            return;
        }
        if (pointPool.size() < 512) {
            point.reset();
            pointPool.addFirst(point);
        }
    }
}

