/*
 * Decompiled with CFR 0.152.
 */
package com.interordi.iomawaba;

import com.interordi.iomawaba.bstats.bungeecord.Metrics;
import com.interordi.iomawaba.commands.GBan;
import com.interordi.iomawaba.commands.GBanIp;
import com.interordi.iomawaba.commands.GKick;
import com.interordi.iomawaba.commands.GTempBan;
import com.interordi.iomawaba.commands.GTempBanIp;
import com.interordi.iomawaba.commands.GUnban;
import com.interordi.iomawaba.commands.GUnbanIp;
import com.interordi.iomawaba.interfaces.PluginLogger;
import com.interordi.iomawaba.listeners.bungee.PlayersListener;
import com.interordi.iomawaba.modules.Bans;
import com.interordi.iomawaba.modules.PlayerActionsBungee;
import com.interordi.iomawaba.modules.PluginLoggerBungee;
import com.interordi.iomawaba.modules.Warnings;
import com.interordi.iomawaba.utilities.Database;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.time.ZoneId;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class IOMawabaBungee
extends Plugin {
    public static IOMawabaBungee instance;
    public Database db = null;
    public PluginLogger logger = null;
    public Warnings warnings;
    public Bans bans;

    public void onEnable() {
        Configuration configuration;
        File file;
        instance = this;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        if (!(file = new File(this.getDataFolder(), "config.yml")).exists()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (InputStream in = this.getResourceAsStream("config.yml");){
                    Files.copy(in, file.toPath(), new CopyOption[0]);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            configuration = ConfigurationProvider.getProvider(YamlConfiguration.class).load(new File(this.getDataFolder(), "config.yml"));
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to read the configuration file, stopping.");
            return;
        }
        this.logger = new PluginLoggerBungee();
        String dbHost = configuration.getString("database.host", null);
        int dbPort = configuration.getInt("database.port", 3306);
        String dbUsername = configuration.getString("database.username");
        String dbPassword = configuration.getString("database.password");
        String dbBase = configuration.getString("database.base");
        this.db = new Database(dbHost, dbPort, dbUsername, dbPassword, dbBase, this.logger);
        if (!this.db.init()) {
            this.getLogger().severe("---------------------------------");
            this.getLogger().severe("Failed to initialize the database");
            this.getLogger().severe("Make sure to configure config.yml");
            this.getLogger().severe("---------------------------------");
            return;
        }
        boolean bungeeUserBroadcast = configuration.getBoolean("bungee.use-broadcast", true);
        PlayerActionsBungee actions = new PlayerActionsBungee(this.db);
        actions.useBroadcast(bungeeUserBroadcast);
        PlayersListener pl = new PlayersListener();
        pl.setDatabase(this.db);
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)pl);
        ProxyServer.getInstance().getPluginManager().registerCommand((Plugin)this, (Command)new GKick(actions));
        ProxyServer.getInstance().getPluginManager().registerCommand((Plugin)this, (Command)new GTempBan(actions));
        ProxyServer.getInstance().getPluginManager().registerCommand((Plugin)this, (Command)new GTempBanIp(actions));
        ProxyServer.getInstance().getPluginManager().registerCommand((Plugin)this, (Command)new GBan(actions));
        ProxyServer.getInstance().getPluginManager().registerCommand((Plugin)this, (Command)new GBanIp(actions));
        ProxyServer.getInstance().getPluginManager().registerCommand((Plugin)this, (Command)new GUnban(actions));
        ProxyServer.getInstance().getPluginManager().registerCommand((Plugin)this, (Command)new GUnbanIp(actions));
        this.bans = new Bans(this.db);
        this.getLogger().info("System timezone: " + ZoneId.systemDefault());
        Metrics metrics = new Metrics(this, 27494);
        this.getLogger().info("IOMawaba enabled");
    }

    public void onDisable() {
        this.getLogger().info("IOMawaba disabled");
    }
}

