/*
 * Decompiled with CFR 0.152.
 */
package com.interordi.iomawaba;

import com.interordi.iomawaba.bstats.bukkit.Metrics;
import com.interordi.iomawaba.interfaces.PluginLogger;
import com.interordi.iomawaba.modules.Bans;
import com.interordi.iomawaba.modules.PlayerActionsSpigot;
import com.interordi.iomawaba.modules.PluginLoggerSpigot;
import com.interordi.iomawaba.modules.Warnings;
import com.interordi.iomawaba.utilities.CommandTargets;
import com.interordi.iomawaba.utilities.Commands;
import com.interordi.iomawaba.utilities.Database;
import com.interordi.iomawaba.utilities.StringUtils;
import java.time.ZoneId;
import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class IOMawabaSpigot
extends JavaPlugin {
    public static IOMawabaSpigot instance;
    public Database db = null;
    public PluginLogger logger = null;
    public Warnings warnings;
    public Bans bans;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.logger = new PluginLoggerSpigot();
        String dbHost = this.getConfig().getString("database.host", null);
        int dbPort = this.getConfig().getInt("database.port", 3306);
        String dbUsername = this.getConfig().getString("database.username");
        String dbPassword = this.getConfig().getString("database.password");
        String dbBase = this.getConfig().getString("database.base");
        this.db = new Database(dbHost, dbPort, dbUsername, dbPassword, dbBase, this.logger);
        if (!this.db.init()) {
            this.getLogger().severe("---------------------------------");
            this.getLogger().severe("Failed to initialize the database");
            this.getLogger().severe("Make sure to configure config.yml");
            this.getLogger().severe("---------------------------------");
            return;
        }
        PlayerActionsSpigot actions = new PlayerActionsSpigot(this.db);
        this.warnings = new Warnings(this, this.db);
        this.bans = new Bans(this.db);
        this.getLogger().info("System timezone: " + ZoneId.systemDefault());
        Metrics metrics = new Metrics(this, 27493);
        this.getLogger().info("IOMawaba enabled");
    }

    public void onDisable() {
        this.getLogger().info("IOMawaba disabled");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        CommandTargets results = Commands.findTargets(Bukkit.getServer(), sender, cmd, label, args);
        boolean result = false;
        if (results.position != -1) {
            Iterator<String> iterator = results.targets.iterator();
            while (iterator.hasNext()) {
                String target;
                args[results.position] = target = iterator.next();
                result = this.runCommand(sender, cmd, label, args);
            }
        } else {
            result = this.runCommand(sender, cmd, label, args);
        }
        return result;
    }

    public boolean runCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("warning") || cmd.getName().equalsIgnoreCase("w")) {
            if (!sender.hasPermission("iomawaba.warning")) {
                sender.sendMessage(ChatColor.RED + "You are not allowed to use this command.");
                return true;
            }
            Player target = null;
            String playerName = "";
            if (args.length < 1) {
                sender.sendMessage(ChatColor.RED + "Missing parameter: player name");
                return true;
            }
            playerName = args[0];
            if (args.length >= 2 && (args[1].equalsIgnoreCase("clear") || args[1].equalsIgnoreCase("clean"))) {
                this.warnings.clearWarning(playerName, sender);
            } else {
                target = this.getServer().getPlayer(playerName);
                if (target == null) {
                    sender.sendMessage(ChatColor.RED + "Target not found: " + playerName);
                    return true;
                }
                String message = "";
                if (args.length > 1) {
                    message = String.valueOf(message) + StringUtils.strJoin(args, " ", 1);
                }
                this.warnings.giveWarning(target, sender, message);
            }
            return true;
        }
        return false;
    }
}

